/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmpinterfacepoller;

import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpInterfacePollerConfig;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.discovery.IPAddress;
import org.opennms.netmgt.model.discovery.IPAddressRange;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventListener;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableInterface;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableNetwork;
import org.opennms.netmgt.snmpinterfacepoller.pollable.PollableSnmpInterface;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;

@EventListener(name="snmpPoller")
public class SnmpPoller
extends AbstractServiceDaemon {
    private static final SnmpPoller m_singleton = new SnmpPoller();
    private boolean m_initialized = false;
    private LegacyScheduler m_scheduler = null;
    private SnmpInterfacePollerConfig m_pollerConfig;
    private PollableNetwork m_network;

    public PollableNetwork getNetwork() {
        return this.m_network;
    }

    public void setNetwork(PollableNetwork pollableNetwork) {
        this.m_network = pollableNetwork;
    }

    public boolean isInitialized() {
        return this.m_initialized;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(LegacyScheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public SnmpInterfacePollerConfig getPollerConfig() {
        return this.m_pollerConfig;
    }

    public void setPollerConfig(SnmpInterfacePollerConfig snmpinterfacepollerConfig) {
        this.m_pollerConfig = snmpinterfacepollerConfig;
    }

    protected void onStart() {
        try {
            this.log().debug("onStart: Starting SNMP Interface Poller scheduler");
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            this.log().fatal("onStart: Failed to start scheduler", (Throwable)e);
            throw e;
        }
    }

    protected void onStop() {
        if (this.getScheduler() != null) {
            this.log().debug("onStop: stopping scheduler");
            this.getScheduler().stop();
        }
        this.setScheduler(null);
    }

    protected void onPause() {
        this.getScheduler().pause();
    }

    protected void onResume() {
        this.getScheduler().resume();
    }

    public static SnmpPoller getInstance() {
        return m_singleton;
    }

    public SnmpPoller() {
        super("OpenNMS.SnmpPoller");
    }

    protected void onInit() {
        this.createScheduler();
        try {
            this.log().debug("onInit: Scheduling existing SNMP interfaces polling");
            this.scheduleExistingSnmpInterface();
        }
        catch (Throwable sqlE) {
            this.log().error("onInit: Failed to schedule existing interfaces", sqlE);
        }
        this.m_initialized = true;
    }

    protected void scheduleNewSnmpInterface(String ipaddr) {
        for (OnmsIpInterface iface : this.getNetwork().getContext().getPollableNodesByIp(ipaddr)) {
            this.schedulePollableInterface(iface);
        }
    }

    protected void scheduleExistingSnmpInterface() {
        for (OnmsIpInterface iface : this.getNetwork().getContext().getPollableNodes()) {
            this.schedulePollableInterface(iface);
        }
    }

    protected void schedulePollableInterface(OnmsIpInterface iface) {
        String ipaddress = iface.getIpAddress().getHostAddress();
        Integer nodeid = iface.getNode().getId();
        if (ipaddress != null && !ipaddress.equals("0.0.0.0")) {
            String pkgName = this.getPollerConfig().getPackageName(ipaddress);
            if (pkgName != null) {
                this.log().debug("Scheduling snmppolling for node: " + nodeid + " ip address: " + ipaddress + " - Found package interface with name: " + pkgName);
                this.scheduleSnmpCollection(this.getNetwork().create(nodeid, ipaddress, pkgName), pkgName);
            } else if (!this.getPollerConfig().useCriteriaFilters()) {
                this.log().debug("No SNMP Poll Package found for node: " + nodeid + " ip address: " + ipaddress + ". - Scheduling according with default interval");
                this.scheduleSnmpCollection(this.getNetwork().create(nodeid, ipaddress, "null"), "null");
            }
        }
    }

    private void scheduleSnmpCollection(PollableInterface nodeGroup, String pkgName) {
        String excludingCriteria = new String(" snmpifindex > 0 ");
        for (String pkgInterfaceName : this.getPollerConfig().getInterfaceOnPackage(pkgName)) {
            this.log().debug("found package interface with name: " + pkgInterfaceName);
            if (this.getPollerConfig().getStatus(pkgName, pkgInterfaceName)) {
                String criteria = this.getPollerConfig().getCriteria(pkgName, pkgInterfaceName);
                this.log().debug("package interface: criteria: " + criteria);
                excludingCriteria = excludingCriteria + " and not " + criteria;
                long interval = this.getPollerConfig().getInterval(pkgName, pkgInterfaceName);
                this.log().debug("package interface: interval: " + interval);
                boolean hasPort = this.getPollerConfig().hasPort(pkgName, pkgInterfaceName);
                int port = -1;
                if (hasPort) {
                    port = this.getPollerConfig().getPort(pkgName, pkgInterfaceName);
                }
                boolean hasTimeout = this.getPollerConfig().hasTimeout(pkgName, pkgInterfaceName);
                int timeout = -1;
                if (hasTimeout) {
                    timeout = this.getPollerConfig().getTimeout(pkgName, pkgInterfaceName);
                }
                boolean hasRetries = this.getPollerConfig().hasRetries(pkgName, pkgInterfaceName);
                int retries = -1;
                if (hasRetries) {
                    retries = this.getPollerConfig().getRetries(pkgName, pkgInterfaceName);
                }
                boolean hasMaxVarsPerPdu = this.getPollerConfig().hasMaxVarsPerPdu(pkgName, pkgInterfaceName);
                int maxVarsPerPdu = -1;
                if (hasMaxVarsPerPdu) {
                    maxVarsPerPdu = this.getPollerConfig().getMaxVarsPerPdu(pkgName, pkgInterfaceName);
                }
                PollableSnmpInterface node = nodeGroup.createPollableSnmpInterface(pkgInterfaceName, criteria, hasPort, port, hasTimeout, timeout, hasRetries, retries, hasMaxVarsPerPdu, maxVarsPerPdu);
                node.setSnmpinterfaces(this.getNetwork().getContext().get(node.getParent().getNodeid(), criteria));
                this.getNetwork().schedule(node, interval, this.getScheduler());
                continue;
            }
            this.log().debug("package interface status: Off");
        }
        if (!this.getPollerConfig().useCriteriaFilters()) {
            this.log().debug("excluding criteria used for default polling: " + excludingCriteria);
            PollableSnmpInterface node = nodeGroup.createPollableSnmpInterface("null", excludingCriteria, false, -1, false, -1, false, -1, false, -1);
            node.setSnmpinterfaces(this.getNetwork().getContext().get(node.getParent().getNodeid(), excludingCriteria));
            this.getNetwork().schedule(node, this.getPollerConfig().getInterval(), this.getScheduler());
        }
    }

    private void createScheduler() {
        try {
            this.log().debug("init: Creating SNMP Interface Poller scheduler");
            this.setScheduler(new LegacyScheduler("Snmpinterfacepoller", this.getPollerConfig().getThreads()));
        }
        catch (RuntimeException e) {
            this.log().fatal("init: Failed to create SNMP interface poller scheduler", (Throwable)e);
            throw e;
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/configureSNMP")
    public void reloadSnmpConfig(Event event) {
        this.log().debug("reloadSnmpConfig: managing event: " + event.getUei());
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            LogUtils.debugf((Object)((Object)this), (Throwable)e, (String)"interrupted while waiting for reload", (Object[])new Object[0]);
            Thread.currentThread().interrupt();
        }
        SnmpEventInfo info = null;
        try {
            info = new SnmpEventInfo(event);
            if (StringUtils.isBlank((String)info.getFirstIPAddress())) {
                this.log().error("configureSNMPHandler: event contained invalid firstIpAddress.  " + event);
                return;
            }
        }
        catch (Throwable e) {
            this.log().error("reloadSnmpConfig: ", e);
            return;
        }
        IPAddressRange range = new IPAddressRange(info.getFirstIPAddress(), info.getLastIPAddress());
        for (IPAddress ipaddr : range) {
            this.log().debug("reloadSnmpConfig: found ipaddr: " + ipaddr);
            if (this.getNetwork().hasPollableInterface(ipaddr.toDbString())) {
                this.log().debug("reloadSnmpConfig: recreating the Interface to poll: " + ipaddr);
                this.getNetwork().delete(ipaddr.toDbString());
                this.scheduleNewSnmpInterface(ipaddr.toDbString());
                continue;
            }
            this.log().debug("reloadSnmpConfig: no Interface found for ipaddr: " + ipaddr);
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadSnmpPollerConfig")
    public void reloadConfig(Event event) {
        this.log().debug("reloadConfig: managing event: " + event.getUei());
        try {
            this.getPollerConfig().update();
            this.getNetwork().deleteAll();
            this.scheduleExistingSnmpInterface();
        }
        catch (Throwable e) {
            this.log().error("Update SnmpPoller configuration file failed", e);
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/primarySnmpInterfaceChanged")
    public void primarychangeHandler(Event event) {
        this.log().debug("primarychangeHandler: managing event: " + event.getUei());
        this.getNetwork().delete(new Long(event.getNodeid()).intValue());
        for (Parm parm : event.getParmCollection()) {
            if (!parm.isValid() || !parm.getParmName().equals("newPrimarySnmpAddress")) continue;
            this.scheduleNewSnmpInterface(parm.getValue().getContent());
            return;
        }
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/deleteInterface")
    public void deleteInterfaceHaldler(Event event) {
        this.getNetwork().delete(event.getInterface());
    }

    @EventHandler(uei="uei.opennms.org/internal/provisiond/nodeScanCompleted")
    public void scanCompletedHaldler(Event event) {
        this.getNetwork().refresh(new Long(event.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/internal/capsd/rescanCompleted")
    public void rescanCompletedHaldler(Event event) {
        this.getNetwork().refresh(new Long(event.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDeleted")
    public void nodeDeletedHandler(Event event) {
        this.getNetwork().delete(new Long(event.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeGainedService")
    public void serviceGainedHandler(Event event) {
        if (event.getService().equals(this.getPollerConfig().getService())) {
            this.getPollerConfig().rebuildPackageIpListMap();
            this.scheduleNewSnmpInterface(event.getInterface());
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeLostService")
    public void serviceDownHandler(Event event) {
        String service = event.getService();
        String[] criticalServices = this.getPollerConfig().getCriticalServiceIds();
        for (int i = 0; i < criticalServices.length; ++i) {
            if (!criticalServices[i].equals(service)) continue;
            this.log().info("Critical Service Lost: suspending SNMP polling for primary interface: " + event.getInterface());
            this.getNetwork().suspend(event.getInterface());
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeRegainedService")
    public void serviceUpHandler(Event event) {
        String service = event.getService();
        String[] criticalServices = this.getPollerConfig().getCriticalServiceIds();
        for (int i = 0; i < criticalServices.length; ++i) {
            if (!criticalServices[i].equals(service)) continue;
            this.log().info("Critical Service Regained: activate SNMP polling for primary interface: " + event.getInterface());
            this.getNetwork().activate(event.getInterface());
        }
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceUp")
    public void interfaceUpHandler(Event event) {
        this.getNetwork().activate(event.getInterface());
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceDown")
    public void interfaceDownHandler(Event event) {
        this.getNetwork().suspend(event.getInterface());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeUp")
    public void nodeUpHandler(Event event) {
        this.getNetwork().activate(new Long(event.getNodeid()).intValue());
    }

    @EventHandler(uei="uei.opennms.org/nodes/nodeDown")
    public void nodeDownHandler(Event event) {
        this.getNetwork().suspend(new Long(event.getNodeid()).intValue());
    }
}

