/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scheduler;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.springframework.util.Assert;

public class LegacyScheduler
implements Runnable,
PausableFiber,
Scheduler {
    private Map<Long, PeekableFifoQueue<ReadyRunnable>> m_queues;
    private int m_scheduled;
    private RunnableConsumerThreadPool m_runner;
    private int m_status;
    private Thread m_worker;

    public LegacyScheduler(String parent, int maxSize) {
        String name = parent + "Scheduler-" + maxSize;
        this.m_status = 0;
        this.m_runner = new RunnableConsumerThreadPool(name + " Pool", 0.6f, 1.0f, maxSize);
        this.m_queues = Collections.synchronizedMap(new TreeMap());
        this.m_scheduled = 0;
        this.m_worker = null;
    }

    public LegacyScheduler(String parent, int maxSize, float lowMark, float hiMark) {
        String name = parent + "Scheduler-" + maxSize;
        this.m_status = 0;
        this.m_runner = new RunnableConsumerThreadPool(name + " Pool", lowMark, hiMark, maxSize);
        this.m_queues = Collections.synchronizedMap(new TreeMap());
        this.m_scheduled = 0;
        this.m_worker = null;
    }

    public synchronized void schedule(ReadyRunnable runnable, long interval) {
        Long key;
        if (this.log().isDebugEnabled()) {
            this.log().debug("schedule: Adding ready runnable " + runnable + " at interval " + interval);
        }
        if (!this.m_queues.containsKey(key = new Long(interval))) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("schedule: interval queue did not exist, a new one has been created");
            }
            this.m_queues.put(key, new PeekableFifoQueue());
        }
        try {
            this.m_queues.get(key).add(runnable);
            if (this.m_scheduled++ == 0) {
                this.log().debug("schedule: queue element added, calling notify all since none were scheduled");
                this.notifyAll();
            } else if (this.log().isDebugEnabled()) {
                this.log().debug("schedule: queue element added, notification not performed");
            }
        }
        catch (InterruptedException e) {
            this.log().info("schedule: failed to add new ready runnable instance " + runnable + " to scheduler: " + e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (FifoQueueException e) {
            this.log().info("schedule: failed to add new ready runnable instance " + runnable + " to scheduler: " + (Object)((Object)e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public synchronized void schedule(long interval, final ReadyRunnable runnable) {
        final long timeToRun = this.getCurrentTime() + interval;
        ReadyRunnable timeKeeper = new ReadyRunnable(){

            @Override
            public boolean isReady() {
                return LegacyScheduler.this.getCurrentTime() >= timeToRun && runnable.isReady();
            }

            @Override
            public void run() {
                runnable.run();
            }

            public String toString() {
                return runnable.toString() + " (ready in " + Math.max(0L, timeToRun - LegacyScheduler.this.getCurrentTime()) + "ms)";
            }
        };
        this.schedule(timeKeeper, interval);
    }

    @Override
    public long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public synchronized void start() {
        Assert.state((this.m_worker == null ? 1 : 0) != 0, (String)"The fiber has already run or is running");
        this.m_runner.start();
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        this.m_status = 1;
        this.log().info("start: scheduler started");
    }

    @Override
    public synchronized void stop() {
        Assert.state((this.m_worker != null ? 1 : 0) != 0, (String)"The fiber has never been started");
        this.m_status = 3;
        this.m_worker.interrupt();
        this.m_runner.stop();
        this.log().info("stop: scheduler stopped");
    }

    @Override
    public synchronized void pause() {
        Assert.state((this.m_worker != null ? 1 : 0) != 0, (String)"The fiber has never been started");
        Assert.state((this.m_status != 4 && this.m_status != 3 ? 1 : 0) != 0, (String)"The fiber is not running or a stop is pending");
        if (this.m_status == 6) {
            return;
        }
        this.m_status = 5;
        this.notifyAll();
    }

    @Override
    public synchronized void resume() {
        Assert.state((this.m_worker != null ? 1 : 0) != 0, (String)"The fiber has never been started");
        Assert.state((this.m_status != 4 && this.m_status != 3 ? 1 : 0) != 0, (String)"The fiber is not running or a stop is pending");
        if (this.m_status == 2) {
            return;
        }
        this.m_status = 7;
        this.notifyAll();
    }

    @Override
    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return this.m_runner.getName();
    }

    public int getScheduled() {
        return this.m_scheduled;
    }

    public RunnableConsumerThreadPool getRunner() {
        return this.m_runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LegacyScheduler legacyScheduler = this;
        synchronized (legacyScheduler) {
            this.m_status = 2;
        }
        this.log().debug("run: scheduler running");
        while (true) {
            legacyScheduler = this;
            synchronized (legacyScheduler) {
                if (this.m_status != 2 && this.m_status != 6 && this.m_status != 5 && this.m_status != 7) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: status = " + this.m_status + ", time to exit");
                    }
                    break;
                }
                while (this.m_status == 5 || this.m_status == 6) {
                    if (this.m_status == 5) {
                        this.log().debug("run: pausing.");
                    }
                    this.m_status = 6;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                if (this.m_status == 7) {
                    this.log().debug("run: resuming.");
                    this.m_status = 2;
                }
                if (this.m_scheduled == 0) {
                    try {
                        this.log().debug("run: no ready runnables scheduled, waiting...");
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
            int runned = 0;
            FifoQueue out = this.m_runner.getRunQueue();
            Object object = this.m_queues;
            synchronized (object) {
                for (Map.Entry<Long, PeekableFifoQueue<ReadyRunnable>> entry : this.m_queues.entrySet()) {
                    PeekableFifoQueue<ReadyRunnable> in = entry.getValue();
                    ReadyRunnable readyRun = null;
                    int maxLoops = in.size();
                    do {
                        try {
                            readyRun = in.peek();
                            if (readyRun == null || !readyRun.isReady()) continue;
                            if (this.log().isDebugEnabled()) {
                                this.log().debug("run: found ready runnable " + readyRun);
                            }
                            in.remove();
                            out.add((Object)readyRun);
                            ++runned;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        catch (FifoQueueException e) {
                            throw new UndeclaredThrowableException(e);
                        }
                    } while (readyRun != null && readyRun.isReady() && --maxLoops > 0);
                }
            }
            object = this;
            synchronized (object) {
                this.m_scheduled -= runned;
                if (runned == 0) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
        this.log().debug("run: scheduler exiting, state = STOPPED");
        LegacyScheduler legacyScheduler2 = this;
        synchronized (legacyScheduler2) {
            this.m_status = 4;
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public static final class PeekableFifoQueue<T>
    extends FifoQueueImpl<T> {
        private T m_hold = null;

        PeekableFifoQueue() {
        }

        public synchronized T peek() throws InterruptedException, FifoQueueException {
            if (this.m_hold == null) {
                this.m_hold = super.remove(1L);
            }
            return this.m_hold;
        }

        public synchronized T remove() throws InterruptedException, FifoQueueException {
            Object rval = null;
            if (this.m_hold != null) {
                rval = this.m_hold;
                this.m_hold = null;
            } else {
                rval = super.remove();
            }
            return (T)rval;
        }

        public synchronized T remove(long timeout) throws InterruptedException, FifoQueueException {
            Object rval = null;
            if (this.m_hold != null) {
                rval = this.m_hold;
                this.m_hold = null;
            } else {
                rval = super.remove(timeout);
            }
            return (T)rval;
        }
    }
}

