/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.Scope;
import org.opennms.netmgt.xml.event.Event;

public class PendingPollEvent
extends PollEvent {
    private Event m_event;
    private boolean m_pending = true;
    private List<Runnable> m_pendingOutages = new LinkedList<Runnable>();

    public PendingPollEvent(Event event) {
        super(Scope.fromUei(event.getUei()));
        this.m_event = event;
    }

    @Override
    public Date getDate() {
        try {
            return EventConstants.parseToDate((String)this.m_event.getTime());
        }
        catch (ParseException e) {
            ThreadCategory.getInstance(this.getClass()).error("Unable to convert event time to date", (Throwable)e);
            return new Date();
        }
    }

    @Override
    public int getEventId() {
        return this.m_event.getDbid();
    }

    public void addPending(Runnable r) {
        if (this.m_pending) {
            this.m_pendingOutages.add(r);
        } else {
            r.run();
        }
    }

    public Event getEvent() {
        return this.m_event;
    }

    public boolean isPending() {
        return this.m_pending;
    }

    public void complete(Event e) {
        this.m_pending = false;
    }

    public void processPending() {
        for (Runnable r : this.m_pendingOutages) {
            r.run();
        }
        this.m_pendingOutages.clear();
    }

    public String toString() {
        return this.m_event + ", uei: " + this.m_event.getUei() + ", id: " + this.m_event.getDbid() + ", isPending: " + this.m_pending + ", list size: " + this.m_pendingOutages.size();
    }
}

