/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.passive.jmx;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.sql.SQLException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.passive.PassiveStatusKeeper;
import org.opennms.netmgt.passive.jmx.PassiveStatusdMBean;

public class PassiveStatusd
extends AbstractServiceDaemon
implements PassiveStatusdMBean {
    public static final String NAME = "OpenNMS.PassiveStatusKeeper";

    public PassiveStatusd() {
        super(NAME);
    }

    protected void onInit() {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        try {
            DataSourceFactory.init();
        }
        catch (MarshalException e) {
            log.error("Could not unmarshall configuration", (Throwable)e);
        }
        catch (ValidationException e) {
            log.error("validation error ", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IOException: ", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to initialize database: " + e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            log.error("SQLException: ", (Throwable)e);
        }
        catch (PropertyVetoException e) {
            log.error("PropertyVetoException: " + e.getMessage(), (Throwable)e);
        }
        EventIpcManagerFactory.init();
        EventIpcManager mgr = EventIpcManagerFactory.getIpcManager();
        PassiveStatusKeeper keeper = this.getPassiveStatusKeeper();
        keeper.setEventManager(mgr);
        keeper.setDataSource(DataSourceFactory.getInstance());
        keeper.init();
    }

    protected void onStart() {
        this.getPassiveStatusKeeper().start();
    }

    protected void onStop() {
        this.getPassiveStatusKeeper().stop();
    }

    public int getStatus() {
        return this.getPassiveStatusKeeper().getStatus();
    }

    private PassiveStatusKeeper getPassiveStatusKeeper() {
        return PassiveStatusKeeper.getInstance();
    }
}

