/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.microblog.MicroblogProfile;
import org.opennms.netmgt.dao.MicroblogConfigurationDao;
import org.opennms.netmgt.dao.castor.DefaultMicroblogConfigurationDao;
import org.opennms.netmgt.notifd.NotificationStrategy;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;

public class MicroblogNotificationStrategy
implements NotificationStrategy {
    private static final String UBLOG_PROFILE_NAME = "notifd";
    protected MicroblogConfigurationDao m_microblogConfigurationDao;
    protected MicroblogConfigurationDao m_configDao = new DefaultMicroblogConfigurationDao();

    public MicroblogNotificationStrategy() throws IOException {
        this(MicroblogNotificationStrategy.findDefaultConfigResource());
    }

    public MicroblogNotificationStrategy(Resource configResource) {
        ((DefaultMicroblogConfigurationDao)this.m_configDao).setConfigResource(configResource);
        ((DefaultMicroblogConfigurationDao)this.m_configDao).afterPropertiesSet();
        this.setMicroblogConfigurationDao(this.m_configDao);
    }

    @Override
    public int send(List<Argument> arguments) {
        Status response;
        Twitter svc = this.buildUblogService(arguments);
        String messageBody = this.buildMessageBody(arguments);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Dispatching microblog notification for user '" + svc.getUserId() + "' at base URL '" + svc.getBaseURL() + "' with message '" + messageBody + "'");
        }
        try {
            response = svc.updateStatus(messageBody);
        }
        catch (TwitterException e) {
            this.log().error("Microblog notification failed");
            this.log().info("Failed to update status for user '" + svc.getUserId() + "' at service URL '" + svc.getBaseURL() + "', caught exception: " + e.getMessage());
            return 1;
        }
        this.log().info("Microblog notification succeeded: update posted with ID " + response.getId());
        return 0;
    }

    protected Twitter buildUblogService(List<Argument> arguments) {
        MicroblogProfile profile = null;
        String serviceUrl = "";
        String authenUser = "";
        String authenPass = "";
        profile = this.m_microblogConfigurationDao.getProfile(UBLOG_PROFILE_NAME);
        if (profile == null) {
            profile = this.m_microblogConfigurationDao.getDefaultProfile();
        }
        if (profile == null) {
            this.log().fatal("Unable to find a microblog profile called 'notifd', and default profile does not exist; we cannot send microblog notifications!");
            throw new RuntimeException("Could not find a usable microblog profile.");
        }
        this.log().info("Using microblog profile with name '" + profile.getName() + "'");
        serviceUrl = profile.getServiceUrl();
        authenUser = profile.getAuthenUsername();
        authenPass = profile.getAuthenPassword();
        if (authenUser == null || "".equals(authenUser)) {
            this.log().warn("Working with a blank username, perhaps you forgot to set this in the microblog configuration?");
        }
        if (authenPass == null || "".equals(authenPass)) {
            this.log().warn("Working with a blank password, perhaps you forgot to set this in the microblog configuration?");
        }
        if (serviceUrl == null || "".equals(serviceUrl)) {
            throw new IllegalArgumentException("Cannot use a blank microblog service URL, perhaps you forgot to set this in the microblog configuration?");
        }
        Twitter svc = new Twitter();
        svc.setBaseURL(serviceUrl);
        svc.setSource("OpenNMS");
        svc.setUserId(authenUser);
        svc.setPassword(authenPass);
        return svc;
    }

    protected String buildMessageBody(List<Argument> arguments) {
        String messageBody = null;
        for (Argument arg : arguments) {
            if ("-tm".equals(arg.getSwitch())) {
                messageBody = arg.getValue();
                continue;
            }
            if (!"-nm".equals(arg.getSwitch()) || messageBody != null) continue;
            messageBody = arg.getValue();
        }
        if (messageBody == null) {
            throw new IllegalArgumentException("No message specified, but is required");
        }
        messageBody = messageBody.replaceAll("\\s+", " ");
        if (this.log().isDebugEnabled()) {
            this.log().debug("Final message body after collapsing whitespace is: '" + messageBody + "'");
        }
        return messageBody;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    protected String findDestName(List<Argument> arguments) {
        for (Argument arg : arguments) {
            if (!"-ublog".equals(arg.getSwitch())) continue;
            this.log().debug("Found destination microblog name: " + arg.getSwitch());
            return arg.getValue();
        }
        this.log().debug("No destination microblog name found");
        return null;
    }

    protected static Resource findDefaultConfigResource() throws IOException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MICROBLOG_CONFIG_FILE_NAME);
        return new FileSystemResource(configFile);
    }

    public void setMicroblogConfigurationDao(MicroblogConfigurationDao dao) {
        this.m_microblogConfigurationDao = dao;
    }

    public MicroblogConfigurationDao getMicroblogConfigurationDao() {
        return this.m_microblogConfigurationDao;
    }
}

