/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.Date;

public class TimeInterval
implements Comparable<TimeInterval> {
    private Date m_start;
    private Date m_end;

    public TimeInterval(Date start, Date end) {
        if (start == null) {
            throw new NullPointerException("start is null");
        }
        if (end == null) {
            throw new NullPointerException("end is null");
        }
        if (start.compareTo(end) >= 0) {
            throw new IllegalArgumentException("start (" + start + ") must come strictly before end (" + end + ")");
        }
        this.m_start = start;
        this.m_end = end;
    }

    public Date getStart() {
        return this.m_start;
    }

    public Date getEnd() {
        return this.m_end;
    }

    public int comparesTo(Date date) {
        if (date.before(this.m_start)) {
            return 1;
        }
        if (date.after(this.m_end) || date.equals(this.m_end)) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return "[" + this.m_start + " - " + this.m_end + ']';
    }

    public boolean equals(Object o) {
        if (o instanceof TimeInterval) {
            TimeInterval t = (TimeInterval)o;
            return this.m_start.equals(t.m_start) && this.m_end.equals(t.m_end);
        }
        return false;
    }

    public int hashCode() {
        return this.m_start.hashCode() ^ this.m_end.hashCode();
    }

    @Override
    public int compareTo(TimeInterval t) {
        if (t.m_end.before(this.m_start) || t.m_end.equals(this.m_start)) {
            return 1;
        }
        if (t.m_start.after(this.m_end) || t.m_start.equals(this.m_end)) {
            return -1;
        }
        return 0;
    }

    boolean preceeds(TimeInterval interval) {
        return this.compareTo(interval) < 0;
    }

    boolean follows(TimeInterval interval) {
        return this.compareTo(interval) > 0;
    }

    boolean overlaps(TimeInterval interval) {
        return this.compareTo(interval) == 0;
    }
}

