/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.Attr;
import org.opennms.netmgt.config.BeanInfo;
import org.opennms.netmgt.config.JMXDataCollectionConfigDao;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.config.collectd.jmx.Mbeans;
import org.opennms.netmgt.model.RrdRepository;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public final class JMXDataCollectionConfigFactory {
    private static JMXDataCollectionConfigFactory m_singleton = null;
    private JmxDatacollectionConfig m_config;
    private static boolean m_loaded = false;
    private Map<String, Map<String, Mbean>> m_collectionGroupMap;
    private Map<String, JmxCollection> m_collectionMap;

    public JMXDataCollectionConfigFactory(InputStream stream) {
        this.initialize((Resource)new InputStreamResource(stream));
    }

    private JMXDataCollectionConfigFactory(String configFile) throws IOException {
        this.initialize((Resource)new FileSystemResource(configFile));
    }

    private void initialize(Resource resource) {
        JMXDataCollectionConfigDao dao = new JMXDataCollectionConfigDao();
        dao.setConfigResource(resource);
        dao.afterPropertiesSet();
        this.m_config = dao.getConfig();
        this.buildCollectionMap();
    }

    private void buildCollectionMap() {
        this.m_collectionMap = new HashMap<String, JmxCollection>();
        this.m_collectionGroupMap = new HashMap<String, Map<String, Mbean>>();
        List collections = this.m_config.getJmxCollectionCollection();
        for (JmxCollection collection : collections) {
            HashMap<String, Mbean> groupMap = new HashMap<String, Mbean>();
            Mbeans mbeans = collection.getMbeans();
            List groupList = mbeans.getMbeanCollection();
            for (Mbean mbean : groupList) {
                groupMap.put(mbean.getName(), mbean);
            }
            this.m_collectionGroupMap.put(collection.getName(), groupMap);
            this.m_collectionMap.put(collection.getName(), collection);
        }
    }

    public static synchronized void init() throws IOException {
        if (m_loaded) {
            return;
        }
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.JMX_DATA_COLLECTION_CONF_FILE_NAME);
            ThreadCategory.getInstance(JMXDataCollectionConfigFactory.class).debug("init: config file path: " + cfgFile.getPath());
            m_singleton = new JMXDataCollectionConfigFactory(cfgFile.getPath());
        }
        catch (IOException ioe) {
            JMXDataCollectionConfigFactory.log().error("Unable to open JMX data collection config file", (Throwable)ioe);
            throw ioe;
        }
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException {
        m_singleton = null;
        m_loaded = false;
        JMXDataCollectionConfigFactory.init();
    }

    public static synchronized JMXDataCollectionConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(JMXDataCollectionConfigFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public Map<String, List<Attrib>> getAttributeMap(String cName, String aSysoid, String anAddress) {
        ThreadCategory log = JMXDataCollectionConfigFactory.log();
        HashMap<String, List<Attrib>> attributeMap = new HashMap<String, List<Attrib>>();
        if (log.isDebugEnabled()) {
            log.debug("getMibObjectList: collection: " + cName + " sysoid: " + aSysoid + " address: " + anAddress);
        }
        if (aSysoid == null) {
            if (log.isDebugEnabled()) {
                log.debug("getMibObjectList: aSysoid parameter is NULL...");
            }
            return attributeMap;
        }
        JmxCollection collection = this.m_collectionMap.get(cName);
        if (collection == null) {
            return attributeMap;
        }
        Mbeans beans = collection.getMbeans();
        Enumeration en = beans.enumerateMbean();
        while (en.hasMoreElements()) {
            ArrayList<Attrib> list = new ArrayList<Attrib>();
            Mbean mbean = (Mbean)en.nextElement();
            Attrib[] attributes = mbean.getAttrib();
            for (int i = 0; i < attributes.length; ++i) {
                list.add(attributes[i]);
            }
            CompAttrib[] compAttributes = mbean.getCompAttrib();
            for (int i = 0; i < compAttributes.length; ++i) {
                CompMember[] compMembers = compAttributes[i].getCompMember();
                for (int j = 0; j < compMembers.length; ++j) {
                    Attrib compAttrib = new Attrib();
                    compAttrib.setName(compAttributes[i].getName() + "|" + compMembers[j].getName());
                    compAttrib.setAlias(compMembers[j].getAlias());
                    compAttrib.setType(compMembers[j].getType());
                    list.add(compAttrib);
                }
            }
            attributeMap.put(mbean.getObjectname(), list);
        }
        return attributeMap;
    }

    public Map<String, BeanInfo> getMBeanInfo(String cName) {
        HashMap<String, BeanInfo> map = new HashMap<String, BeanInfo>();
        JmxCollection collection = this.m_collectionMap.get(cName);
        if (collection == null) {
            JMXDataCollectionConfigFactory.log().warn("no collection named '" + cName + "' was found");
        } else {
            Mbeans beans = collection.getMbeans();
            Enumeration en = beans.enumerateMbean();
            while (en.hasMoreElements()) {
                BeanInfo beanInfo = new BeanInfo();
                Mbean mbean = (Mbean)en.nextElement();
                beanInfo.setMbeanName(mbean.getName());
                beanInfo.setObjectName(mbean.getObjectname());
                beanInfo.setKeyField(mbean.getKeyfield());
                beanInfo.setExcludes(mbean.getExclude());
                beanInfo.setKeyAlias(mbean.getKeyAlias());
                Attrib[] attributes = mbean.getAttrib();
                CompAttrib[] compositeAttributes = mbean.getCompAttrib();
                ArrayList<String> attribNameList = new ArrayList<String>();
                ArrayList<String> compAttribNameList = new ArrayList<String>();
                CompAttrib[] arr$ = compositeAttributes;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    CompMember[] compositeMembers;
                    CompAttrib compAttrib;
                    CompAttrib myCa = compAttrib = arr$[i$];
                    CompMember[] arr$2 = compositeMembers = myCa.getCompMember();
                    int len$2 = arr$2.length;
                    for (int i$2 = 0; i$2 < len$2; ++i$2) {
                        CompMember cm;
                        CompMember myCm = cm = arr$2[i$2];
                        attribNameList.add(myCa.getName() + "|" + myCm.getName());
                        compAttribNameList.add(myCa.getName() + "|" + myCm.getName());
                    }
                }
                for (CompAttrib compAttrib : attributes) {
                    Attrib myA = (Attrib)compAttrib;
                    attribNameList.add(myA.getName());
                }
                beanInfo.setAttributes(attribNameList);
                beanInfo.setCompositeAttributes(compAttribNameList);
                map.put(mbean.getObjectname(), beanInfo);
            }
        }
        return map;
    }

    public Map<String, String[]> getMBeanInfo_save(String cName) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        JmxCollection collection = this.m_collectionMap.get(cName);
        Mbeans beans = collection.getMbeans();
        Enumeration en = beans.enumerateMbean();
        while (en.hasMoreElements()) {
            Mbean mbean = (Mbean)en.nextElement();
            int count = mbean.getAttribCount();
            String[] attribs = new String[count];
            Attrib[] attributes = mbean.getAttrib();
            for (int i = 0; i < attributes.length; ++i) {
                attribs[i] = attributes[i].getName();
            }
            map.put(mbean.getObjectname(), attribs);
        }
        return map;
    }

    static void processObjectList(List<Attrib> objectList, List<Attr> mibObjectList) {
        for (Attrib mibObj : objectList) {
            Attr aMibObject = new Attr();
            aMibObject.setName(mibObj.getName());
            aMibObject.setAlias(mibObj.getAlias());
            aMibObject.setType(mibObj.getType());
            aMibObject.setMaxval(mibObj.getMaxval());
            aMibObject.setMinval(mibObj.getMinval());
            if (mibObjectList.contains(aMibObject)) continue;
            mibObjectList.add(aMibObject);
        }
    }

    public int getStep(String cName) {
        JmxCollection collection = this.m_collectionMap.get(cName);
        if (collection != null) {
            return collection.getRrd().getStep();
        }
        return -1;
    }

    public List<String> getRRAList(String cName) {
        JmxCollection collection = this.m_collectionMap.get(cName);
        if (collection != null) {
            return collection.getRrd().getRraCollection();
        }
        return null;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdPath()));
        repo.setRraList(this.getRRAList(collectionName));
        repo.setStep(this.getStep(collectionName));
        repo.setHeartBeat(2 * this.getStep(collectionName));
        return repo;
    }

    public String getRrdPath() {
        String rrdPath = this.m_config.getRrdRepository();
        if (rrdPath == null) {
            throw new RuntimeException("Configuration error, failed to retrieve path to RRD repository.");
        }
        if (rrdPath.endsWith(File.separator)) {
            rrdPath = rrdPath.substring(0, rrdPath.length() - File.separator.length());
        }
        return rrdPath;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(JMXDataCollectionConfigFactory.class);
    }
}

