/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.config.StorageStrategy;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.snmp.SnmpInstId;

public class GenericIndexResource
extends SnmpCollectionResource {
    private SnmpInstId m_inst;
    private String m_name;
    private String m_resourceLabel;

    public GenericIndexResource(ResourceType def, String name, SnmpInstId inst) {
        super(def);
        this.m_name = name;
        this.m_inst = inst;
    }

    @Override
    public File getResourceDir(RrdRepository repository) {
        String resourcePath = this.getStrategy().getRelativePathForAttribute(this.getParent(), this.getLabel(), null);
        File resourceDir = new File(repository.getRrdBaseDir(), resourcePath);
        this.log().debug("getResourceDir: " + resourceDir);
        return resourceDir;
    }

    public String toString() {
        return "node[" + this.getCollectionAgent().getNodeId() + "]." + this.getResourceTypeName() + "[" + this.getInstance() + "]";
    }

    @Override
    public int getType() {
        return -1;
    }

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        return ((GenericIndexResourceType)this.getResourceType()).getPersistenceSelectorStrategy().shouldPersist(this);
    }

    public String getResourceTypeName() {
        return this.m_name;
    }

    public String getInstance() {
        return this.m_inst.toString();
    }

    private StorageStrategy getStrategy() {
        return ((GenericIndexResourceType)this.getResourceType()).getStorageStrategy();
    }

    public String getParent() {
        return String.valueOf(this.getCollectionAgent().getNodeId());
    }

    public String getLabel() {
        if (this.m_resourceLabel == null) {
            this.m_resourceLabel = this.getStrategy().getResourceNameFromIndex((CollectionResource)this);
        }
        return this.m_resourceLabel;
    }
}

