/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;

public final class ReparentViaSmb {
    static final String SQL_DB_RETRIEVE_NODES = "SELECT nodeid,nodenetbiosname FROM node WHERE nodeType!='D' AND nodenetbiosname is not null ORDER BY nodeid";
    static final String SQL_DB_RETRIEVE_NODE = "SELECT nodesysname,nodesysdescription,nodelabel,nodelabelsource FROM node WHERE nodeid=? AND nodeType!='D'";
    static final String SQL_DB_RETRIEVE_INTERFACES = "SELECT ipaddr,iphostname FROM ipinterface WHERE nodeid=? AND isManaged!='D'";
    static final String SQL_DB_REPARENT_IP_INTERFACE = "UPDATE ipinterface SET nodeID=? WHERE nodeID=? AND isManaged!='D'";
    static final String SQL_DB_REPARENT_SNMP_INTERFACE = "UPDATE snmpinterface SET nodeID=? WHERE nodeID=?";
    static final String SQL_DB_REPARENT_IF_SERVICES = "UPDATE ifservices SET nodeID=? WHERE nodeID=? AND status!='D'";
    static final String SQL_DB_DELETE_NODE = "UPDATE node SET nodeType='D' WHERE nodeID=?";
    private Connection m_connection;
    private List<LightWeightNodeEntry> m_existingNodeList;
    private Map<LightWeightNodeEntry, List<LightWeightIfEntry>> m_reparentedIfMap;
    private Map<LightWeightNodeEntry, List<LightWeightNodeEntry>> m_reparentNodeMap;
    private static List<String> m_netbiosNamesToSkip = new ArrayList<String>(4);

    public ReparentViaSmb(Connection connection) {
        this.m_connection = connection;
        this.m_existingNodeList = null;
        this.m_reparentedIfMap = null;
        this.m_reparentNodeMap = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildNodeLists() throws SQLException {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        this.m_existingNodeList = new ArrayList<LightWeightNodeEntry>();
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = this.m_connection.prepareStatement(SQL_DB_RETRIEVE_NODES);
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                this.m_existingNodeList.add(new LightWeightNodeEntry(rs.getInt(1), rs.getString(2)));
            }
        }
        finally {
            d.cleanUp();
        }
        for (LightWeightNodeEntry outerEntry : this.m_existingNodeList) {
            String outerNetbiosName = outerEntry.getNetbiosName();
            if (outerNetbiosName == null || m_netbiosNamesToSkip.contains(outerNetbiosName) || outerEntry.isDuplicate()) continue;
            ArrayList<LightWeightNodeEntry> duplicateNodeList = null;
            for (LightWeightNodeEntry innerEntry : this.m_existingNodeList) {
                String innerNetbiosName = innerEntry.getNetbiosName();
                if (innerEntry.getNodeId() <= outerEntry.getNodeId() || innerNetbiosName == null || m_netbiosNamesToSkip.contains(innerNetbiosName) || innerEntry.isDuplicate() || !innerNetbiosName.equals(outerNetbiosName)) continue;
                if (duplicateNodeList == null) {
                    duplicateNodeList = new ArrayList<LightWeightNodeEntry>();
                }
                innerEntry.setDuplicate(true);
                duplicateNodeList.add(innerEntry);
                if (!log.isDebugEnabled()) continue;
                log.debug("ReparentViaSmb.retrieveNodeData: found that nodeid " + innerEntry.getNodeId() + " is a duplicate of nodeid " + outerEntry.getNodeId());
            }
            if (duplicateNodeList == null) continue;
            if (this.m_reparentNodeMap == null) {
                this.m_reparentNodeMap = new HashMap<LightWeightNodeEntry, List<LightWeightNodeEntry>>();
            }
            if (log.isDebugEnabled()) {
                log.debug("ReparentViaSmb.retrieveNodeData: adding dup list w/ " + duplicateNodeList.size() + " to reparent Map for reparent nodeid " + outerEntry.getNodeId());
            }
            this.m_reparentNodeMap.put(outerEntry, duplicateNodeList);
        }
    }

    public void sync() throws SQLException {
        this.buildNodeLists();
        if (this.m_reparentNodeMap != null && !this.m_reparentNodeMap.isEmpty()) {
            this.reparentInterfaces();
            if (this.m_reparentedIfMap != null && !this.m_reparentedIfMap.isEmpty()) {
                this.generateEvents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparentInterfaces() throws SQLException {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        ArrayList<LightWeightIfEntry> reparentedIfList = null;
        this.m_reparentedIfMap = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement ipInterfaceStmt = this.m_connection.prepareStatement(SQL_DB_REPARENT_IP_INTERFACE);
            d.watch((Object)ipInterfaceStmt);
            PreparedStatement snmpInterfaceStmt = this.m_connection.prepareStatement(SQL_DB_REPARENT_SNMP_INTERFACE);
            d.watch((Object)snmpInterfaceStmt);
            PreparedStatement ifServicesStmt = this.m_connection.prepareStatement(SQL_DB_REPARENT_IF_SERVICES);
            d.watch((Object)ifServicesStmt);
            Set<LightWeightNodeEntry> keys = this.m_reparentNodeMap.keySet();
            for (LightWeightNodeEntry reparentNode : keys) {
                int reparentNodeID = reparentNode.getNodeId();
                reparentNode.setHeavyWeightNodeEntry(DbNodeEntry.get(reparentNodeID));
                List<LightWeightNodeEntry> dupList = this.m_reparentNodeMap.get(reparentNode);
                log.debug("ReparentViaSmb.retrieveNodeData: duplicate node list retrieved, list size=" + dupList.size());
                for (LightWeightNodeEntry dupNode : dupList) {
                    int dupNodeID = dupNode.getNodeId();
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("reparentInterfaces: reparenting all interfaces/services for nodeID " + dupNodeID + " under reparent nodeID " + reparentNodeID);
                        }
                        PreparedStatement stmt = this.m_connection.prepareStatement(SQL_DB_RETRIEVE_INTERFACES);
                        d.watch((Object)stmt);
                        stmt.setInt(1, dupNodeID);
                        if (log.isDebugEnabled()) {
                            log.debug("reparentInterfaces: issuing db query...");
                        }
                        ResultSet rs = stmt.executeQuery();
                        d.watch((Object)rs);
                        while (rs.next()) {
                            String ifAddress = rs.getString(1);
                            String hostName = rs.getString(2);
                            LightWeightIfEntry lwIfEntry = new LightWeightIfEntry(ifAddress, hostName, reparentNodeID, dupNodeID);
                            if (reparentedIfList == null) {
                                reparentedIfList = new ArrayList<LightWeightIfEntry>();
                            }
                            reparentedIfList.add(lwIfEntry);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("reparentInterfaces: will reparent " + lwIfEntry.getAddress() + " : oldNodeId: " + lwIfEntry.getOldParentNodeId() + " newNodeId: " + lwIfEntry.getParentNodeId());
                        }
                        ipInterfaceStmt.setInt(1, reparentNodeID);
                        ipInterfaceStmt.setInt(2, dupNodeID);
                        ipInterfaceStmt.executeUpdate();
                        snmpInterfaceStmt.setInt(1, reparentNodeID);
                        snmpInterfaceStmt.setInt(2, dupNodeID);
                        snmpInterfaceStmt.executeUpdate();
                        ifServicesStmt.setInt(1, reparentNodeID);
                        ifServicesStmt.setInt(2, dupNodeID);
                        ifServicesStmt.executeUpdate();
                    }
                    catch (SQLException sqlE) {
                        log.error("SQLException while reparenting duplicate node w/ nodeID " + dupNodeID);
                        throw sqlE;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("reparentInterfaces: deleting duplicate node id: " + dupNodeID);
                    }
                    PreparedStatement deleteNodeStmt = this.m_connection.prepareStatement(SQL_DB_DELETE_NODE);
                    d.watch((Object)deleteNodeStmt);
                    deleteNodeStmt.setInt(1, dupNodeID);
                    deleteNodeStmt.executeUpdate();
                }
                if (reparentedIfList == null || reparentedIfList.isEmpty()) continue;
                if (this.m_reparentedIfMap == null) {
                    this.m_reparentedIfMap = new HashMap<LightWeightNodeEntry, List<LightWeightIfEntry>>();
                }
                this.m_reparentedIfMap.put(reparentNode, (List<LightWeightIfEntry>)reparentedIfList);
            }
        }
        finally {
            d.cleanUp();
        }
    }

    private void generateEvents() {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("generateEvents:  Generating reparent events...reparentedIfMap size: " + this.m_reparentedIfMap.size());
        }
        Set<LightWeightNodeEntry> keys = this.m_reparentedIfMap.keySet();
        for (LightWeightNodeEntry reparentNode : keys) {
            List<LightWeightIfEntry> ifList;
            if (!reparentNode.hasHeavyWeightNodeEntry()) {
                log.warn("generateEvents:  No valid reparent node entry for node " + reparentNode.getNodeId() + ". Unable to generate reparenting events.");
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("generateEvents: generating events for reparent node w/ id/netbiosName: " + reparentNode.getNodeId() + "/" + reparentNode.getNetbiosName());
            }
            if ((ifList = this.m_reparentedIfMap.get(reparentNode)) == null || ifList.isEmpty()) continue;
            for (LightWeightIfEntry lwIfEntry : ifList) {
                this.sendInterfaceReparentedEvent(lwIfEntry.getAddress(), lwIfEntry.getHostName(), lwIfEntry.getParentNodeId(), lwIfEntry.getOldParentNodeId(), reparentNode.getHeavyWeightNodeEntry());
                if (!log.isDebugEnabled()) continue;
                log.debug("generateEvents: sent interfaceReparented event for interface " + lwIfEntry.getAddress());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("generateEvents: completed all event generation...");
        }
    }

    private synchronized void sendInterfaceReparentedEvent(String ipAddr, String ipHostName, int newNodeId, int oldNodeId, DbNodeEntry reparentNodeEntry) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        if (log.isDebugEnabled()) {
            log.debug("sendInterfaceReparentedEvent: ipAddr: " + ipAddr + " ipHostName: " + ipHostName + " newNodeId: " + newNodeId + " oldNodeId: " + oldNodeId);
        }
        if (ipHostName == null) {
            ipHostName = "";
        }
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/interfaceReparented", "OpenNMS.Capsd");
        bldr.setNodeid((long)newNodeId);
        bldr.setHost(Capsd.getLocalHostAddress());
        bldr.setInterface(InetAddressUtils.addr((String)ipAddr));
        bldr.addParam("iphostname", ipHostName);
        bldr.addParam("oldNodeID", oldNodeId);
        bldr.addParam("newNodeID", newNodeId);
        bldr.addParam("nodelabel", reparentNodeEntry.getLabel());
        bldr.addParam("nodelabelsource", reparentNodeEntry.getLabelSource());
        if (reparentNodeEntry.getSystemName() != null) {
            bldr.addParam("nodesysname", reparentNodeEntry.getSystemName());
        }
        if (reparentNodeEntry.getSystemDescription() != null) {
            bldr.addParam("nodesysdescription", reparentNodeEntry.getSystemDescription());
        }
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(bldr.getEvent());
        }
        catch (Throwable t) {
            log.warn("run: unexpected throwable exception caught during send to middleware", t);
        }
    }

    static {
        m_netbiosNamesToSkip.add("WORKSTATION");
        m_netbiosNamesToSkip.add("DEFAULT");
        m_netbiosNamesToSkip.add("OEMCOMPUTER");
        m_netbiosNamesToSkip.add("COMPUTER");
    }

    private static final class LightWeightNodeEntry {
        private int m_nodeId;
        private String m_netbiosName;
        private boolean m_duplicate;
        private DbNodeEntry m_hwNodeEntry;

        LightWeightNodeEntry(int nodeID, String netbiosName) {
            this.m_nodeId = nodeID;
            this.m_netbiosName = netbiosName != null ? netbiosName.toUpperCase() : null;
            this.m_duplicate = false;
            this.m_hwNodeEntry = null;
        }

        int getNodeId() {
            return this.m_nodeId;
        }

        String getNetbiosName() {
            return this.m_netbiosName;
        }

        void setDuplicate(boolean dupFlag) {
            this.m_duplicate = dupFlag;
        }

        boolean isDuplicate() {
            return this.m_duplicate;
        }

        void setHeavyWeightNodeEntry(DbNodeEntry hwNodeEntry) {
            this.m_hwNodeEntry = hwNodeEntry;
        }

        DbNodeEntry getHeavyWeightNodeEntry() {
            return this.m_hwNodeEntry;
        }

        boolean hasHeavyWeightNodeEntry() {
            return this.m_hwNodeEntry != null;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof LightWeightNodeEntry)) {
                return false;
            }
            LightWeightNodeEntry node = (LightWeightNodeEntry)o;
            if (this.m_netbiosName == null || node.getNetbiosName() == null) {
                return false;
            }
            return node.getNetbiosName().equals(this.m_netbiosName);
        }

        public int hashCode() {
            return new HashCodeBuilder(7, 23).append(this.m_nodeId).append((Object)this.m_netbiosName).append(this.m_duplicate).append((Object)this.m_hwNodeEntry).toHashCode();
        }
    }

    private static final class LightWeightIfEntry {
        private String m_address;
        private String m_hostname;
        private int m_nodeId;
        private int m_oldNodeId;

        public LightWeightIfEntry(String address, String hostname, int nodeId, int oldNodeId) {
            this.m_address = address;
            this.m_hostname = hostname;
            this.m_nodeId = nodeId;
            this.m_oldNodeId = oldNodeId;
        }

        public String getAddress() {
            return this.m_address;
        }

        public String getHostName() {
            return this.m_hostname;
        }

        public int getParentNodeId() {
            return this.m_nodeId;
        }

        public int getOldParentNodeId() {
            return this.m_oldNodeId;
        }
    }
}

