/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.util.Date;
import org.opennms.netmgt.config.threshd.Threshold;
import org.opennms.netmgt.threshd.AbstractThresholdEvaluatorTestCase;
import org.opennms.netmgt.threshd.BaseThresholdDefConfigWrapper;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.MockCollectionResourceWrapper;
import org.opennms.netmgt.threshd.ThresholdConfigWrapper;
import org.opennms.netmgt.threshd.ThresholdEvaluatorRelativeChange;
import org.opennms.netmgt.threshd.ThresholdEvaluatorState;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.ThrowableAnticipator;

public class ThresholdEvaluatorRelativeChangeTest
extends AbstractThresholdEvaluatorTestCase {
    public void testConstructor() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(0.9);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
    }

    public void testConstructorThresholdNull() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("threshold argument cannot be null"));
        try {
            new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testEvaluateOnce() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(0.9);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
    }

    public void testEvaluateTwiceNoTrigger() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(0.9);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
    }

    public void testEvaluateTwiceTriggerLowBelow() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(0.9);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(8.0));
    }

    public void testEvaluateTwiceTriggerLowEqual() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(0.9);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(9.0));
    }

    public void testEvaluateTwiceNoTriggerLowAbove() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(0.9);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(9.5));
    }

    public void testEvaluateTwiceTriggerHighAbove() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.1);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(12.0));
    }

    public void testEvaluateTwiceTriggerHighEqual() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.1);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(11.0));
    }

    public void testEvaluateTwiceNoTriggerHighBelow() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.1);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(10.5));
    }

    public void testEvaluateTwiceNoTriggerHighFirstZero() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.1);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger on first evaluate", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(0.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger on second evaluate", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(1000.0));
    }

    public void testEvaluateThriceTriggerHighFirstZero() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.1);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger on first evaluate", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(0.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger on second evaluate", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(1000.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should trigger on third evaluate", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(1200.0));
    }

    public void testGetEventForStateNoChange() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.1);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertNull((String)"should not have created an event", (Object)evaluator.getEventForState(ThresholdEvaluatorState.Status.NO_CHANGE, new Date(), 10.0, null));
    }

    public void testGetEventForStateTriggered() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.1);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(8.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(10.0));
        Event event = evaluator.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 10.0, null);
        ThresholdEvaluatorRelativeChangeTest.assertNotNull((String)"should have created an event", (Object)event);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"UEIs should be the same", (String)"uei.opennms.org/threshold/relativeChangeExceeded", (String)event.getUei());
        ThresholdEvaluatorRelativeChangeTest.assertNotNull((String)"event should have parms", (Object)event.getParmCollection());
        ThresholdEvaluatorRelativeChangeTest.parmPresentAndValueNonNull(event, "instance");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "value", "10.0");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "previousValue", "8.0");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "multiplier", "1.1");
        event = evaluator.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 10.0, (CollectionResourceWrapper)new MockCollectionResourceWrapper("testInstance"));
        ThresholdEvaluatorRelativeChangeTest.assertNotNull((String)"should have created an event", (Object)event);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"UEIs should be the same", (String)"uei.opennms.org/threshold/relativeChangeExceeded", (String)event.getUei());
        ThresholdEvaluatorRelativeChangeTest.assertNotNull((String)"event should have parms", (Object)event.getParmCollection());
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "instance", "testInstance");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "value", "10.0");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "previousValue", "8.0");
        ThresholdEvaluatorRelativeChangeTest.parmPresentWithValue(event, "multiplier", "1.1");
    }

    public void testGetEventForStateDefaultUEIS() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(99.0);
        threshold.setRearm(95.0);
        threshold.setTrigger(1);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange item = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Event event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 100.0, null);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"UEI should be the relativeChangeThresholdTriggerd", (String)"uei.opennms.org/threshold/relativeChangeExceeded", (String)event.getUei());
    }

    public void testGetEventForStateCustomUEIS() {
        String triggeredUEI = "uei.opennms.org/custom/relativeChangeThresholdTriggered";
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(99.0);
        threshold.setRearm(95.0);
        threshold.setTrigger(1);
        threshold.setTriggeredUEI(triggeredUEI);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange item = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        Event event = item.getEventForState(ThresholdEvaluatorState.Status.TRIGGERED, new Date(), 100.0, null);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"UEI should be the uei.opennms.org/custom/relativeChangeThresholdTriggered", (String)triggeredUEI, (String)event.getUei());
    }

    public void testNegativeNumberTriggers() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.1);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(-10.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should trigger", (Object)ThresholdEvaluatorState.Status.TRIGGERED, (Object)evaluator.evaluate(-12.0));
    }

    public void testNegativeNumberNotTriggers() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(1.1);
        threshold.setRearm(0.5);
        threshold.setTrigger(3);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(-10.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(-10.5));
    }

    public void testNegativeValueNoChange() {
        Threshold threshold = new Threshold();
        threshold.setType("relativeChange");
        threshold.setDsName("ds-name");
        threshold.setDsType("ds-type");
        threshold.setValue(0.9);
        threshold.setRearm(0.5);
        threshold.setTrigger(1);
        ThresholdConfigWrapper wrapper = new ThresholdConfigWrapper(threshold);
        ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange evaluator = new ThresholdEvaluatorRelativeChange.ThresholdEvaluatorStateRelativeChange((BaseThresholdDefConfigWrapper)wrapper);
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(-10.0));
        ThresholdEvaluatorRelativeChangeTest.assertEquals((String)"should not trigger", (Object)ThresholdEvaluatorState.Status.NO_CHANGE, (Object)evaluator.evaluate(-10.0));
    }
}

