/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.netmgt.mock.MockMonitoredService;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.PageSequenceMonitor;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:META-INF/opennms/emptyContext.xml"})
public class PageSequenceMonitorOpenNMSTest {
    PageSequenceMonitor m_monitor;
    Map<String, Object> m_params;

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_monitor = new PageSequenceMonitor();
        this.m_monitor.initialize(Collections.emptyMap());
        this.m_params = new HashMap<String, Object>();
        this.m_params.put("timeout", "8000");
        this.m_params.put("retries", "1");
    }

    protected MonitoredService getHttpService(String hostname) throws Exception {
        return this.getHttpService(hostname, InetAddress.getByName(hostname));
    }

    protected MonitoredService getHttpService(String hostname, InetAddress inetAddress) throws Exception {
        MockMonitoredService svc = new MockMonitoredService(1, hostname, inetAddress, "HTTP");
        this.m_monitor.initialize((MonitoredService)svc);
        return svc;
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testOpenNMSUserInterface() throws Exception {
        String line;
        StringBuffer config = new StringBuffer();
        LineNumberReader in = new LineNumberReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("opennmsPageSequence.xml"), "UTF-8"));
        while ((line = in.readLine()) != null) {
            config.append(line);
        }
        this.m_params.put("page-sequence", config.toString());
        this.m_params.put("virtualHost", "localhost");
        this.m_params.put("port", "8980");
        this.m_params.put("adminUsername", "admin");
        this.m_params.put("adminPassword", "admin");
        PollStatus status = this.m_monitor.poll(this.getHttpService("localhost"), this.m_params);
        Assert.assertTrue((String)("Expected available but was " + status + ": reason = " + status.getReason()), (boolean)status.isAvailable());
    }
}

