/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd.mock;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.UserManager;

public class MockUserManager
extends UserManager {
    String m_xmlString;
    boolean updateNeeded = true;
    private long m_lastModified;

    public MockUserManager(GroupManager groupManager, String xmlString) throws MarshalException, ValidationException {
        super(groupManager);
        this.m_xmlString = xmlString;
        this.parseXML();
    }

    private void parseXML() throws MarshalException, ValidationException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.m_xmlString.getBytes());
        this.parseXML(in);
        this.updateNeeded = false;
        this.m_lastModified = System.currentTimeMillis();
    }

    protected void saveXML(String writerString) throws IOException {
        this.m_xmlString = writerString;
        this.updateNeeded = true;
    }

    public void update() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (this.updateNeeded) {
            this.parseXML();
        }
    }

    public boolean isUpdateNeeded() {
        return this.updateNeeded;
    }

    public long getLastModified() {
        return this.m_lastModified;
    }
}

