/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerProxy;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class EventIpcManagerProxyTest
extends TestCase {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private EventIpcManagerProxy m_proxy = new EventIpcManagerProxy();
    private EventListener m_eventListener = (EventListener)this.m_mocks.createMock(EventListener.class);

    public void testAddEventListenerNoProxySet() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property delegate not set; has the event daemon successfully started?"));
        try {
            this.m_proxy.addEventListener(this.m_eventListener);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    public void testAddEventListenerWithProxySet() {
        EventIpcManager delegate = (EventIpcManager)EasyMock.createMock(EventIpcManager.class);
        this.m_proxy.setDelegate(delegate);
        delegate.addEventListener(this.m_eventListener);
        this.m_mocks.replayAll();
        this.m_proxy.addEventListener(this.m_eventListener);
        this.m_mocks.verifyAll();
    }
}

