/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.io.InputStream;
import java.net.InetAddress;
import javax.sql.DataSource;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.netmgt.capsd.BroadcastEventProcessor;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.capsd.CapsdDbSyncer;
import org.opennms.netmgt.capsd.DefaultProcessorFactory;
import org.opennms.netmgt.capsd.JdbcCapsdDbSyncer;
import org.opennms.netmgt.capsd.PluginManager;
import org.opennms.netmgt.capsd.RescanProcessorFactory;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessorFactory;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.DefaultCapsdConfigManager;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.model.events.AnnotationBasedEventListenerAdapter;
import org.opennms.netmgt.model.events.EventSubscriptionService;
import org.opennms.netmgt.model.events.StoppableEventListener;
import org.opennms.test.ConfigurationTestUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;

public class CapsdTest
extends OpenNMSTestCase {
    private static final int FOREIGN_NODEID = 77;
    private Capsd m_capsd;
    private MockSnmpAgent m_agent;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_agent = MockSnmpAgent.createAgentAndRun((Resource)new ClassPathResource("org/opennms/netmgt/snmp/snmpTestData1.properties"), (String)(InetAddressUtils.str((InetAddress)this.myLocalHost()) + "/9161"));
        InputStream configStream = ConfigurationTestUtils.getInputStreamForConfigFile((String)"database-schema.xml");
        DatabaseSchemaConfigFactory.setInstance((DatabaseSchemaConfigFactory)new DatabaseSchemaConfigFactory(configStream));
        configStream.close();
        configStream = ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/org/opennms/netmgt/capsd/capsd-configuration.xml");
        DefaultCapsdConfigManager capsdConfig = new DefaultCapsdConfigManager(configStream);
        configStream.close();
        CapsdConfigFactory.setInstance((CapsdConfig)capsdConfig);
        configStream = ConfigurationTestUtils.getInputStreamForConfigFile((String)"opennms-server.xml");
        OpennmsServerConfigFactory onmsSvrConfig = new OpennmsServerConfigFactory(configStream);
        configStream.close();
        OpennmsServerConfigFactory.setInstance((OpennmsServerConfigFactory)onmsSvrConfig);
        configStream = ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/org/opennms/netmgt/capsd/poller-configuration.xml");
        PollerConfigFactory.setInstance((PollerConfig)new PollerConfigFactory(System.currentTimeMillis(), configStream, onmsSvrConfig.getServerName(), onmsSvrConfig.verifyServer()));
        configStream.close();
        RrdTestUtils.initialize();
        configStream = ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/org/opennms/netmgt/capsd/collectd-configuration.xml");
        CollectdConfigFactory.setInstance((CollectdConfigFactory)new CollectdConfigFactory(configStream, onmsSvrConfig.getServerName(), onmsSvrConfig.verifyServer()));
        configStream.close();
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)((Object)m_db));
        JdbcCapsdDbSyncer syncer = new JdbcCapsdDbSyncer();
        syncer.setJdbcTemplate(jdbcTemplate);
        syncer.setOpennmsServerConfig(OpennmsServerConfigFactory.getInstance());
        syncer.setCapsdConfig(CapsdConfigFactory.getInstance());
        syncer.setPollerConfig(PollerConfigFactory.getInstance());
        syncer.setCollectdConfig(CollectdConfigFactory.getInstance());
        syncer.setNextSvcIdSql(m_db.getNextServiceIdStatement());
        syncer.afterPropertiesSet();
        PluginManager pluginManager = new PluginManager();
        pluginManager.setCapsdConfig((CapsdConfig)capsdConfig);
        pluginManager.afterPropertiesSet();
        DefaultProcessorFactory defaultProcessorFactory = new DefaultProcessorFactory();
        defaultProcessorFactory.setCapsdDbSyncer((CapsdDbSyncer)syncer);
        defaultProcessorFactory.setPluginManager(pluginManager);
        RunnableConsumerThreadPool suspectRunner = new RunnableConsumerThreadPool("SuspectRunner", 0.0f, 0.0f, 1);
        RunnableConsumerThreadPool rescanRunner = new RunnableConsumerThreadPool("RescanRunner", 0.0f, 0.0f, 1);
        Scheduler scheduler = new Scheduler(rescanRunner.getRunQueue(), (RescanProcessorFactory)defaultProcessorFactory);
        BroadcastEventProcessor eventHandler = new BroadcastEventProcessor();
        eventHandler.setSuspectEventProcessorFactory((SuspectEventProcessorFactory)defaultProcessorFactory);
        eventHandler.setLocalServer("localhost");
        eventHandler.setScheduler(scheduler);
        eventHandler.setSuspectQueue(suspectRunner.getRunQueue());
        eventHandler.afterPropertiesSet();
        AnnotationBasedEventListenerAdapter adapter = new AnnotationBasedEventListenerAdapter((Object)eventHandler, (EventSubscriptionService)m_eventdIpcMgr);
        this.m_capsd = new Capsd();
        this.m_capsd.setCapsdDbSyncer((CapsdDbSyncer)syncer);
        this.m_capsd.setSuspectEventProcessorFactory((SuspectEventProcessorFactory)defaultProcessorFactory);
        this.m_capsd.setCapsdConfig((CapsdConfig)capsdConfig);
        this.m_capsd.setSuspectRunner(suspectRunner);
        this.m_capsd.setRescanRunner(rescanRunner);
        this.m_capsd.setScheduler(scheduler);
        this.m_capsd.setEventListener((StoppableEventListener)adapter);
        this.m_capsd.afterPropertiesSet();
    }

    @Override
    protected void createMockNetwork() {
        super.createMockNetwork();
        m_network.addNode(77, "ForeignNode");
        m_network.addInterface("172.20.1.201");
        m_network.addInterface("fe80:0000:0000:0000:ffff:eeee:dddd:cccc");
        m_network.addService("ICMP");
        m_network.addService("SNMP");
    }

    @Override
    public String getSnmpConfig() {
        return "<?xml version=\"1.0\"?>\n<snmp-config  retry=\"3\" timeout=\"3000\"\n read-community=\"public\" write-community=\"private\"\n port=\"161\"\n version=\"v1\">\n\n   <definition port=\"9161\" version=\"v2c\"        security-name=\"opennmsUser\" \n       auth-passphrase=\"0p3nNMSv3\" \n       privacy-passphrase=\"0p3nNMSv3\" >\n       <specific>" + InetAddressUtils.str((InetAddress)this.myLocalHost()) + "</specific>\n" + "   </definition>\n" + "\n" + "   <definition version=\"v2c\" port=\"9161\" read-community=\"public\" proxy-host=\"" + InetAddressUtils.str((InetAddress)this.myLocalHost()) + "\">\n" + "      <specific>172.20.1.201</specific>\n" + "      <specific>172.20.1.204</specific>\n" + "   </definition>\n" + "</snmp-config>";
    }

    @Override
    protected void tearDown() throws Exception {
        this.m_agent.shutDownAndWait();
        super.tearDown();
    }

    public final void testRescan() throws Exception {
        CapsdTest.assertEquals((String)"Initally only 2 interfaces", (int)2, (int)m_db.countRows("select * from ipinterface where nodeid = ?", new Object[]{77}));
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.rescanInterfaceParent(Integer.valueOf(77));
        Thread.sleep(10000L);
        this.m_capsd.stop();
        CapsdTest.assertEquals((String)"after scanning should be 3 interfaces", (int)3, (int)m_db.countRows("select * from ipinterface where nodeid = ?", new Object[]{77}));
    }

    public final void testRescanOfForeignNode() throws Exception {
        m_db.getJdbcTemplate().update("update node set foreignSource='testSource', foreignId='123' where nodeid = ?", new Object[]{77});
        CapsdTest.assertEquals((String)"Initally only 2 interfaces", (int)2, (int)m_db.countRows("select * from ipinterface where nodeid = ?", new Object[]{77}));
        this.m_capsd.init();
        this.m_capsd.start();
        this.m_capsd.rescanInterfaceParent(Integer.valueOf(77));
        Thread.sleep(10000L);
        this.m_capsd.stop();
        CapsdTest.assertEquals((String)"after scanning should still be 2 since its foreign", (int)2, (int)m_db.countRows("select * from ipinterface where nodeid = ?", new Object[]{77}));
    }
}

