/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.io.File;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.mock.snmp.MockSnmpAgent;
import org.opennms.netmgt.capsd.Capsd;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.OpenNMSIntegrationTestCase;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class CapsdIntegrationTest
extends OpenNMSIntegrationTestCase {
    private static final int FOREIGN_NODEID = 77;
    private Capsd m_capsd;
    private MockSnmpAgent m_agent;

    protected String[] getConfigLocations() {
        try {
            this.setupOpenNMSHomeDir();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return new String[]{"classpath:META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:META-INF/opennms/applicationContext-daemon.xml", "classpath:META-INF/opennms/mockEventIpcManager.xml", "classpath:META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:META-INF/opennms/applicationContext-capsd.xml", "classpath:META-INF/opennms/smallEventConfDao.xml"};
    }

    public void setCapsd(Capsd capsd) {
        this.m_capsd = capsd;
    }

    @Override
    protected MockNetwork createMockNetwork() {
        MockNetwork network = super.createMockNetwork();
        network.addNode(77, "ForeignNode");
        network.addInterface("172.20.1.201");
        network.addService("ICMP");
        network.addService("SNMP");
        return network;
    }

    protected void onSetUpBeforeTransaction() throws Exception {
        this.m_agent = MockSnmpAgent.createAgentAndRun((Resource)new ClassPathResource("org/opennms/netmgt/snmp/snmpTestData1.properties"), (String)(InetAddressUtils.getLocalHostAddressAsString() + "/9161"));
    }

    protected void onTearDownAfterTransaction() throws Exception {
        if (this.m_agent != null) {
            this.m_agent.shutDownAndWait();
        }
    }

    @Override
    protected String preprocessConfigContents(File srcFile, String contents) {
        if (srcFile.getName().matches("snmp-config.xml")) {
            return this.getSnmpConfig();
        }
        if (srcFile.getName().matches("capsd-configuration.xml")) {
            String updatedContents = contents.replaceAll("initial-sleep-time=\"30000\"", "initial-sleep-time=\"300\"");
            updatedContents = updatedContents.replaceAll("scan=\"on\"", "scan=\"off\"");
            updatedContents = updatedContents.replaceAll("SnmpPlugin\" scan=\"off\"", "SnmpPlugin\" scan=\"on\"");
            return updatedContents;
        }
        return contents;
    }

    public String getSnmpConfig() {
        return "<?xml version=\"1.0\"?>\n<snmp-config  retry=\"3\" timeout=\"3000\"\n read-community=\"public\" write-community=\"private\"\n port=\"161\"\n version=\"v1\">\n   <definition version=\"v2c\" port=\"9161\" read-community=\"public\" proxy-host=\"" + InetAddressUtils.getLocalHostAddressAsString() + "\">\n" + "      <specific>172.20.1.201</specific>\n" + "      <specific>172.20.1.204</specific>\n" + "   </definition>\n" + "</snmp-config>\n";
    }

    public final void testRescan() throws Exception {
        CapsdIntegrationTest.assertEquals((String)"Initially only 1 interface", (int)1, (int)this.m_db.countRows("select * from ipinterface where nodeid = ?", new Object[]{77}));
        this.m_capsd.start();
        this.m_capsd.rescanInterfaceParent(Integer.valueOf(77));
        Thread.sleep(10000L);
        this.m_capsd.stop();
        CapsdIntegrationTest.assertEquals((String)"after scanning should be 2 interfaces", (int)2, (int)this.m_db.countRows("select * from ipinterface where nodeid = ?", new Object[]{77}));
    }
}

