/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.poller.InetNetworkInterface;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.ServiceThresholder;
import org.opennms.netmgt.threshd.ThresholdNetworkInterface;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.test.mock.EasyMockUtils;
import org.springframework.core.io.ClassPathResource;

public class ThresholderTestCase
extends TestCase {
    private EasyMockUtils m_easyMockUtils = new EasyMockUtils();
    private EventAnticipator m_anticipator;
    private EventProxy m_proxy;
    private RrdStrategy<?, ?> m_rrdStrategy;
    protected Map<Object, Object> m_serviceParameters;
    protected ThresholdNetworkInterfaceImpl m_iface;
    protected Map<Object, Object> m_parameters;
    private String m_fileName;
    private int m_step;
    protected ServiceThresholder m_thresholder;
    private MockEventIpcManager m_eventMgr;
    protected MockNetwork m_network;
    private String m_serviceName;
    private String m_ipAddress;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected void setupEventManager() {
        this.m_anticipator = new EventAnticipator();
        this.m_eventMgr = new MockEventIpcManager();
        this.m_eventMgr.setEventAnticipator(this.m_anticipator);
        this.m_proxy = new EventProxy(){

            public void send(Event e) {
                ThresholderTestCase.this.m_eventMgr.sendNow(e);
            }

            public void send(Log log) {
                ThresholderTestCase.this.m_eventMgr.sendNow(log);
            }
        };
    }

    protected void setupThresholdConfig(String dirName, String fileName, int nodeId, String ipAddress, String serviceName, String groupName) throws IOException, UnknownHostException, FileNotFoundException, MarshalException, ValidationException {
        File dir = new File(dirName);
        File f = this.createFile(dir, fileName);
        this.m_fileName = f.getAbsolutePath();
        this.m_step = 300000;
        this.m_iface = new ThresholdNetworkInterfaceImpl(nodeId, InetAddressUtils.addr((String)ipAddress));
        this.m_serviceParameters = new HashMap<Object, Object>();
        this.m_serviceParameters.put("svcName", serviceName);
        this.m_parameters = new HashMap<Object, Object>();
        this.m_parameters.put("thresholding-group", groupName);
        this.m_ipAddress = ipAddress;
        this.m_serviceName = serviceName;
        ClassPathResource config = new ClassPathResource("/test-thresholds.xml");
        ThresholdingConfigFactory.setInstance((ThresholdingConfigFactory)new ThresholdingConfigFactory(config.getInputStream()));
        ThresholdingConfigFactory.getInstance().getGroup(groupName).setRrdRepository(dir.getParentFile().getAbsolutePath());
    }

    private File createFile(File dir, String fileName) throws IOException {
        dir.mkdirs();
        File f = new File(dir, fileName);
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
        out.println("unused");
        out.close();
        f.deleteOnExit();
        dir.deleteOnExit();
        return f;
    }

    protected void createMockRrd() throws Exception {
        this.m_rrdStrategy = (RrdStrategy)this.m_easyMockUtils.createMock(RrdStrategy.class);
        this.expectRrdStrategyCalls();
        RrdUtils.setStrategy(this.m_rrdStrategy);
    }

    protected void expectRrdStrategyCalls() throws Exception {
        EasyMock.expect((Object)this.m_rrdStrategy.getDefaultFileExtension()).andReturn((Object)".mockRrd").anyTimes();
    }

    protected void setupDatabase() throws Exception {
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService("ICMP");
        this.m_network.addNode(1, "Router");
        this.m_network.addInterface("192.168.1.1");
        this.m_network.addService("ICMP");
        this.m_network.addService("SNMP");
        this.m_network.addInterface("192.168.1.2");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addNode(2, "Server");
        this.m_network.addInterface("192.168.1.3");
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP");
        this.m_network.addNode(3, "Firewall");
        this.m_network.addInterface("192.168.1.4");
        this.m_network.addService("SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addInterface("192.168.1.5");
        this.m_network.addService("SMTP");
        this.m_network.addService("HTTP");
        MockDatabase db = new MockDatabase();
        db.populate(this.m_network);
        DataSourceFactory.setInstance((DataSource)((Object)db));
    }

    protected void ensureExceededAfterFetches(String dsName, int count) {
        this.ensureEventAfterFetches(count, dsName, "uei.opennms.org/threshold/highThresholdExceeded");
    }

    protected void ensureRearmedAfterFetches(String dsName, int count) {
        this.ensureEventAfterFetches(count, dsName, "uei.opennms.org/threshold/highThresholdRearmed");
    }

    private void ensureEventAfterFetches(int count, String dsName, String uei) {
        if (uei != null) {
            EventBuilder event = MockEventUtil.createServiceEventBuilder((String)"Test", (String)uei, (MockService)this.m_network.getService(1, this.m_ipAddress, this.m_serviceName), null);
            event.addParam("ds", dsName);
            this.m_anticipator.anticipateEvent(event.getEvent());
        }
        for (int i = 0; i < count; ++i) {
            this.m_thresholder.check((ThresholdNetworkInterface)this.m_iface, this.m_proxy, this.m_parameters);
        }
        this.verifyAnticipated(1000L);
    }

    protected void ensureNoEventAfterFetches(String dsName, int count) {
        this.ensureEventAfterFetches(count, null, null);
    }

    protected void setupFetchSequence(String ds, double ... values) throws NumberFormatException, RrdException {
        for (double value : values) {
            EasyMock.expect((Object)this.m_rrdStrategy.fetchLastValue((String)EasyMock.eq((Object)this.m_fileName), (String)EasyMock.eq((Object)ds), EasyMock.eq((int)this.m_step))).andReturn((Object)value);
        }
    }

    private void verifyAnticipated(long millis) {
        MockEventUtil.printEvents((String)"Events we're still waiting for: ", this.m_anticipator.waitForAnticipated(millis));
        MockEventUtil.printEvents((String)"Unanticipated: ", this.m_anticipator.unanticipatedEvents());
        ThresholderTestCase.assertTrue((String)"Expected events not forthcoming", (boolean)this.m_anticipator.waitForAnticipated(0L).isEmpty());
        this.sleep(200L);
        ThresholderTestCase.assertEquals((String)"Received unexpected events", (int)0, (int)this.m_anticipator.unanticipatedEvents().size());
        this.m_anticipator.reset();
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void replayMocks() {
        this.m_easyMockUtils.replayAll();
    }

    public void verifyMocks() {
        this.m_easyMockUtils.verifyAll();
    }

    public void testDoNothing() {
    }

    public static class ThresholdNetworkInterfaceImpl
    extends InetNetworkInterface
    implements ThresholdNetworkInterface {
        private static final long serialVersionUID = 8363288174688092210L;
        private int m_nodeId;

        public ThresholdNetworkInterfaceImpl(int nodeId, InetAddress inetAddress) {
            super(inetAddress);
            this.m_nodeId = nodeId;
        }

        public int getNodeId() {
            return this.m_nodeId;
        }
    }
}

