/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.opennms.netmgt.mock.MockAgent;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class MockProxy
implements CommandResponder {
    private TransportMapping m_transport;
    private Snmp m_snmp;
    private MockAgent m_agent;

    public MockProxy(int port) throws IOException {
        this.m_transport = new DefaultUdpTransportMapping(new UdpAddress(InetAddress.getLocalHost(), port));
        this.m_snmp = new Snmp(this.m_transport);
        this.m_snmp.addCommandResponder((CommandResponder)this);
        this.m_transport.listen();
    }

    public void processPdu(CommandResponderEvent e) {
        PDU command = e.getPDU();
        if (command == null) {
            return;
        }
        PDU response = this.processRequest(command);
        if (response == null) {
            return;
        }
        StatusInformation statusInformation = new StatusInformation();
        StateReference ref = e.getStateReference();
        try {
            Logger.getLogger(MockProxy.class).debug((Object)("Replying with: " + command));
            e.setProcessed(true);
            e.getMessageDispatcher().returnResponsePdu(e.getMessageProcessingModel(), e.getSecurityModel(), e.getSecurityName(), e.getSecurityLevel(), command, e.getMaxSizeResponsePDU(), ref, statusInformation);
        }
        catch (MessageException ex) {
            System.err.println("Error while sending response: " + ex.getMessage());
            Logger.getLogger(MockProxy.class).error((Object)ex);
        }
    }

    private PDU processRequest(PDU request) {
        if (!this.isRequestPDU(request)) {
            return null;
        }
        switch (request.getType()) {
            case -96: {
                return this.processGet(request);
            }
            case -95: {
                return this.processGetNext(request);
            }
            case -91: {
                return this.processGetBulk(request);
            }
            case -93: {
                return this.processSet(request);
            }
            case -90: {
                return this.processInform(request);
            }
        }
        return this.processUnhandled(request);
    }

    private PDU processUnhandled(PDU request) {
        return null;
    }

    private PDU processInform(PDU request) {
        return null;
    }

    private PDU processSet(PDU request) {
        return null;
    }

    private PDU processGetBulk(PDU request) {
        return null;
    }

    private PDU processGet(PDU request) {
        PDU response = request;
        response.setErrorIndex(0);
        response.setErrorStatus(0);
        response.setType(-94);
        Vector varBinds = response.getVariableBindings();
        for (int i = 0; i < varBinds.size(); ++i) {
            VariableBinding varBind = (VariableBinding)varBinds.get(i);
            VariableBinding nextVarBind = this.m_agent.get(varBind.getOid());
            if (nextVarBind == null) {
                if (response instanceof PDUv1) {
                    if (response.getErrorIndex() != 0) continue;
                    response.setErrorIndex(i + 1);
                    response.setErrorStatus(2);
                    continue;
                }
                varBind.setVariable((Variable)Null.endOfMibView);
                continue;
            }
            response.set(i, nextVarBind);
        }
        return response;
    }

    private PDU processGetNext(PDU request) {
        PDU response = request;
        response.setErrorIndex(0);
        response.setErrorStatus(0);
        response.setType(-94);
        Vector varBinds = response.getVariableBindings();
        for (int i = 0; i < varBinds.size(); ++i) {
            VariableBinding varBind = (VariableBinding)varBinds.get(i);
            VariableBinding nextVarBind = this.m_agent.getNext(varBind.getOid());
            if (nextVarBind == null) {
                if (response instanceof PDUv1) {
                    if (response.getErrorIndex() != 0) continue;
                    response.setErrorIndex(i + 1);
                    response.setErrorStatus(2);
                    continue;
                }
                varBind.setVariable((Variable)Null.endOfMibView);
                continue;
            }
            response.set(i, nextVarBind);
        }
        return response;
    }

    private boolean isRequestPDU(PDU command) {
        return command.getType() != -89 && command.getType() != -92 && command.getType() != -88 && command.getType() != -94;
    }

    public void addAgent(MockAgent agent) {
        this.m_agent = agent;
    }

    public void stop() throws IOException {
        this.m_snmp.close();
    }
}

