/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-proxy-snmp.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:/META-INF/opennms/applicationContext-linkd.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/applicationContext-linkd-test.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class LinkdNms4005Test {
    @Autowired
    private Linkd m_linkd;
    @Autowired
    private LinkdConfig m_linkdConfig;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.hibernate.SQL", "WARN");
        MockLogAppender.setupLogging((Properties)p);
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("cisco1").setForeignSource("linkd").setForeignId("cisco1").setSysObjectId(".1.3.6.1.4.1.9.1.122").setType("A");
        nb.addInterface("10.1.1.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(3).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2007db90010");
        nb.addInterface("10.1.2.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(1).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2007db90000");
        nb.addInterface("10.1.3.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2007db90001");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("cisco2").setForeignSource("linkd").setForeignId("cisco2").setSysObjectId(".1.3.6.1.4.1.9.1.122").setType("A");
        nb.addInterface("10.1.2.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(1).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2017db90000");
        nb.addInterface("10.1.5.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2017db90001");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("cisco3").setForeignSource("linkd").setForeignId("cisco3").setSysObjectId(".1.3.6.1.4.1.9.1.122").setType("A");
        nb.addInterface("10.1.3.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(1).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2027db90000");
        nb.addInterface("10.1.4.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2027db90001");
        nb.addInterface("10.1.5.2").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(3).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2027db90010");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        this.m_nodeDao.flush();
        for (Package pkg : Collections.list(this.m_linkdConfig.enumeratePackage())) {
            pkg.setForceIpRouteDiscoveryOnEthernet(true);
        }
    }

    @After
    public void tearDown() throws Exception {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/10.1.1.2-walk.txt"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/10.1.2.2-walk.txt"), @JUnitSnmpAgent(host="10.1.3.2", port=161, resource="classpath:linkd/10.1.3.2-walk.txt"), @JUnitSnmpAgent(host="10.1.4.2", port=161, resource="classpath:linkd/10.1.4.2-walk.txt")})
    public void testNms4005Network() throws Exception {
        OnmsNode cisco1 = this.m_nodeDao.findByForeignId("linkd", "cisco1");
        OnmsNode cisco2 = this.m_nodeDao.findByForeignId("linkd", "cisco2");
        OnmsNode cisco3 = this.m_nodeDao.findByForeignId("linkd", "cisco3");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleCollection(cisco3.getId().intValue()));
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((String)"we should have found 3 data links", (long)3L, (long)ifaces.size());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/10.1.1.2-walk.txt"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/10.1.2.2-walk.txt"), @JUnitSnmpAgent(host="10.1.3.2", port=161, resource="classpath:linkd/10.1.3.2-walk.txt"), @JUnitSnmpAgent(host="10.1.4.2", port=161, resource="classpath:linkd/10.1.4.2-walk.txt")})
    public void testNms4005NetworkWithThreads() throws Exception {
        Thread thread2;
        final OnmsNode cisco1 = this.m_nodeDao.findByForeignId("linkd", "cisco1");
        final OnmsNode cisco2 = this.m_nodeDao.findByForeignId("linkd", "cisco2");
        final OnmsNode cisco3 = this.m_nodeDao.findByForeignId("linkd", "cisco3");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco3.getId().intValue()));
        int NUMBER_OF_THREADS = 20;
        ArrayList<Thread> waitForMe = new ArrayList<Thread>();
        for (int i = 0; i < 20; ++i) {
            thread2 = new Thread("NMS-4005-Test-Thread-" + i){

                @Override
                public void run() {
                    Assert.assertTrue((boolean)LinkdNms4005Test.this.m_linkd.runSingleCollection(cisco1.getId().intValue()));
                }
            };
            thread2.start();
            waitForMe.add(thread2);
        }
        for (Thread thread2 : waitForMe) {
            thread2.join();
        }
        waitForMe.clear();
        for (int i = 0; i < 20; ++i) {
            thread2 = new Thread("NMS-4005-Test-Thread-" + i){

                @Override
                public void run() {
                    Assert.assertTrue((boolean)LinkdNms4005Test.this.m_linkd.runSingleCollection(cisco2.getId().intValue()));
                }
            };
            thread2.start();
            waitForMe.add(thread2);
        }
        for (Thread thread2 : waitForMe) {
            thread2.join();
        }
        waitForMe.clear();
        for (int i = 0; i < 20; ++i) {
            thread2 = new Thread("NMS-4005-Test-Thread-" + i){

                @Override
                public void run() {
                    Assert.assertTrue((boolean)LinkdNms4005Test.this.m_linkd.runSingleCollection(cisco3.getId().intValue()));
                }
            };
            thread2.start();
            waitForMe.add(thread2);
        }
        for (Thread thread2 : waitForMe) {
            thread2.join();
        }
        waitForMe.clear();
        List ifaces = this.m_dataLinkInterfaceDao.findAll();
        Assert.assertEquals((String)"we should have found 3 data links", (long)3L, (long)ifaces.size());
    }
}

