/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.xml.MarshallingResourceFailureException;
import org.opennms.netmgt.config.JMXDataCollectionConfigDao;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class JMXDataCollectionConfigDaoTest {
    @Test
    public void testAfterPropertiesSetWithNoConfigSet() {
        JMXDataCollectionConfigDao dao = new JMXDataCollectionConfigDao();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("property configResource must be set and be non-null"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testAfterPropertiesSetWithBogusFileResource() throws Exception {
        FileSystemResource resource = new FileSystemResource("/bogus-file");
        JMXDataCollectionConfigDao dao = new JMXDataCollectionConfigDao();
        dao.setConfigResource((Resource)resource);
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new MarshallingResourceFailureException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            dao.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    public void testAfterPropertiesSetWithGoodConfigFile() throws Exception {
        JMXDataCollectionConfigDao dao = new JMXDataCollectionConfigDao();
        File jmxCollectionConfig = new File("src/test/resources/org/opennms/netmgt/config/jmx-datacollection-testdata.xml");
        Assert.assertTrue((String)"JMX configuration file is readable", (boolean)jmxCollectionConfig.canRead());
        FileInputStream in = new FileInputStream(jmxCollectionConfig);
        dao.setConfigResource((Resource)new InputStreamResource((InputStream)in));
        dao.afterPropertiesSet();
        Assert.assertNotNull((String)"JMX data collection should not be null", (Object)dao.getConfig());
    }

    @Test
    public void testAfterPropertiesSetWithNestedFiles() throws Exception {
        System.setProperty("opennms.home", "src/test/resources");
        JMXDataCollectionConfigDao dao = new JMXDataCollectionConfigDao();
        File jmxCollectionConfig = new File("src/test/resources/etc/jmx-datacollection-split.xml");
        Assert.assertTrue((String)"JMX configuration file is readable", (boolean)jmxCollectionConfig.canRead());
        FileInputStream in = new FileInputStream(jmxCollectionConfig);
        dao.setConfigResource((Resource)new InputStreamResource((InputStream)in));
        dao.afterPropertiesSet();
        JmxDatacollectionConfig config = dao.getConfig();
        Assert.assertNotNull((String)"JMX data collection should not be null", (Object)config);
        Assert.assertEquals((long)8L, (long)config.getJmxCollection(0).getMbeans().getMbeanCount());
        Assert.assertEquals((long)4L, (long)config.getJmxCollection(1).getMbeans().getMbeanCount());
    }
}

