/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.spring.xmlrpc;

import java.net.InetAddress;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcServer;
import org.apache.xmlrpc.secure.SecureWebServer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class XmlRpcWebServerFactoryBean
implements FactoryBean<WebServer>,
InitializingBean,
DisposableBean {
    private WebServer m_webServer;
    private int m_port = -1;
    private InetAddress m_address = null;
    private XmlRpcServer m_xmlRpcServer = null;
    private boolean m_secure = false;

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress addrress) {
        this.m_address = addrress;
    }

    public boolean getSecure() {
        return this.m_secure;
    }

    public void setSecure(boolean secure) {
        this.m_secure = secure;
    }

    public XmlRpcServer getXmlRpcServer() {
        return this.m_xmlRpcServer;
    }

    public void setXmlRpcServer(XmlRpcServer xmlRpcServer) {
        this.m_xmlRpcServer = xmlRpcServer;
    }

    public WebServer getObject() throws Exception {
        return this.m_webServer;
    }

    public Class<? extends WebServer> getObjectType() {
        return WebServer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.m_port == -1) {
            throw new IllegalArgumentException("port is required");
        }
        if (this.m_xmlRpcServer == null) {
            this.m_xmlRpcServer = new XmlRpcServer();
        }
        this.m_webServer = this.m_secure ? new SecureWebServer(this.m_port, this.m_address, this.m_xmlRpcServer) : new WebServer(this.m_port, this.m_address, this.m_xmlRpcServer);
        this.m_webServer.start();
    }

    public void destroy() throws Exception {
        this.m_webServer.shutdown();
    }
}

