/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.jmx.connectors;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.protocols.jmx.connectors.MX4JConnectionWrapper;

public class MX4JConnectionFactory {
    static ThreadCategory log = ThreadCategory.getInstance(MX4JConnectionFactory.class);

    public static MX4JConnectionWrapper getMBeanServerConnection(Map<?, ?> propertiesMap, InetAddress address) {
        MX4JConnectionWrapper connectionWrapper = null;
        JMXServiceURL url = null;
        String factory = ParameterMap.getKeyedString(propertiesMap, (String)"factory", (String)"STANDARD");
        int port = ParameterMap.getKeyedInteger(propertiesMap, (String)"port", (int)1099);
        String protocol = ParameterMap.getKeyedString(propertiesMap, (String)"protocol", (String)"rmi");
        String urlPath = ParameterMap.getKeyedString(propertiesMap, (String)"urlPath", (String)"/jmxrmi");
        log.debug("JMX: " + factory + " - service:" + protocol + "//" + InetAddressUtils.str((InetAddress)address) + ":" + port + urlPath);
        if (factory == null || factory.equals("STANDARD")) {
            try {
                url = new JMXServiceURL(protocol, InetAddressUtils.str((InetAddress)address), port, urlPath);
                JMXConnector connector = JMXConnectorFactory.connect(url);
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new MX4JConnectionWrapper(connector, connection);
            }
            catch (Throwable e) {
                LogUtils.errorf(MX4JConnectionFactory.class, (Throwable)e, (String)"Unable to get MBeanServerConnection: %s", (Object[])new Object[]{url});
            }
        } else if (factory.equals("PASSWORD-CLEAR")) {
            try {
                String username = ParameterMap.getKeyedString(propertiesMap, (String)"username", null);
                String password = ParameterMap.getKeyedString(propertiesMap, (String)"password", null);
                HashMap<String, String[]> env = new HashMap<String, String[]>();
                String[] credentials = new String[]{username, password};
                env.put("jmx.remote.credentials", credentials);
                url = new JMXServiceURL(protocol, InetAddressUtils.str((InetAddress)address), port, urlPath);
                JMXConnector connector = JMXConnectorFactory.newJMXConnector(url, null);
                try {
                    connector.connect(env);
                }
                catch (SecurityException x) {
                    log.error("Security exception: bad credentials");
                    throw x;
                }
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new MX4JConnectionWrapper(connector, connection);
            }
            catch (Throwable e) {
                log.error("Unable to get MBeanServerConnection: " + url, e);
            }
        }
        return connectionWrapper;
    }
}

