/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.XmlrpcdConfigFactory;
import org.opennms.netmgt.config.xmlrpcd.ExternalServers;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcServer;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xmlrpcd.BroadcastEventProcessor;
import org.opennms.netmgt.xmlrpcd.EventQueueProcessor;

public class Xmlrpcd
extends AbstractServiceDaemon {
    private static final AbstractServiceDaemon m_singleton = new Xmlrpcd();
    private ArrayList<FifoQueue<Event>> m_eventlogQs = new ArrayList();
    private ArrayList<EventQueueProcessor> m_processors = new ArrayList();
    private ArrayList<BroadcastEventProcessor> m_eventReceivers = new ArrayList();
    private OpennmsServerConfigFactory m_serverConfig;
    private XmlrpcdConfigFactory m_config;

    public Xmlrpcd() {
        super("OpenNMS.Xmlrpcd");
    }

    protected void onInit() {
        LogUtils.debugf((Object)((Object)this), (String)"start: Creating the xmlrpc event queue processor", (Object[])new Object[0]);
        try {
            LogUtils.debugf((Object)((Object)this), (String)"start: Initializing the xmlrpcd config factory", (Object[])new Object[0]);
            boolean verifyServer = this.getServerConfig().verifyServer();
            String localServer = null;
            if (verifyServer) {
                localServer = this.getServerConfig().getServerName();
            }
            Enumeration<ExternalServers> servers = this.getConfig().getExternalServerEnumeration();
            int i = 0;
            while (servers.hasMoreElements()) {
                ExternalServers server = servers.nextElement();
                XmlrpcServer[] xServers = server.getXmlrpcServer();
                FifoQueueImpl q = new FifoQueueImpl();
                this.m_eventlogQs.add((FifoQueue<Event>)q);
                this.m_eventReceivers.add(new BroadcastEventProcessor(Integer.toString(i), (FifoQueue<Event>)q, this.getConfig().getMaxQueueSize(), this.getConfig().getEventList(server)));
                this.m_processors.add(new EventQueueProcessor((FifoQueue<Event>)q, xServers, server.getRetries(), server.getElapseTime(), verifyServer, localServer, this.getConfig().getMaxQueueSize()));
                ++i;
            }
        }
        catch (MarshalException e) {
            LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"Failed to load configuration", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"Failed to load configuration", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"Failed to load configuration", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        catch (Throwable t) {
            LogUtils.errorf((Object)((Object)this), (Throwable)t, (String)"Failed to load configuration", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(t);
        }
    }

    public XmlrpcdConfigFactory getConfig() throws MarshalException, ValidationException, IOException {
        if (this.m_config == null) {
            this.createConfig();
        }
        return this.m_config;
    }

    public void createConfig() throws MarshalException, ValidationException, IOException {
        XmlrpcdConfigFactory.init();
        this.setConfig(XmlrpcdConfigFactory.getInstance());
    }

    public void setConfig(XmlrpcdConfigFactory config) {
        this.m_config = config;
    }

    public OpennmsServerConfigFactory getServerConfig() throws MarshalException, ValidationException, IOException {
        if (this.m_serverConfig == null) {
            this.createServerConfig();
        }
        return this.m_serverConfig;
    }

    public void createServerConfig() throws MarshalException, ValidationException, IOException {
        OpennmsServerConfigFactory.init();
        this.setServerConfig(OpennmsServerConfigFactory.getInstance());
    }

    public void setServerConfig(OpennmsServerConfigFactory serverConfig) {
        this.m_serverConfig = serverConfig;
    }

    protected void onStart() {
        LogUtils.debugf((Object)((Object)this), (String)"start: Initializing the xmlrpcd config factory", (Object[])new Object[0]);
        for (EventQueueProcessor proc : this.m_processors) {
            proc.start();
        }
        LogUtils.debugf((Object)((Object)this), (String)"start: xmlrpcd ready to process events", (Object[])new Object[0]);
    }

    protected void onPause() {
        LogUtils.debugf((Object)((Object)this), (String)"pause: Calling pause on processor", (Object[])new Object[0]);
        for (EventQueueProcessor proc : this.m_processors) {
            proc.pause();
        }
        LogUtils.debugf((Object)((Object)this), (String)"pause: Processor paused", (Object[])new Object[0]);
    }

    protected void onResume() {
        LogUtils.debugf((Object)((Object)this), (String)"resume: Calling resume on processor", (Object[])new Object[0]);
        for (EventQueueProcessor proc : this.m_processors) {
            proc.resume();
        }
        LogUtils.debugf((Object)((Object)this), (String)"resume: Processor resumed", (Object[])new Object[0]);
    }

    protected void onStop() {
        LogUtils.debugf((Object)((Object)this), (String)"stop: Calling stop on processor", (Object[])new Object[0]);
        for (EventQueueProcessor proc : this.m_processors) {
            proc.stop();
        }
        LogUtils.debugf((Object)((Object)this), (String)"stop: Processor stopped", (Object[])new Object[0]);
    }

    public static AbstractServiceDaemon getInstance() {
        return m_singleton;
    }
}

