/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import org.opennms.netmgt.syslogd.SyslogFacility;

public enum SyslogSeverity {
    EMERGENCY(0, "system is unusable"),
    ALERT(1, "action must be taken immediately"),
    CRITICAL(2, "critical conditions"),
    ERROR(3, "error conditions"),
    WARNING(4, "warning conditions"),
    NOTICE(5, "normal but significant condition"),
    INFORMATIONAL(6, "informational messages"),
    DEBUG(7, "debug-level messages"),
    ALL(8, "all levels");

    public static final int MASK = 7;
    private final int m_severity;
    private final String m_name;
    private final String m_description;

    private SyslogSeverity(int severity, String description) {
        this.m_severity = severity;
        this.m_name = (this.name().substring(0, 1) + this.name().substring(1).toLowerCase()).intern();
        this.m_description = description.intern();
    }

    public int getSeverityNumber() {
        return this.m_severity;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getPriority(SyslogFacility facility) {
        if (facility == null) {
            return 0 | this.m_severity;
        }
        return facility.getFacilityNumber() & 0x3F8 | this.m_severity;
    }

    public String toString() {
        return this.m_name;
    }

    public static SyslogSeverity getSeverity(int severity) {
        SyslogSeverity[] severities = SyslogSeverity.values();
        if (severities.length < severity) {
            return null;
        }
        return severities[severity];
    }

    public static SyslogSeverity getSeverityForCode(int code) {
        return SyslogSeverity.getSeverity(code & 7);
    }
}

