/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.opennms.netmgt.syslogd.SyslogSeverity;

public class Rfc5424SyslogParser
extends SyslogParser {
    private static final Pattern m_rfc5424Pattern = Pattern.compile("^<(\\d{1,3})>(\\d{0,2}?) (\\S+T\\S+) (\\S*) (\\S*) (\\d+|-) (\\S*) ((?:\\[.*?\\])*|-)(?: (?:BOM)?(.*?))?$", 8);
    private static final Pattern m_dateWithOffset = Pattern.compile("^(.*[\\-\\+]\\d\\d):?(\\d\\d)$");

    protected Rfc5424SyslogParser(String text) {
        super(text);
    }

    public static SyslogParser getParser(String text) {
        return new Rfc5424SyslogParser(text);
    }

    @Override
    protected Pattern getPattern() {
        return m_rfc5424Pattern;
    }

    @Override
    public SyslogMessage parse() throws SyslogParserException {
        String messageText;
        if (!this.find()) {
            if (this.traceEnabled()) {
                LogUtils.tracef((Object)this, (String)"'%s' did not match '%s'", (Object[])new Object[]{m_rfc5424Pattern, this.getText()});
            }
            return null;
        }
        Matcher matcher = this.getMatcher();
        SyslogMessage message = new SyslogMessage();
        try {
            int priorityField = Integer.parseInt(matcher.group(1));
            message.setFacility(SyslogFacility.getFacilityForCode(priorityField));
            message.setSeverity(SyslogSeverity.getSeverityForCode(priorityField));
        }
        catch (NumberFormatException e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to parse priority field '%s'", (Object[])new Object[]{matcher.group(1)});
        }
        if (matcher.group(2).length() != 0) {
            try {
                int version = Integer.parseInt(matcher.group(2));
                message.setVersion(version);
            }
            catch (NumberFormatException e) {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to parse version (%s) as a number.", (Object[])new Object[]{matcher.group(2)});
            }
        }
        if (!matcher.group(3).equals("-")) {
            message.setDate(this.parseDate(matcher.group(3)));
        }
        if (!matcher.group(4).equals("-")) {
            message.setHostName(matcher.group(4));
        }
        if (!matcher.group(5).equals("-")) {
            message.setProcessName(matcher.group(5));
        }
        if (!matcher.group(6).equals("-")) {
            try {
                message.setProcessId(Integer.parseInt(matcher.group(6)));
            }
            catch (NumberFormatException e) {
                LogUtils.debugf((Object)this, (Throwable)e, (String)"Unable to parse process ID '%s' as a number.", (Object[])new Object[]{matcher.group(6)});
            }
        }
        if (!matcher.group(7).equals("-")) {
            message.setMessageID(matcher.group(7));
        }
        if ((messageText = matcher.group(9)) != null && messageText.length() != 0) {
            message.setMessage(messageText);
        }
        return message;
    }

    @Override
    protected Date parseDate(String dateString) {
        if (dateString.endsWith("Z")) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df.parse(dateString);
            }
            catch (Exception e) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
                    df.setLenient(true);
                    df.setTimeZone(TimeZone.getTimeZone("GMT"));
                    return df.parse(dateString);
                }
                catch (Exception pe) {
                    LogUtils.debugf((Object)this, (Throwable)pe, (String)"Unable to parse date string '%s'.", (Object[])new Object[]{dateString});
                }
            }
        } else {
            String newString;
            Matcher matcher = m_dateWithOffset.matcher(dateString);
            if (matcher.find()) {
                newString = matcher.group(1) + matcher.group(2);
            } else {
                String first = dateString.substring(0, dateString.lastIndexOf(45));
                String last = dateString.substring(dateString.lastIndexOf(45));
                newString = first + last.replace(":", "");
            }
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                return df.parse(newString);
            }
            catch (Exception e) {
                try {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ");
                    df.setLenient(true);
                    return df.parse(newString);
                }
                catch (Exception pe) {
                    LogUtils.debugf((Object)this, (Throwable)pe, (String)"Unable to parse date string '%s'.", (Object[])new Object[]{newString});
                }
            }
        }
        return null;
    }
}

