/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.opennms.netmgt.syslogd.SyslogSeverity;
import org.opennms.netmgt.syslogd.SyslogTimeStamp;

public class CustomSyslogParser
extends SyslogParser {
    private static final Pattern m_messageIdPattern = Pattern.compile("^((\\S+):\\s*)");
    private static final Pattern m_datePattern = Pattern.compile("^((\\d\\d\\d\\d-\\d\\d-\\d\\d)\\s+)");
    private static final Pattern m_oldDatePattern = Pattern.compile("^\\s*(\\S\\S\\S\\s+\\d{1,2}\\s+\\d\\d:\\d\\d:\\d\\d)\\s+");
    private Pattern m_forwardingPattern;
    private int m_matchingGroupHost;
    private int m_matchingGroupMessage;

    protected CustomSyslogParser(String text) throws SyslogParserException {
        super(text);
        SyslogdConfig config = SyslogdConfigFactory.getInstance();
        String forwardingRegexp = config.getForwardingRegexp();
        if (forwardingRegexp == null || forwardingRegexp.length() == 0) {
            throw new SyslogParserException("no forwarding regular expression defined");
        }
        this.m_forwardingPattern = Pattern.compile(forwardingRegexp, 8);
        this.m_matchingGroupHost = config.getMatchingGroupHost();
        this.m_matchingGroupMessage = config.getMatchingGroupMessage();
    }

    public static SyslogParser getParser(String text) throws SyslogParserException {
        return new CustomSyslogParser(text);
    }

    @Override
    public SyslogMessage parse() throws SyslogParserException {
        String matchedMessage;
        Pattern pattern;
        Matcher m;
        String timestamp;
        SyslogMessage syslogMessage = new SyslogMessage();
        String message = this.getText();
        int lbIdx = message.indexOf(60);
        int rbIdx = message.indexOf(62);
        if (lbIdx < 0 || rbIdx < 0 || lbIdx >= rbIdx - 1) {
            LogUtils.warnf((Object)this, (String)"Syslogd received an unparsable message!", (Object[])new Object[0]);
        }
        int priCode = 0;
        String priStr = message.substring(lbIdx + 1, rbIdx);
        try {
            priCode = Integer.parseInt(priStr);
        }
        catch (NumberFormatException ex) {
            LogUtils.debugf((Object)this, (String)"ERROR Bad priority code '%s'", (Object[])new Object[]{priStr});
        }
        LogUtils.tracef((Object)this, (String)"priority code = %d", (Object[])new Object[]{priCode});
        syslogMessage.setFacility(SyslogFacility.getFacilityForCode(priCode));
        syslogMessage.setSeverity(SyslogSeverity.getSeverityForCode(priCode));
        message = message.substring(rbIdx + 1, message.length());
        Matcher idMatcher = m_messageIdPattern.matcher(message);
        if (idMatcher.find()) {
            String messageId = idMatcher.group(2);
            LogUtils.tracef((Object)this, (String)"found message ID '%s'", (Object[])new Object[]{messageId});
            syslogMessage.setMessageID(messageId);
            message = message.substring(idMatcher.group(1).length() - 1);
        }
        LogUtils.tracef((Object)this, (String)"message = %s", (Object[])new Object[]{message});
        Matcher oldDateMatcher = m_oldDatePattern.matcher(message);
        if (!oldDateMatcher.find()) {
            oldDateMatcher = null;
        }
        LogUtils.tracef((Object)this, (String)"stdMsg = %s", (Object[])new Object[]{Boolean.toString(oldDateMatcher != null)});
        if (!this.find()) {
            if (this.traceEnabled()) {
                LogUtils.tracef((Object)this, (String)"Lenient Syslog pattern '%s' did not match '%s'", (Object[])new Object[]{this.getPattern(), this.getText()});
            }
            return null;
        }
        if (oldDateMatcher == null) {
            Matcher stampMatcher = m_datePattern.matcher(message);
            if (stampMatcher.find()) {
                timestamp = stampMatcher.group(2);
                LogUtils.tracef((Object)this, (String)"found timestamp '%s'", (Object[])new Object[]{timestamp});
            } else {
                try {
                    timestamp = SyslogTimeStamp.getInstance().format(new Date());
                }
                catch (IllegalArgumentException ex) {
                    LogUtils.debugf((Object)this, (String)"ERROR INTERNAL DATE ERROR!", (Object[])new Object[0]);
                    timestamp = "";
                }
            }
        } else {
            timestamp = oldDateMatcher.group(1);
            message = oldDateMatcher.replaceFirst("");
        }
        LogUtils.tracef((Object)this, (String)"timestamp = %s", (Object[])new Object[]{timestamp});
        syslogMessage.setDate(this.parseDate(timestamp));
        if (LogUtils.isTraceEnabled((Object)this)) {
            LogUtils.tracef((Object)this, (String)"message = %s", (Object[])new Object[]{message});
            LogUtils.tracef((Object)this, (String)"pattern = %s", (Object[])new Object[]{this.m_forwardingPattern});
            LogUtils.tracef((Object)this, (String)"host group = %d", (Object[])new Object[]{this.m_matchingGroupHost});
            LogUtils.tracef((Object)this, (String)"message group = %d", (Object[])new Object[]{this.m_matchingGroupMessage});
        }
        if ((m = (pattern = this.m_forwardingPattern).matcher(message)).matches()) {
            matchedMessage = m.group(this.m_matchingGroupMessage);
            syslogMessage.setMatchedMessage(matchedMessage);
            if (LogUtils.isTraceEnabled((Object)this)) {
                LogUtils.tracef((Object)this, (String)"Syslog message '%s' matched regexp '%s'", (Object[])new Object[]{message, this.m_forwardingPattern});
                LogUtils.tracef((Object)this, (String)"Found host '%s'", (Object[])new Object[]{m.group(this.m_matchingGroupHost)});
                LogUtils.tracef((Object)this, (String)"Found message '%s'", (Object[])new Object[]{matchedMessage});
            }
        } else {
            LogUtils.debugf((Object)this, (String)"Regexp not matched: %s", (Object[])new Object[]{message});
            return null;
        }
        syslogMessage.setHostName(m.group(this.m_matchingGroupHost));
        message = matchedMessage;
        lbIdx = message.indexOf(91);
        rbIdx = message.indexOf(93);
        int colonIdx = message.indexOf(58);
        int spaceIdx = message.indexOf(32);
        int processId = 0;
        String processName = "";
        String processIdStr = "";
        if (lbIdx < rbIdx - 1 && colonIdx == rbIdx + 1 && spaceIdx == colonIdx + 1) {
            processName = message.substring(0, lbIdx);
            processIdStr = message.substring(lbIdx + 1, rbIdx);
            message = message.substring(colonIdx + 2);
            try {
                processId = Integer.parseInt(processIdStr);
            }
            catch (NumberFormatException ex) {
                LogUtils.debugf((Object)this, (String)"Bad process id '%s'", (Object[])new Object[]{processIdStr});
                processId = 0;
            }
        } else if (lbIdx < 0 && rbIdx < 0 && colonIdx > 0 && spaceIdx == colonIdx + 1) {
            processName = message.substring(0, colonIdx);
            message = message.substring(colonIdx + 2);
        }
        syslogMessage.setProcessId(processId);
        syslogMessage.setProcessName(processName);
        syslogMessage.setMessage(message);
        return syslogMessage;
    }
}

