/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.config.syslogd.HideMatch;
import org.opennms.netmgt.config.syslogd.HideMessage;
import org.opennms.netmgt.config.syslogd.HostaddrMatch;
import org.opennms.netmgt.config.syslogd.HostnameMatch;
import org.opennms.netmgt.config.syslogd.ParameterAssignment;
import org.opennms.netmgt.config.syslogd.ProcessMatch;
import org.opennms.netmgt.config.syslogd.UeiList;
import org.opennms.netmgt.config.syslogd.UeiMatch;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.syslogd.CustomSyslogParser;
import org.opennms.netmgt.syslogd.MessageDiscardedException;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogParserException;
import org.opennms.netmgt.syslogd.SyslogdIPMgr;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Log;

final class ConvertToEvent {
    protected static final String HIDDEN_MESSAGE = "The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.";
    private String m_eventXML;
    private Log m_log;
    private InetAddress m_sender;
    private int m_port;
    private List<Event> m_ackEvents;
    private Event m_event;
    private static Class<? extends SyslogParser> m_parserClass = null;
    private static Map<String, Pattern> m_patterns = new ConcurrentHashMap<String, Pattern>();

    private ConvertToEvent() {
    }

    public static void invalidate() {
        m_parserClass = null;
        m_patterns.clear();
    }

    static ConvertToEvent make(DatagramPacket packet, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessage, String discardUei) throws UnsupportedEncodingException, MessageDiscardedException {
        return ConvertToEvent.make(packet.getAddress(), packet.getPort(), packet.getData(), packet.getLength(), matchPattern, hostGroup, messageGroup, ueiList, hideMessage, discardUei);
    }

    static ConvertToEvent make(InetAddress addr, int port, byte[] data, int len, String matchPattern, int hostGroup, int messageGroup, UeiList ueiList, HideMessage hideMessage, String discardUei) throws UnsupportedEncodingException, MessageDiscardedException {
        List hideMatch;
        List ueiMatch;
        SyslogMessage message;
        SyslogParser parser;
        if (m_parserClass == null) {
            String parser2 = SyslogdConfigFactory.getInstance().getParser();
            try {
                m_parserClass = Class.forName(parser2).asSubclass(SyslogParser.class);
            }
            catch (Exception ex) {
                LogUtils.debugf(ConvertToEvent.class, (Throwable)ex, (String)"Unable to instantiate Syslog parser class specified in config: %s", (Object[])new Object[]{parser2});
                m_parserClass = CustomSyslogParser.class;
            }
        }
        ConvertToEvent e = new ConvertToEvent();
        String deZeroedData = new String(data, 0, len, "US-ASCII");
        if (deZeroedData.endsWith("\u0000")) {
            deZeroedData = deZeroedData.substring(0, deZeroedData.length() - 1);
        }
        e.m_sender = addr;
        e.m_port = port;
        e.m_eventXML = deZeroedData;
        e.m_ackEvents = new ArrayList<Event>(16);
        e.m_log = null;
        LogUtils.debugf(ConvertToEvent.class, (String)"Converting to event: %s", (Object[])new Object[]{e});
        try {
            Method m = m_parserClass.getDeclaredMethod("getParser", String.class);
            Object[] args = new Object[]{e.m_eventXML};
            parser = (SyslogParser)m.invoke(ConvertToEvent.class, args);
        }
        catch (Exception ex) {
            LogUtils.debugf(ConvertToEvent.class, (Throwable)ex, (String)"Unable to get parser for class '%s'", (Object[])new Object[]{m_parserClass.getName()});
            throw new MessageDiscardedException(ex);
        }
        if (!parser.find()) {
            throw new MessageDiscardedException("message does not match");
        }
        try {
            message = parser.parse();
        }
        catch (SyslogParserException ex) {
            LogUtils.debugf(ConvertToEvent.class, (Throwable)ex, (String)"Unable to parse '%s'", (Object[])new Object[]{e.m_eventXML});
            throw new MessageDiscardedException(ex);
        }
        LogUtils.debugf(ConvertToEvent.class, (String)"got syslog message %s", (Object[])new Object[]{message});
        if (message == null) {
            throw new MessageDiscardedException(String.format("Unable to parse '%s'", e.m_eventXML));
        }
        String priorityTxt = message.getSeverity().toString();
        String facilityTxt = message.getFacility().toString();
        EventBuilder bldr = new EventBuilder("uei.opennms.org/syslogd/" + facilityTxt + "/" + priorityTxt, "syslogd");
        bldr.setCreationTime(message.getDate());
        bldr.setHost(InetAddressUtils.getLocalHostName());
        String hostAddress = message.getHostAddress();
        if (hostAddress != null && hostAddress.length() > 0) {
            long nodeId = SyslogdIPMgr.getNodeId(hostAddress);
            if (nodeId != -1L) {
                bldr.setNodeid(nodeId);
            }
            bldr.setInterface(InetAddressUtils.addr((String)hostAddress));
        }
        bldr.setLogDest("logndisplay");
        Pattern msgPat = null;
        Matcher msgMat = null;
        String fullText = message.getFullText();
        String matchedText = message.getMatchedMessage();
        List list = ueiMatch = ueiList == null ? null : ueiList.getUeiMatchCollection();
        if (ueiMatch == null) {
            LogUtils.warnf(ConvertToEvent.class, (String)"No ueiList configured.", (Object[])new Object[0]);
        } else {
            for (UeiMatch uei : ueiMatch) {
                boolean otherStuffMatches;
                boolean bl = otherStuffMatches = ConvertToEvent.matchFacility(uei.getFacilityCollection(), facilityTxt) && ConvertToEvent.matchSeverity(uei.getSeverityCollection(), priorityTxt) && ConvertToEvent.matchProcess(uei.getProcessMatch(), message.getProcessName()) && ConvertToEvent.matchHostname(uei.getHostnameMatch(), message.getHostName()) && ConvertToEvent.matchHostAddr(uei.getHostaddrMatch(), message.getHostAddress());
                if (!(otherStuffMatches && uei.getMatch().getType().equals("substr") ? ConvertToEvent.matchSubstring(discardUei, bldr, matchedText, uei) : otherStuffMatches && uei.getMatch().getType().startsWith("regex") && ConvertToEvent.matchRegex(message, uei, bldr, discardUei))) continue;
                break;
            }
        }
        boolean doHide = false;
        List list2 = hideMatch = hideMessage == null ? null : hideMessage.getHideMatchCollection();
        if (hideMatch == null) {
            LogUtils.warnf(ConvertToEvent.class, (String)"No hideMessage configured.", (Object[])new Object[0]);
        } else {
            for (HideMatch hide : hideMatch) {
                if (hide.getMatch().getType().equals("substr")) {
                    if (fullText.contains(hide.getMatch().getExpression())) {
                        doHide = true;
                    }
                } else if (hide.getMatch().getType().equals("regex")) {
                    try {
                        msgPat = Pattern.compile(hide.getMatch().getExpression(), 8);
                        msgMat = msgPat.matcher(fullText);
                    }
                    catch (PatternSyntaxException pse) {
                        LogUtils.warnf(ConvertToEvent.class, (Throwable)pse, (String)"Failed to compile regex pattern '%s'", (Object[])new Object[]{hide.getMatch().getExpression()});
                        msgMat = null;
                    }
                    if (msgMat != null && msgMat.find()) {
                        doHide = true;
                    }
                }
                if (!doHide) continue;
                LogUtils.debugf(ConvertToEvent.class, (String)"Hiding syslog message from Event - May contain sensitive data", (Object[])new Object[0]);
                message.setMessage(HIDDEN_MESSAGE);
                break;
            }
        }
        bldr.setLogMessage(message.getMessage());
        bldr.addParam("syslogmessage", message.getMessage());
        bldr.addParam("severity", "" + priorityTxt);
        bldr.addParam("timestamp", message.getSyslogFormattedDate());
        if (message.getProcessName() != null) {
            bldr.addParam("process", message.getProcessName());
        }
        bldr.addParam("service", "" + facilityTxt);
        if (message.getProcessId() != null) {
            bldr.addParam("processid", message.getProcessId().toString());
        }
        e.m_event = bldr.getEvent();
        return e;
    }

    private static boolean matchFind(String expression, String input, String context) {
        Pattern pat = ConvertToEvent.getPattern(expression);
        if (pat == null) {
            LogUtils.debugf(ConvertToEvent.class, (String)"Unable to get pattern for expression '%s' in %s context", (Object[])new Object[]{expression, context});
            return false;
        }
        Matcher mat = pat.matcher(input);
        return mat != null && mat.find();
    }

    private static boolean matchHostAddr(HostaddrMatch hostaddrMatch, String hostAddress) {
        if (hostaddrMatch == null) {
            return true;
        }
        if (hostAddress == null) {
            return false;
        }
        String expression = hostaddrMatch.getExpression();
        if (ConvertToEvent.matchFind(expression, hostAddress, "hostaddr-match")) {
            LogUtils.tracef(ConvertToEvent.class, (String)"Successful regex hostaddr-match for input '%s' against expression '%s'", (Object[])new Object[]{hostAddress, expression});
            return true;
        }
        return false;
    }

    private static boolean matchHostname(HostnameMatch hostnameMatch, String hostName) {
        if (hostnameMatch == null) {
            return true;
        }
        if (hostName == null) {
            return false;
        }
        String expression = hostnameMatch.getExpression();
        if (ConvertToEvent.matchFind(expression, hostName, "hostname-match")) {
            LogUtils.tracef(ConvertToEvent.class, (String)"Successful regex hostname-match for input '%s' against expression '%s'", (Object[])new Object[]{hostName, expression});
            return true;
        }
        return false;
    }

    private static boolean matchProcess(ProcessMatch processMatch, String processName) {
        if (processMatch == null) {
            return true;
        }
        if (processName == null) {
            return false;
        }
        String expression = processMatch.getExpression();
        if (ConvertToEvent.matchFind(expression, processName, "process-match")) {
            LogUtils.tracef((Object)"Successful regex process-match for input '%s' against expression '%s'", (String)processName, (Object[])new Object[]{expression});
            return true;
        }
        return false;
    }

    private static boolean matchSeverity(List<String> severities, String priorityTxt) {
        if (severities.size() == 0) {
            return true;
        }
        for (String severity : severities) {
            if (!severity.toLowerCase().equals(priorityTxt.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static boolean matchFacility(List<String> facilities, String facilityTxt) {
        if (facilities.size() == 0) {
            return true;
        }
        for (String facility : facilities) {
            if (!facility.toLowerCase().equals(facilityTxt.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static Pattern getPattern(String expression) {
        Pattern msgPat = m_patterns.get(expression);
        if (msgPat == null) {
            try {
                Pattern newPat = Pattern.compile(expression, 8);
                m_patterns.put(expression, newPat);
                return newPat;
            }
            catch (PatternSyntaxException pse) {
                LogUtils.warnf(ConvertToEvent.class, (Throwable)pse, (String)"Failed to compile regex pattern '%s'", (Object[])new Object[]{expression});
            }
        }
        return msgPat;
    }

    private static boolean matchSubstring(String discardUei, EventBuilder bldr, String message, UeiMatch uei) throws MessageDiscardedException {
        boolean doIMatch = false;
        boolean traceEnabled = LogUtils.isTraceEnabled(ConvertToEvent.class);
        if (message.contains(uei.getMatch().getExpression())) {
            if (discardUei.equals(uei.getUei())) {
                if (traceEnabled) {
                    LogUtils.tracef(ConvertToEvent.class, (String)"Specified UEI '%s' is same as discard-uei, discarding this message.", (Object[])new Object[]{uei.getUei()});
                }
                throw new MessageDiscardedException();
            }
            if (traceEnabled) {
                LogUtils.tracef(ConvertToEvent.class, (String)"Changed the UEI of a Syslogd event, based on substring match, to : %s", (Object[])new Object[]{uei.getUei()});
            }
            bldr.setUei(uei.getUei());
            doIMatch = true;
        } else if (traceEnabled) {
            LogUtils.tracef(ConvertToEvent.class, (String)"No substring match for text of a Syslogd event to : %s", (Object[])new Object[]{uei.getMatch().getExpression()});
        }
        return doIMatch;
    }

    private static boolean matchRegex(SyslogMessage message, UeiMatch uei, EventBuilder bldr, String discardUei) throws MessageDiscardedException {
        boolean traceEnabled = LogUtils.isTraceEnabled(ConvertToEvent.class);
        String expression = uei.getMatch().getExpression();
        Pattern msgPat = ConvertToEvent.getPattern(expression);
        if (msgPat == null) {
            LogUtils.debugf(ConvertToEvent.class, (String)"Unable to create pattern for expression '%s'", (Object[])new Object[]{expression});
            return false;
        }
        String text = message.getMatchedMessage() != null ? message.getMatchedMessage() : message.getFullText();
        Matcher msgMat = msgPat.matcher(text);
        if (msgMat != null && msgMat.find()) {
            if (discardUei.equals(uei.getUei())) {
                LogUtils.debugf(ConvertToEvent.class, (String)"Specified UEI '%s' is same as discard-uei, discarding this message.", (Object[])new Object[]{uei.getUei()});
                throw new MessageDiscardedException();
            }
            bldr.setUei(uei.getUei());
            if (msgMat.groupCount() > 0 && uei.getMatch().isDefaultParameterMapping()) {
                if (traceEnabled) {
                    LogUtils.tracef(ConvertToEvent.class, (String)"Doing default parameter mappings for this regex match.", (Object[])new Object[0]);
                }
                for (int groupNum = 1; groupNum <= msgMat.groupCount(); ++groupNum) {
                    if (traceEnabled) {
                        LogUtils.tracef(ConvertToEvent.class, (String)"Added parm 'group%d' with value '%s' to Syslogd event based on regex match group", (Object[])new Object[]{groupNum, msgMat.group(groupNum)});
                    }
                    bldr.addParam("group" + groupNum, msgMat.group(groupNum));
                }
            }
            if (msgMat.groupCount() > 0 && uei.getParameterAssignmentCount() > 0) {
                if (traceEnabled) {
                    LogUtils.tracef(ConvertToEvent.class, (String)"Doing user-specified parameter assignments for this regex match.", (Object[])new Object[0]);
                }
                for (ParameterAssignment assignment : uei.getParameterAssignmentCollection()) {
                    String parmName = assignment.getParameterName();
                    String parmValue = msgMat.group(assignment.getMatchingGroup());
                    parmValue = parmValue == null ? "" : parmValue;
                    bldr.addParam(parmName, parmValue);
                    if (!traceEnabled) continue;
                    LogUtils.tracef(ConvertToEvent.class, (String)"Added parm '%s' with value '%s' to Syslogd event based on user-specified parameter assignment", (Object[])new Object[]{parmName, parmValue});
                }
            }
            return true;
        }
        if (traceEnabled) {
            LogUtils.tracef(ConvertToEvent.class, (String)"Message '%s' did not regex-match pattern '%s'", (Object[])new Object[]{message.getMessage(), expression});
        }
        return false;
    }

    Log unmarshal() throws ValidationException, MarshalException {
        if (this.m_log == null) {
            this.m_log = (Log)JaxbUtils.unmarshal(Log.class, (String)this.m_eventXML);
        }
        return this.m_log;
    }

    void ackEvent(Event e) {
        if (!this.m_ackEvents.contains(e)) {
            this.m_ackEvents.add(e);
        }
    }

    String getXmlData() {
        return this.m_eventXML;
    }

    InetAddress getSender() {
        return this.m_sender;
    }

    int getPort() {
        return this.m_port;
    }

    public List<Event> getAckedEvents() {
        return this.m_ackEvents;
    }

    public Event getEvent() {
        return this.m_event;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof ConvertToEvent) {
            ConvertToEvent e = (ConvertToEvent)o;
            return this == e || this.m_port == e.m_port && this.m_sender.equals(e.m_sender);
        }
        return false;
    }

    public int hashCode() {
        return this.m_port ^ this.m_sender.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Sender", (Object)this.m_sender).append("Port", this.m_port).append("Acknowledged Events", this.m_ackEvents).append("Event", (Object)this.m_event).toString();
    }
}

