/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.opennms.core.utils.DefaultTimeKeeper;
import org.opennms.core.utils.TimeKeeper;

public enum RelativeTime {
    THISYEAR{

        @Override
        public Date getStart() {
            TimeZone timeZone = this.getTimeZone();
            GregorianCalendar yearCalendar = new GregorianCalendar(timeZone);
            GregorianCalendar januaryFirst = new GregorianCalendar(yearCalendar.get(1), 0, 1);
            januaryFirst.setTimeZone(timeZone);
            return new Date(januaryFirst.getTimeInMillis());
        }

        @Override
        public Date getEnd() {
            return this.getStartOfToday();
        }
    }
    ,
    LASTTHIRTYONEDAYS{

        @Override
        public Date getStart() {
            return this.getStartDate(31);
        }

        @Override
        public Date getEnd() {
            return this.getStartOfToday();
        }
    }
    ,
    LASTSEVENDAYS{

        @Override
        public Date getStart() {
            return this.getStartDate(7);
        }

        @Override
        public Date getEnd() {
            return this.getStartOfToday();
        }
    }
    ,
    YESTERDAY{

        @Override
        public Date getStart() {
            return this.getStartDate(1);
        }

        @Override
        public Date getEnd() {
            return this.getStartOfToday();
        }
    }
    ,
    LASTHOUR{

        @Override
        public Date getStart() {
            GregorianCalendar calendar = new GregorianCalendar(this.getTimeZone());
            calendar.setTimeInMillis(this.getCurrentTime());
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            ((Calendar)calendar).add(10, -1);
            return calendar.getTime();
        }

        @Override
        public Date getEnd() {
            GregorianCalendar calendar = new GregorianCalendar(this.getTimeZone());
            calendar.setTimeInMillis(this.getCurrentTime());
            calendar.set(14, 0);
            calendar.set(13, 0);
            calendar.set(12, 0);
            return calendar.getTime();
        }
    };

    private static TimeKeeper DEFAULT_TIME_KEEPER;
    private TimeKeeper m_timeKeeper = null;

    protected Date getStartDate(int offset) {
        GregorianCalendar calendar = new GregorianCalendar(this.getTimeZone());
        calendar.setTimeInMillis(this.getCurrentTime());
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        ((Calendar)calendar).add(6, -offset);
        return calendar.getTime();
    }

    protected Date getStartOfToday() {
        GregorianCalendar calendar = new GregorianCalendar(this.getTimeZone());
        calendar.setTimeInMillis(this.getCurrentTime());
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        return calendar.getTime();
    }

    public abstract Date getStart();

    public abstract Date getEnd();

    public TimeKeeper getTimeKeeper() {
        return this.m_timeKeeper;
    }

    public void setTimeKeeper(TimeKeeper timeKeeper) {
        this.m_timeKeeper = timeKeeper;
    }

    protected long getCurrentTime() {
        return this.myTimeKeeper().getCurrentTime();
    }

    protected TimeZone getTimeZone() {
        return this.myTimeKeeper().getTimeZone();
    }

    protected TimeKeeper myTimeKeeper() {
        return this.getTimeKeeper() == null ? DEFAULT_TIME_KEEPER : this.getTimeKeeper();
    }

    static {
        DEFAULT_TIME_KEEPER = new DefaultTimeKeeper();
    }
}

