/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;

final class BroadcastEventProcessor
implements EventListener {
    private final FifoQueue<Event> m_execQ;

    BroadcastEventProcessor(FifoQueue<Event> execQ) {
        this.m_execQ = execQ;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener(this);
    }

    public synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        ThreadCategory log = ThreadCategory.getInstance(BroadcastEventProcessor.class);
        try {
            this.m_execQ.add((Object)event);
            if (log.isDebugEnabled()) {
                log.debug("Added event '" + event.getUei() + "' to scriptd execution queue.");
            }
        }
        catch (FifoQueueException ex) {
            log.error("Failed to add event to scriptd execution queue", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            log.error("Failed to add event to scriptd execution queue", (Throwable)ex);
        }
    }

    public String getName() {
        return "Scriptd:BroadcastEventProcessor";
    }
}

