/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.io.File;
import java.net.InetAddress;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.threshd.LatencyThresholdingSet;
import org.opennms.netmgt.threshd.ThresholdingEventProxy;
import org.opennms.netmgt.xml.event.Event;

public class LatencyStoringServiceMonitorAdaptor
implements ServiceMonitor {
    public static final String DEFAULT_BASENAME = "response-time";
    private ServiceMonitor m_serviceMonitor;
    private PollerConfig m_pollerConfig;
    private Package m_pkg;
    private LatencyThresholdingSet m_thresholdingSet;

    public LatencyStoringServiceMonitorAdaptor(ServiceMonitor monitor, PollerConfig config, Package pkg) {
        this.m_serviceMonitor = monitor;
        this.m_pollerConfig = config;
        this.m_pkg = pkg;
    }

    public void initialize(Map<String, Object> parameters) {
        this.m_serviceMonitor.initialize(parameters);
    }

    public void initialize(MonitoredService svc) {
        this.m_serviceMonitor.initialize(svc);
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        PollStatus status = this.m_serviceMonitor.poll(svc, parameters);
        if (!status.getProperties().isEmpty()) {
            this.storeResponseTime(svc, new LinkedHashMap<String, Number>(status.getProperties()), parameters);
        }
        if ("true".equals(ParameterMap.getKeyedString(parameters, (String)"invert-status", (String)"false"))) {
            if (status.isAvailable()) {
                return PollStatus.unavailable((String)"This is an inverted service and the underlying service has started responding");
            }
            return PollStatus.available();
        }
        return status;
    }

    private void storeResponseTime(MonitoredService svc, LinkedHashMap<String, Number> entries, Map<String, Object> parameters) {
        String rrdPath = ParameterMap.getKeyedString(parameters, (String)"rrd-repository", null);
        String dsName = ParameterMap.getKeyedString(parameters, (String)"ds-name", (String)DEFAULT_BASENAME);
        String rrdBaseName = ParameterMap.getKeyedString(parameters, (String)"rrd-base-name", (String)dsName);
        String thresholds = ParameterMap.getKeyedString(parameters, (String)"thresholding-enabled", (String)"false");
        if (!entries.containsKey(dsName) && entries.containsKey(DEFAULT_BASENAME)) {
            entries.put(dsName, entries.get(DEFAULT_BASENAME));
            entries.remove(DEFAULT_BASENAME);
        }
        if (thresholds.toLowerCase().equals("true")) {
            this.applyThresholds(rrdPath, svc, dsName, entries);
        } else {
            this.log().debug("storeResponseTime: Thresholds processing is not enabled. Check thresholding-enabled parameter on service definition");
        }
        if (rrdPath == null) {
            this.log().debug("storeResponseTime: RRD repository not specified in parameters, latency data will not be stored.");
            return;
        }
        this.updateRRD(rrdPath, svc.getAddress(), rrdBaseName, entries);
    }

    private void applyThresholds(String rrdPath, MonitoredService service, String dsName, LinkedHashMap<String, Number> entries) {
        try {
            List<Event> events;
            if (this.m_thresholdingSet == null) {
                RrdRepository repository = new RrdRepository();
                repository.setRrdBaseDir(new File(rrdPath));
                this.m_thresholdingSet = new LatencyThresholdingSet(service.getNodeId(), service.getIpAddr(), service.getSvcName(), repository);
            }
            LinkedHashMap<String, Double> attributes = new LinkedHashMap<String, Double>();
            for (String ds : entries.keySet()) {
                attributes.put(ds, entries.get(ds).doubleValue());
            }
            if (this.m_thresholdingSet.hasThresholds(attributes) && (events = this.m_thresholdingSet.applyThresholds(dsName, attributes)).size() > 0) {
                ThresholdingEventProxy proxy = new ThresholdingEventProxy();
                proxy.add(events);
                proxy.sendAllEvents();
            }
        }
        catch (Throwable e) {
            this.log().error("Failed to threshold on " + service + " for " + dsName + " because of an exception", e);
        }
    }

    public void updateRRD(String repository, InetAddress addr, String rrdBaseName, String dsName, long value) {
        LinkedHashMap<String, Number> lhm = new LinkedHashMap<String, Number>();
        lhm.put(dsName, value);
        this.updateRRD(repository, addr, rrdBaseName, lhm);
    }

    public void updateRRD(String repository, InetAddress addr, String rrdBaseName, LinkedHashMap<String, Number> entries) {
        block6: {
            try {
                ArrayList<RrdDataSource> dsList = new ArrayList<RrdDataSource>(entries.size());
                for (String dsName : entries.keySet()) {
                    dsList.add(new RrdDataSource(dsName, "GAUGE", this.m_pollerConfig.getStep(this.m_pkg) * 2, "U", "U"));
                }
                this.createRRD(repository, addr, rrdBaseName, dsList);
                String hostAddress = InetAddressUtils.str((InetAddress)addr);
                String path = repository + File.separator + hostAddress;
                StringBuffer value = new StringBuffer();
                Iterator<String> i = entries.keySet().iterator();
                while (i.hasNext()) {
                    Number num = entries.get(i.next());
                    if (num == null || Double.isNaN(num.doubleValue())) {
                        value.append("U");
                    } else {
                        NumberFormat nf = NumberFormat.getInstance(Locale.US);
                        nf.setGroupingUsed(false);
                        nf.setMinimumFractionDigits(0);
                        nf.setMaximumFractionDigits(Integer.MAX_VALUE);
                        nf.setMinimumIntegerDigits(0);
                        nf.setMaximumIntegerDigits(Integer.MAX_VALUE);
                        value.append(nf.format(num.doubleValue()));
                    }
                    if (!i.hasNext()) continue;
                    value.append(":");
                }
                RrdUtils.updateRRD((String)hostAddress, (String)path, (String)rrdBaseName, (String)value.toString());
            }
            catch (RrdException e) {
                if (!this.log().isEnabledFor(ThreadCategory.Level.ERROR)) break block6;
                String msg = e.getMessage();
                this.log().error(msg);
                throw new RuntimeException(msg, e);
            }
        }
    }

    public boolean createRRD(String repository, InetAddress addr, String rrdBaseName, String dsName) throws RrdException {
        List<RrdDataSource> dsList = Collections.singletonList(new RrdDataSource(dsName, "GAUGE", this.m_pollerConfig.getStep(this.m_pkg) * 2, "U", "U"));
        return this.createRRD(repository, addr, rrdBaseName, dsList);
    }

    public boolean createRRD(String repository, InetAddress addr, String rrdBaseName, List<RrdDataSource> dsList) throws RrdException {
        List<String> rraList = this.m_pollerConfig.getRRAList(this.m_pkg);
        String hostAddress = InetAddressUtils.str((InetAddress)addr);
        String path = repository + File.separator + hostAddress;
        return RrdUtils.createRRD((String)hostAddress, (String)path, (String)rrdBaseName, (int)this.m_pollerConfig.getStep(this.m_pkg), dsList, rraList);
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void release() {
        this.m_serviceMonitor.release();
    }

    public void release(MonitoredService svc) {
        this.m_serviceMonitor.release(svc);
    }

    public void refreshThresholds() {
        if (this.m_thresholdingSet != null) {
            this.m_thresholdingSet.reinitialize();
        }
    }
}

