/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.LinkdConfig;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.linkd.Package;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.QueryManager;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventForwarder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class Linkd
extends AbstractServiceDaemon {
    private static final String LOG4J_CATEGORY = "OpenNMS.Linkd";
    @Autowired
    private Scheduler m_scheduler;
    @Autowired
    private QueryManager m_queryMgr;
    @Autowired
    private LinkdConfig m_linkdConfig;
    private List<LinkableNode> m_nodes;
    private List<String> m_activepackages;
    private Set<InetAddress> m_newSuspectEventsIpAddr = null;
    private volatile EventForwarder m_eventForwarder;

    public Linkd() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() {
        Assert.state((this.m_queryMgr != null ? 1 : 0) != 0, (String)"must set the queryManager property");
        Assert.state((this.m_linkdConfig != null ? 1 : 0) != 0, (String)"must set the linkdConfig property");
        Assert.state((this.m_scheduler != null ? 1 : 0) != 0, (String)"must set the scheduler property");
        Assert.state((this.m_eventForwarder != null ? 1 : 0) != 0, (String)"must set the eventForwarder property");
        this.m_queryMgr.setLinkd(this);
        this.m_activepackages = new ArrayList<String>();
        this.m_newSuspectEventsIpAddr = new TreeSet<InetAddress>((Comparator<InetAddress>)new InetAddressComparator());
        this.m_newSuspectEventsIpAddr.add(InetAddressUtils.addr((String)"127.0.0.1"));
        this.m_newSuspectEventsIpAddr.add(InetAddressUtils.addr((String)"0.0.0.0"));
        try {
            this.m_nodes = this.m_queryMgr.getSnmpNodeList();
            this.m_queryMgr.updateDeletedNodes();
        }
        catch (SQLException e) {
            LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"SQL exception executing on database", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        Assert.notNull(this.m_nodes);
        this.scheduleCollection();
        LogUtils.infof((Object)((Object)this), (String)"init: LINKD CONFIGURATION INITIALIZED", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCollection() {
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            for (LinkableNode node : this.m_nodes) {
                this.scheduleCollectionForNode(node);
            }
        }
    }

    private void scheduleCollectionForNode(LinkableNode node) {
        for (SnmpCollection snmpcoll : this.getSnmpCollections(node.getNodeId(), node.getSnmpPrimaryIpAddr(), node.getSysoid())) {
            if (this.m_activepackages.contains(snmpcoll.getPackageName())) {
                LogUtils.debugf((Object)((Object)this), (String)"ScheduleCollectionForNode: package active: %s", (Object[])new Object[]{snmpcoll.getPackageName()});
            } else {
                LogUtils.debugf((Object)((Object)this), (String)"ScheduleCollectionForNode: Scheduling Discovery Link for Active Package: %s", (Object[])new Object[]{snmpcoll.getPackageName()});
                DiscoveryLink discovery = this.getDiscoveryLink(snmpcoll.getPackageName());
                if (discovery.getScheduler() == null) {
                    discovery.setScheduler(this.m_scheduler);
                }
                discovery.schedule();
                this.m_activepackages.add(snmpcoll.getPackageName());
            }
            if (snmpcoll.getScheduler() == null) {
                snmpcoll.setScheduler(this.m_scheduler);
            }
            LogUtils.debugf((Object)((Object)this), (String)"ScheduleCollectionForNode: Scheduling SNMP Collection for Package/NodeId: %s/%d/%s", (Object[])new Object[]{snmpcoll.getPackageName(), node.getNodeId(), snmpcoll.getInfo()});
            snmpcoll.schedule();
        }
    }

    public DiscoveryLink getDiscoveryLink(String pkgName) {
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        if (pkg == null) {
            return null;
        }
        DiscoveryLink discoveryLink = new DiscoveryLink();
        discoveryLink.setLinkd(this);
        discoveryLink.setPackageName(pkg.getName());
        discoveryLink.setInitialSleepTime(this.m_linkdConfig.getInitialSleepTime());
        discoveryLink.setSnmpPollInterval(pkg.hasSnmp_poll_interval() ? pkg.getSnmp_poll_interval() : this.m_linkdConfig.getSnmpPollInterval());
        discoveryLink.setDiscoveryInterval(pkg.hasDiscovery_link_interval() ? pkg.getDiscovery_link_interval() : this.m_linkdConfig.getDiscoveryLinkInterval());
        discoveryLink.setDiscoveryUsingBridge(pkg.hasUseBridgeDiscovery() ? pkg.getUseBridgeDiscovery() : this.m_linkdConfig.useBridgeDiscovery());
        discoveryLink.setDiscoveryUsingCdp(pkg.hasUseCdpDiscovery() ? pkg.getUseCdpDiscovery() : this.m_linkdConfig.useCdpDiscovery());
        discoveryLink.setDiscoveryUsingRoutes(pkg.hasUseIpRouteDiscovery() ? pkg.getUseIpRouteDiscovery() : this.m_linkdConfig.useIpRouteDiscovery());
        discoveryLink.setEnableDownloadDiscovery(pkg.hasEnableDiscoveryDownload() ? pkg.getEnableDiscoveryDownload() : this.m_linkdConfig.enableDiscoveryDownload());
        discoveryLink.setForceIpRouteDiscoveryOnEtherNet(pkg.hasForceIpRouteDiscoveryOnEthernet() ? pkg.getForceIpRouteDiscoveryOnEthernet() : this.m_linkdConfig.forceIpRouteDiscoveryOnEthernet());
        return discoveryLink;
    }

    public SnmpCollection getSnmpCollection(int nodeid, InetAddress ipaddr, String sysoid, String pkgName) {
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        if (pkg != null) {
            SnmpCollection collection = this.createCollection(nodeid, ipaddr);
            this.populateSnmpCollection(collection, pkg, sysoid);
            return collection;
        }
        return null;
    }

    public List<SnmpCollection> getSnmpCollections(int nodeid, InetAddress ipaddr, String sysoid) {
        ArrayList<SnmpCollection> snmpcolls = new ArrayList<SnmpCollection>();
        for (String pkgName : this.m_linkdConfig.getAllPackageMatches(ipaddr)) {
            snmpcolls.add(this.getSnmpCollection(nodeid, ipaddr, sysoid, pkgName));
        }
        return snmpcolls;
    }

    public SnmpCollection createCollection(int nodeid, InetAddress ipaddr) {
        SnmpCollection coll = null;
        try {
            coll = new SnmpCollection(this, nodeid, SnmpPeerFactory.getInstance().getAgentConfig(ipaddr));
        }
        catch (Throwable t) {
            LogUtils.errorf((Object)((Object)this), (Throwable)t, (String)"getSnmpCollection: Failed to load snmpcollection parameter from SNMP configuration file", (Object[])new Object[0]);
        }
        return coll;
    }

    private void populateSnmpCollection(SnmpCollection coll, Package pkg, String sysoid) {
        coll.setPackageName(pkg.getName());
        coll.setInitialSleepTime(this.m_linkdConfig.getInitialSleepTime());
        coll.setPollInterval(pkg.hasSnmp_poll_interval() ? pkg.getSnmp_poll_interval() : this.m_linkdConfig.getSnmpPollInterval());
        if (this.m_linkdConfig.hasIpRouteClassName(sysoid)) {
            coll.setIpRouteClass(this.m_linkdConfig.getIpRouteClassName(sysoid));
            LogUtils.debugf((Object)((Object)this), (String)"populateSnmpCollection: found class to get ipRoute: %s", (Object[])new Object[]{coll.getIpRouteClass()});
        } else {
            coll.setIpRouteClass(this.m_linkdConfig.getDefaultIpRouteClassName());
            LogUtils.debugf((Object)((Object)this), (String)"populateSnmpCollection: Using default class to get ipRoute: %s", (Object[])new Object[]{coll.getIpRouteClass()});
        }
        if (pkg.hasEnableVlanDiscovery() && pkg.getEnableVlanDiscovery() && this.m_linkdConfig.hasClassName(sysoid)) {
            coll.setVlanClass(this.m_linkdConfig.getVlanClassName(sysoid));
            LogUtils.debugf((Object)((Object)this), (String)"populateSnmpCollection: found class to get Vlans: %s", (Object[])new Object[]{coll.getVlanClass()});
        } else if (!pkg.hasEnableVlanDiscovery() && this.m_linkdConfig.isVlanDiscoveryEnabled() && this.m_linkdConfig.hasClassName(sysoid)) {
            coll.setVlanClass(this.m_linkdConfig.getVlanClassName(sysoid));
            LogUtils.debugf((Object)((Object)this), (String)"populateSnmpCollection: found class to get Vlans: %s", (Object[])new Object[]{coll.getVlanClass()});
        } else {
            LogUtils.debugf((Object)((Object)this), (String)"populateSnmpCollection: no class found to get Vlans or VlanDiscoveryDisabled for Package: %s", (Object[])new Object[]{pkg.getName()});
        }
        coll.collectCdpTable(pkg.hasUseCdpDiscovery() ? pkg.getUseCdpDiscovery() : this.m_linkdConfig.useCdpDiscovery());
        boolean useIpRouteDiscovery = pkg.hasUseIpRouteDiscovery() ? pkg.getUseIpRouteDiscovery() : this.m_linkdConfig.useIpRouteDiscovery();
        boolean saveRouteTable = pkg.hasSaveRouteTable() ? pkg.getSaveRouteTable() : this.m_linkdConfig.saveRouteTable();
        coll.SaveIpRouteTable(saveRouteTable);
        coll.collectIpRouteTable(useIpRouteDiscovery || saveRouteTable);
        boolean useBridgeDiscovery = pkg.hasUseBridgeDiscovery() ? pkg.getUseBridgeDiscovery() : this.m_linkdConfig.useBridgeDiscovery();
        coll.collectBridgeForwardingTable(useBridgeDiscovery);
        boolean saveStpNodeTable = pkg.hasSaveStpNodeTable() ? pkg.getSaveStpNodeTable() : this.m_linkdConfig.saveStpNodeTable();
        coll.saveStpNodeTable(saveStpNodeTable);
        coll.collectStpNode(useBridgeDiscovery || saveStpNodeTable);
        boolean saveStpInterfaceTable = pkg.hasSaveStpInterfaceTable() ? pkg.getSaveStpInterfaceTable() : this.m_linkdConfig.saveStpInterfaceTable();
        coll.saveStpInterfaceTable(saveStpInterfaceTable);
        coll.collectStpTable(useBridgeDiscovery || saveStpInterfaceTable);
    }

    protected synchronized void onStart() {
        LogUtils.debugf((Object)((Object)this), (String)"start: Starting linkd scheduler", (Object[])new Object[0]);
        this.m_scheduler.start();
    }

    protected synchronized void onStop() {
        this.m_scheduler.stop();
        this.m_scheduler = null;
    }

    protected synchronized void onPause() {
        this.m_scheduler.pause();
    }

    protected synchronized void onResume() {
        this.m_scheduler.resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LinkableNode> getLinkableNodes() {
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            return this.m_nodes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<LinkableNode> getLinkableNodesOnPackage(String pkg) {
        ArrayList<LinkableNode> nodesOnPkg = new ArrayList<LinkableNode>();
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            for (LinkableNode node : this.m_nodes) {
                if (!this.isInterfaceInPackage(node.getSnmpPrimaryIpAddr(), pkg)) continue;
                nodesOnPkg.add(node);
            }
            return nodesOnPkg;
        }
    }

    public boolean isInterfaceInPackage(InetAddress ipaddr, String pkg) {
        return this.m_linkdConfig.isInterfaceInPackage(ipaddr, this.m_linkdConfig.getPackage(pkg));
    }

    public boolean isInterfaceInPackageRange(InetAddress ipaddr, String pkg) {
        return this.m_linkdConfig.isInterfaceInPackageRange(ipaddr, this.m_linkdConfig.getPackage(pkg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleNodeCollection(int nodeid) {
        LinkableNode node = null;
        this.m_linkdConfig.updatePackageIpListMap();
        LogUtils.debugf((Object)((Object)this), (String)"scheduleNodeCollection: Loading node %d from database", (Object[])new Object[]{nodeid});
        try {
            node = this.m_queryMgr.getSnmpNode(nodeid);
            if (node == null) {
                LogUtils.warnf((Object)((Object)this), (String)"scheduleNodeCollection: Failed to get linkable node from database with ID %d. Exiting", (Object[])new Object[]{nodeid});
                return false;
            }
        }
        catch (SQLException sqlE) {
            LogUtils.errorf((Object)((Object)this), (Throwable)sqlE, (String)"scheduleNodeCollection: SQL Exception while syncing node object with ID %d with database information.", (Object[])new Object[]{nodeid});
            return false;
        }
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            LogUtils.debugf((Object)((Object)this), (String)"adding node %s to the collection", (Object[])new Object[]{node});
            this.m_nodes.add(node);
        }
        this.scheduleCollectionForNode(node);
        return true;
    }

    public boolean runSingleCollection(int nodeId) {
        try {
            LinkableNode node = this.m_queryMgr.getSnmpNode(nodeId);
            for (SnmpCollection snmpColl : this.getSnmpCollections(nodeId, node.getSnmpPrimaryIpAddr(), node.getSysoid())) {
                snmpColl.setScheduler(this.m_scheduler);
                snmpColl.run();
                DiscoveryLink link = this.getDiscoveryLink(snmpColl.getPackageName());
                link.setScheduler(this.m_scheduler);
                link.run();
            }
            return true;
        }
        catch (SQLException e) {
            LogUtils.debugf((Object)((Object)this), (String)"runSingleCollection: unable to get linkable node from database with ID %d", (Object[])new Object[]{nodeId});
            return false;
        }
    }

    void wakeUpNodeCollection(int nodeid) {
        LinkableNode node = this.getNode(nodeid);
        if (node == null) {
            LogUtils.warnf((Object)((Object)this), (String)"wakeUpNodeCollection: node not found during scheduling with ID %d", (Object[])new Object[]{nodeid});
            this.scheduleNodeCollection(nodeid);
        } else {
            List<SnmpCollection> collections = this.getSnmpCollections(nodeid, node.getSnmpPrimaryIpAddr(), node.getSysoid());
            LogUtils.debugf((Object)((Object)this), (String)"wakeUpNodeCollection: fetched SnmpCollections from scratch, iterating over %d objects to wake them up", (Object[])new Object[]{collections.size()});
            for (SnmpCollection collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LogUtils.warnf((Object)((Object)this), (String)"wakeUpNodeCollection: found null ReadyRunnable", (Object[])new Object[0]);
                    return;
                }
                rr.wakeUp();
            }
        }
    }

    void deleteNode(int nodeid) {
        LogUtils.debugf((Object)((Object)this), (String)"deleteNode: deleting LinkableNode for node %s", (Object[])new Object[]{nodeid});
        try {
            this.m_queryMgr.update(nodeid, 'D');
        }
        catch (SQLException sqlE) {
            LogUtils.errorf((Object)((Object)this), (Throwable)sqlE, (String)"deleteNode: SQL Exception while syncing node object with database information.", (Object[])new Object[0]);
        }
        LinkableNode node = this.removeNode(nodeid);
        if (node == null) {
            LogUtils.warnf((Object)((Object)this), (String)"deleteNode: node not found: %d", (Object[])new Object[]{nodeid});
        } else {
            List<SnmpCollection> collections = this.getSnmpCollections(nodeid, node.getSnmpPrimaryIpAddr(), node.getSysoid());
            LogUtils.debugf((Object)((Object)this), (String)"deleteNode: fetched SnmpCollections from scratch, iterating over %d objects to wake them up", (Object[])new Object[]{collections.size()});
            for (SnmpCollection collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LogUtils.warnf((Object)((Object)this), (String)"deleteNode: found null ReadyRunnable", (Object[])new Object[0]);
                    return;
                }
                rr.unschedule();
            }
        }
        this.m_linkdConfig.updatePackageIpListMap();
    }

    void deleteInterface(int nodeid, String ipAddr, int ifIndex) {
        LogUtils.debugf((Object)((Object)this), (String)"deleteInterface: marking table entries as deleted for node %d with IP address %s and ifIndex %s", (Object[])new Object[]{nodeid, ipAddr, ifIndex > -1 ? "" + ifIndex : "N/A"});
        try {
            this.m_queryMgr.updateForInterface(nodeid, ipAddr, ifIndex, 'D');
        }
        catch (SQLException sqlE) {
            LogUtils.errorf((Object)((Object)this), (Throwable)sqlE, (String)"deleteInterface: SQL Exception while updating database.", (Object[])new Object[0]);
        }
        this.m_linkdConfig.updatePackageIpListMap();
    }

    void suspendNodeCollection(int nodeid) {
        LogUtils.debugf((Object)((Object)this), (String)"suspendNodeCollection: suspend collection LinkableNode for node %d", (Object[])new Object[]{nodeid});
        try {
            this.m_queryMgr.update(nodeid, 'N');
        }
        catch (SQLException sqlE) {
            LogUtils.errorf((Object)((Object)this), (Throwable)sqlE, (String)"suspendNodeCollection: SQL Exception while syncing node object with database information.", (Object[])new Object[0]);
        }
        LinkableNode node = this.getNode(nodeid);
        if (node == null) {
            LogUtils.warnf((Object)((Object)this), (String)"suspendNodeCollection: found null ReadyRunnable", (Object[])new Object[0]);
        } else {
            List<SnmpCollection> collections = this.getSnmpCollections(nodeid, node.getSnmpPrimaryIpAddr(), node.getSysoid());
            LogUtils.debugf((Object)((Object)this), (String)"suspendNodeCollection: fetched SnmpCollections from scratch, iterating over %d objects to wake them up", (Object[])new Object[]{collections.size()});
            for (SnmpCollection collection : collections) {
                ReadyRunnable rr = this.getReadyRunnable(collection);
                if (rr == null) {
                    LogUtils.warnf((Object)((Object)this), (String)"suspendNodeCollection: suspend: node not found: %d", (Object[])new Object[]{nodeid});
                    return;
                }
                rr.suspend();
            }
        }
    }

    private ReadyRunnable getReadyRunnable(ReadyRunnable runnable) {
        LogUtils.debugf((Object)((Object)this), (String)"getReadyRunnable: get ReadyRunnable from scheduler: %s", (Object[])new Object[]{runnable.getInfo()});
        return this.m_scheduler.getReadyRunnable(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void updateNodeSnmpCollection(SnmpCollection snmpcoll) {
        LogUtils.debugf((Object)((Object)this), (String)"Updating SNMP collection for %s", (Object[])new Object[]{InetAddressUtils.str((InetAddress)snmpcoll.getTarget())});
        LinkableNode node = this.removeNode(snmpcoll.getTarget());
        if (node == null) {
            LogUtils.errorf((Object)((Object)this), (String)"No node found for SNMP collection: %s unscheduling!", (Object[])new Object[]{snmpcoll.getInfo()});
            this.m_scheduler.unschedule(snmpcoll);
            return;
        }
        try {
            node = this.m_queryMgr.storeSnmpCollection(node, snmpcoll);
        }
        catch (SQLException e) {
            LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"Failed to save on db snmpcollection/package: %s/%s", (Object[])new Object[]{snmpcoll.getPackageName(), snmpcoll.getInfo()});
            return;
        }
        if (node != null) {
            List<LinkableNode> list = this.m_nodes;
            synchronized (list) {
                this.m_nodes.add(node);
            }
        }
    }

    void updateDiscoveryLinkCollection(DiscoveryLink discover) {
        try {
            this.m_queryMgr.storeDiscoveryLink(discover);
        }
        catch (SQLException e) {
            LogUtils.errorf((Object)((Object)this), (Throwable)e, (String)"Failed to save discoverylink on database for package: %s", (Object[])new Object[]{discover.getPackageName()});
        }
    }

    void sendNewSuspectEvent(InetAddress ipaddress, InetAddress ipowner, String pkgName) {
        if (this.m_newSuspectEventsIpAddr.contains(ipaddress)) {
            LogUtils.infof((Object)((Object)this), (String)"sendNewSuspectEvent: nothing to send, suspect event previously sent for IP address: %s", (Object[])new Object[]{InetAddressUtils.str((InetAddress)ipaddress)});
            return;
        }
        if (!this.isInterfaceInPackageRange(ipaddress, pkgName)) {
            LogUtils.infof((Object)((Object)this), (String)"sendNewSuspectEvent: nothing to send for IP address: %s, not in package: %s", (Object[])new Object[]{InetAddressUtils.str((InetAddress)ipaddress), pkgName});
            return;
        }
        Package pkg = this.m_linkdConfig.getPackage(pkgName);
        boolean autodiscovery = false;
        autodiscovery = pkg.hasAutoDiscovery() ? pkg.getAutoDiscovery() : this.m_linkdConfig.isAutoDiscoveryEnabled();
        if (autodiscovery) {
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "linkd");
            bldr.setHost(InetAddressUtils.str((InetAddress)ipowner));
            bldr.setInterface(ipaddress);
            this.m_eventForwarder.sendNow(bldr.getEvent());
            this.m_newSuspectEventsIpAddr.add(ipaddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkableNode getNode(int nodeid) {
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            for (LinkableNode node : this.m_nodes) {
                if (node.getNodeId() != nodeid) continue;
                return node;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkableNode removeNode(int nodeid) {
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            Iterator<LinkableNode> ite = this.m_nodes.iterator();
            while (ite.hasNext()) {
                LinkableNode curNode = ite.next();
                if (curNode.getNodeId() != nodeid) continue;
                ite.remove();
                return curNode;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkableNode removeNode(InetAddress ipaddr) {
        List<LinkableNode> list = this.m_nodes;
        synchronized (list) {
            Iterator<LinkableNode> ite = this.m_nodes.iterator();
            while (ite.hasNext()) {
                LinkableNode curNode = ite.next();
                if (!curNode.getSnmpPrimaryIpAddr().equals(ipaddr)) continue;
                ite.remove();
                return curNode;
            }
        }
        return null;
    }

    public QueryManager getQueryManager() {
        return this.m_queryMgr;
    }

    public void setQueryManager(QueryManager queryMgr) {
        this.m_queryMgr = queryMgr;
        queryMgr.setLinkd(this);
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public LinkdConfig getLinkdConfig() {
        return this.m_linkdConfig;
    }

    public void setLinkdConfig(LinkdConfig config) {
        this.m_linkdConfig = config;
    }

    public EventForwarder getEventForwarder() {
        return this.m_eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.m_eventForwarder = eventForwarder;
    }
}

