/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.AtInterfaceDao;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.IpRouteInterfaceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.dao.StpInterfaceDao;
import org.opennms.netmgt.dao.StpNodeDao;
import org.opennms.netmgt.dao.VlanDao;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.linkd.AbstractQueryManager;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.EventUtils;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsAtInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpRouteInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsStpInterface;
import org.opennms.netmgt.model.OnmsStpNode;
import org.opennms.netmgt.model.OnmsVlan;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class HibernateEventWriter
extends AbstractQueryManager
implements InitializingBean {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private AtInterfaceDao m_atInterfaceDao;
    @Autowired
    private VlanDao m_vlanDao;
    @Autowired
    private StpNodeDao m_stpNodeDao;
    @Autowired
    private StpInterfaceDao m_stpInterfaceDao;
    @Autowired
    private IpRouteInterfaceDao m_ipRouteInterfaceDao;
    @Autowired
    private DataLinkInterfaceDao m_dataLinkInterfaceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;

    @Override
    public List<LinkableNode> getSnmpNodeList() throws SQLException {
        ArrayList<LinkableNode> nodes = new ArrayList<LinkableNode>();
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("ipInterfaces", "iface", 1);
        criteria.add((Criterion)Restrictions.eq((String)"type", (Object)"A"));
        criteria.add((Criterion)Restrictions.eq((String)"iface.isSnmpPrimary", (Object)OnmsIpInterface.PrimaryType.PRIMARY));
        for (OnmsNode node : this.m_nodeDao.findMatching(criteria)) {
            String sysObjectId = node.getSysObjectId();
            nodes.add(new LinkableNode(node.getId(), node.getPrimaryInterface().getIpAddress(), sysObjectId == null ? "-1" : sysObjectId));
        }
        return nodes;
    }

    @Override
    public LinkableNode getSnmpNode(int nodeid) throws SQLException {
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class);
        criteria.createAlias("ipInterfaces", "iface", 1);
        criteria.add((Criterion)Restrictions.eq((String)"type", (Object)"A"));
        criteria.add((Criterion)Restrictions.eq((String)"iface.isSnmpPrimary", (Object)OnmsIpInterface.PrimaryType.PRIMARY));
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)nodeid));
        List nodes = this.m_nodeDao.findMatching(criteria);
        if (nodes.size() > 0) {
            OnmsNode node = (OnmsNode)nodes.get(0);
            String sysObjectId = node.getSysObjectId();
            return new LinkableNode(node.getId(), node.getPrimaryInterface().getIpAddress(), sysObjectId == null ? "-1" : sysObjectId);
        }
        return null;
    }

    @Override
    public void updateDeletedNodes() throws SQLException {
        this.m_atInterfaceDao.markDeletedIfNodeDeleted();
        this.m_atInterfaceDao.flush();
        this.m_vlanDao.markDeletedIfNodeDeleted();
        this.m_vlanDao.flush();
        this.m_stpNodeDao.markDeletedIfNodeDeleted();
        this.m_stpNodeDao.flush();
        this.m_stpInterfaceDao.markDeletedIfNodeDeleted();
        this.m_stpInterfaceDao.flush();
        this.m_ipRouteInterfaceDao.markDeletedIfNodeDeleted();
        this.m_ipRouteInterfaceDao.flush();
        this.m_dataLinkInterfaceDao.markDeletedIfNodeDeleted();
        this.m_dataLinkInterfaceDao.flush();
    }

    @Override
    protected void markOldDataInactive(Connection dbConn, Timestamp scanTime, int nodeid) throws SQLException {
        this.m_atInterfaceDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_atInterfaceDao.flush();
        this.m_vlanDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_vlanDao.flush();
        this.m_ipRouteInterfaceDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_ipRouteInterfaceDao.flush();
        this.m_stpNodeDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_stpNodeDao.flush();
        this.m_stpInterfaceDao.deactivateForNodeIdIfOlderThan(nodeid, scanTime);
        this.m_stpInterfaceDao.flush();
    }

    @Override
    public LinkableNode storeSnmpCollection(LinkableNode node, SnmpCollection snmpColl) throws SQLException {
        Timestamp scanTime = new Timestamp(System.currentTimeMillis());
        if (snmpColl.hasIpNetToMediaTable()) {
            this.processIpNetToMediaTable(node, snmpColl, null, scanTime);
        } else {
            LogUtils.debugf((Object)this, (String)"storeSnmpCollection: hasIpNetToMediaTable = false", (Object[])new Object[0]);
        }
        if (snmpColl.hasCdpCacheTable()) {
            this.processCdpCacheTable(node, snmpColl, null, scanTime);
        } else {
            LogUtils.debugf((Object)this, (String)"storeSnmpCollection: hasCdpCacheTable = false", (Object[])new Object[0]);
        }
        if (snmpColl.hasRouteTable()) {
            this.processRouteTable(node, snmpColl, null, scanTime);
        } else {
            LogUtils.debugf((Object)this, (String)"storeSnmpCollection: hasRouteTable = false", (Object[])new Object[0]);
        }
        if (snmpColl.hasVlanTable()) {
            this.processVlanTable(node, snmpColl, null, scanTime);
        } else {
            LogUtils.debugf((Object)this, (String)"storeSnmpCollection: hasVlanTable = false", (Object[])new Object[0]);
        }
        for (OnmsVlan vlan : snmpColl.getSnmpVlanCollections().keySet()) {
            LogUtils.debugf((Object)this, (String)"storeSnmpCollection: parsing VLAN %s/%s", (Object[])new Object[]{vlan.getVlanId(), vlan.getVlanName()});
            SnmpVlanCollection snmpVlanColl = snmpColl.getSnmpVlanCollections().get(vlan);
            if (!snmpVlanColl.hasDot1dBase()) continue;
            this.processDot1DBase(node, snmpColl, null, null, scanTime, vlan, snmpVlanColl);
        }
        this.markOldDataInactive(null, scanTime, node.getNodeId());
        return node;
    }

    @Override
    public void storeDiscoveryLink(DiscoveryLink discoveryLink) throws SQLException {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        for (NodeToNodeLink lk : discoveryLink.getLinks()) {
            DataLinkInterface iface = this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(lk.getNodeId()), Integer.valueOf(lk.getIfindex()));
            if (iface == null) {
                OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(lk.getNodeId()));
                iface = new DataLinkInterface(onmsNode, lk.getIfindex(), lk.getNodeparentid(), lk.getParentifindex(), String.valueOf('A'), (Date)now);
            }
            iface.setNodeParentId(lk.getNodeparentid());
            iface.setParentIfIndex(lk.getParentifindex());
            iface.setStatus(String.valueOf('A'));
            iface.setLastPollTime((Date)now);
            this.m_dataLinkInterfaceDao.saveOrUpdate((Object)iface);
            DataLinkInterface parent = this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(lk.getNodeparentid()), Integer.valueOf(lk.getParentifindex()));
            if (parent == null || parent.getNodeParentId().intValue() != lk.getNodeId() || parent.getParentIfIndex().intValue() != lk.getIfindex() || !parent.getStatus().equals(String.valueOf('D'))) continue;
            parent.setStatus(String.valueOf('D'));
            this.m_dataLinkInterfaceDao.saveOrUpdate((Object)parent);
        }
        for (MacToNodeLink lkm : discoveryLink.getMacLinks()) {
            OnmsAtInterface atInterface;
            Collection atInterfaces = this.m_atInterfaceDao.findByMacAddress(lkm.getMacAddress());
            if (atInterfaces.size() == 0) {
                LogUtils.debugf((Object)this, (String)"storeDiscoveryLink: No nodeid found on DB for mac address %s on link. Skipping.", (Object[])new Object[]{lkm.getMacAddress()});
                continue;
            }
            if (atInterfaces.size() > 1) {
                LogUtils.debugf((Object)this, (String)"storeDiscoveryLink: More than one atInterface returned for the mac address %s. Returning the first.", (Object[])new Object[]{lkm.getMacAddress()});
            }
            if (!this.m_linkd.isInterfaceInPackage((atInterface = (OnmsAtInterface)atInterfaces.iterator().next()).getIpAddress(), discoveryLink.getPackageName())) {
                LogUtils.debugf((Object)this, (String)"storeDiscoveryLink: IP address %s not found on link.  Skipping.", (Object[])new Object[]{atInterface.getIpAddress()});
                continue;
            }
            OnmsNode atInterfaceNode = atInterface.getNode();
            DataLinkInterface dli = this.m_dataLinkInterfaceDao.findByNodeIdAndIfIndex(atInterfaceNode.getId(), atInterface.getIfIndex());
            if (dli == null) {
                dli = new DataLinkInterface(atInterfaceNode, atInterface.getIfIndex().intValue(), lkm.getNodeparentid(), lkm.getParentifindex(), String.valueOf('A'), (Date)now);
            }
            dli.setNodeParentId(lkm.getNodeparentid());
            dli.setParentIfIndex(lkm.getParentifindex());
            dli.setStatus(String.valueOf('A'));
            dli.setLastPollTime((Date)now);
            this.m_dataLinkInterfaceDao.saveOrUpdate((Object)dli);
            LogUtils.debugf((Object)this, (String)"storeDiscoveryLink: Storing %s", (Object[])new Object[]{dli});
            this.m_dataLinkInterfaceDao.deactivateIfOlderThan(now);
        }
    }

    @Override
    public void update(int nodeid, char action) throws SQLException {
        this.m_vlanDao.setStatusForNode(Integer.valueOf(nodeid), Character.valueOf(action));
        this.m_atInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), Character.valueOf(action));
        this.m_ipRouteInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), Character.valueOf(action));
        this.m_stpNodeDao.setStatusForNode(Integer.valueOf(nodeid), Character.valueOf(action));
        this.m_stpInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), Character.valueOf(action));
        this.m_dataLinkInterfaceDao.setStatusForNode(Integer.valueOf(nodeid), Character.valueOf(action));
    }

    @Override
    public void updateForInterface(int nodeid, String ipAddr, int ifIndex, char action) throws SQLException {
        if (!EventUtils.isNonIpInterface(ipAddr)) {
            this.m_atInterfaceDao.setStatusForNodeAndIp(Integer.valueOf(nodeid), ipAddr, Character.valueOf(action));
        }
        if (ifIndex > -1) {
            this.m_atInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), Character.valueOf(action));
            this.m_stpInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), Character.valueOf(action));
            this.m_ipRouteInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), Character.valueOf(action));
            this.m_dataLinkInterfaceDao.setStatusForNodeAndIfIndex(Integer.valueOf(nodeid), Integer.valueOf(ifIndex), Character.valueOf(action));
        }
    }

    @Override
    protected int getIfIndexByName(Connection dbConn, int targetCdpNodeId, String cdpTargetDevicePort) throws SQLException {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)targetCdpNodeId));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"ifName", (Object)cdpTargetDevicePort), (Criterion)Restrictions.eq((String)"ifDescr", (Object)cdpTargetDevicePort)));
        List interfaces = this.m_snmpInterfaceDao.findMatching(criteria);
        if (interfaces.isEmpty()) {
            return -1;
        }
        if (interfaces.size() > 1) {
            LogUtils.debugf((Object)this, (String)"getIfIndexByName: More than one SnmpInterface matches nodeId %d and snmpIfName/snmpIfDescr %s", (Object[])new Object[]{targetCdpNodeId, cdpTargetDevicePort});
        }
        return ((OnmsSnmpInterface)interfaces.get(0)).getIfIndex();
    }

    @Override
    protected int getNodeidFromIp(Connection dbConn, InetAddress cdpTargetIpAddr) throws SQLException {
        OnmsNode node;
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)cdpTargetIpAddr));
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"A"));
        List interfaces = this.m_ipInterfaceDao.findMatching(criteria);
        if (interfaces.isEmpty()) {
            return -1;
        }
        if (interfaces.size() > 1) {
            LogUtils.debugf((Object)this, (String)"getNodeidFromIp: More than one node matches ipAddress %s", (Object[])new Object[]{InetAddressUtils.str((InetAddress)cdpTargetIpAddr)});
        }
        if ((node = ((OnmsIpInterface)interfaces.get(0)).getNode()) == null) {
            return -1;
        }
        return node.getId();
    }

    @Override
    protected RouterInterface getNodeidMaskFromIp(Connection dbConn, InetAddress nexthop) throws SQLException {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.createAlias("snmpInterface", "snmpInterface", 1);
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)nexthop));
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"A"));
        List interfaces = this.m_ipInterfaceDao.findMatching(criteria);
        if (interfaces.isEmpty()) {
            return null;
        }
        if (interfaces.size() > 1) {
            LogUtils.debugf((Object)this, (String)"getNodeidMaskFromIp: More than one IP Interface matches ipAddress %s", (Object[])new Object[]{InetAddressUtils.str((InetAddress)nexthop)});
        }
        OnmsIpInterface ipInterface = (OnmsIpInterface)interfaces.get(0);
        OnmsNode node = ipInterface.getNode();
        OnmsSnmpInterface snmpInterface = ipInterface.getSnmpInterface();
        if (node == null) {
            LogUtils.warnf((Object)this, (String)"getNodeidMaskFromIp: No node associated with OnmsIpInterface: %s", (Object[])new Object[]{ipInterface});
            return null;
        }
        if (snmpInterface == null) {
            LogUtils.warnf((Object)this, (String)"getNodeidMaskFromIp: No SNMP interface associated with OnmsIpInterface: %s", (Object[])new Object[]{ipInterface});
            return null;
        }
        return new RouterInterface(node.getId(), snmpInterface.getIfIndex(), snmpInterface.getNetMask());
    }

    @Override
    protected RouterInterface getNodeFromIp(Connection dbConn, InetAddress nexthop) throws SQLException {
        OnmsIpInterface ipInterface;
        OnmsNode node;
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)nexthop));
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"A"));
        List interfaces = this.m_ipInterfaceDao.findMatching(criteria);
        if (interfaces.isEmpty()) {
            return null;
        }
        if (interfaces.size() > 1) {
            LogUtils.debugf((Object)this, (String)"getNodeFromIp: More than one IP Interface matches ipAddress %s", (Object[])new Object[]{InetAddressUtils.str((InetAddress)nexthop)});
        }
        if ((node = (ipInterface = (OnmsIpInterface)interfaces.get(0)).getNode()) == null) {
            LogUtils.warnf((Object)this, (String)"getNodeFromIp: No node associated with OnmsIpInterface: %s", (Object[])new Object[]{ipInterface});
            return null;
        }
        int ifIndex = -1;
        return new RouterInterface(node.getId(), ifIndex);
    }

    @Override
    protected int getSnmpIfType(Connection dbConn, int nodeId, Integer ifIndex) throws SQLException {
        LogUtils.debugf((Object)this, (String)"getSnmpIfType(%d, %s)", (Object[])new Object[]{nodeId, ifIndex});
        OnmsSnmpInterface snmpInterface = this.m_snmpInterfaceDao.findByNodeIdAndIfIndex(Integer.valueOf(nodeId), ifIndex);
        if (snmpInterface == null) {
            return -1;
        }
        return snmpInterface.getIfType();
    }

    @Override
    protected List<String> getPhysAddrs(int nodeId, DBUtils d, Connection dbConn) throws SQLException {
        OnmsCriteria criteria = new OnmsCriteria(OnmsSnmpInterface.class);
        criteria.createAlias("node", "node");
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        ArrayList<String> addrs = new ArrayList<String>();
        for (OnmsSnmpInterface snmpInterface : this.m_snmpInterfaceDao.findMatching(criteria)) {
            addrs.add(snmpInterface.getPhysAddr());
        }
        return addrs;
    }

    @Override
    protected synchronized void saveIpRouteInterface(Connection dbConn, final OnmsIpRouteInterface saveMe) throws SQLException {
        new UpsertTemplate<OnmsIpRouteInterface, IpRouteInterfaceDao>(this.m_transactionManager, this.m_ipRouteInterfaceDao){

            protected OnmsIpRouteInterface query() {
                return ((IpRouteInterfaceDao)this.m_dao).findByNodeAndDest(saveMe.getNode().getId(), saveMe.getRouteDest());
            }

            protected OnmsIpRouteInterface doUpdate(OnmsIpRouteInterface updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getRouteDest().equals(saveMe.getRouteDest()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setRouteIfIndex(saveMe.getRouteIfIndex());
                updateMe.setRouteMask(saveMe.getRouteMask());
                updateMe.setRouteMetric1(saveMe.getRouteMetric1());
                updateMe.setRouteMetric2(saveMe.getRouteMetric2());
                updateMe.setRouteMetric3(saveMe.getRouteMetric3());
                updateMe.setRouteMetric4(saveMe.getRouteMetric4());
                updateMe.setRouteMetric5(saveMe.getRouteMetric5());
                updateMe.setRouteNextHop(saveMe.getRouteNextHop());
                updateMe.setRouteProto(saveMe.getRouteProto());
                updateMe.setRouteType(saveMe.getRouteType());
                updateMe.setStatus(saveMe.getStatus());
                ((IpRouteInterfaceDao)this.m_dao).update((Object)updateMe);
                ((IpRouteInterfaceDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsIpRouteInterface doInsert() {
                ((IpRouteInterfaceDao)this.m_dao).save((Object)saveMe);
                ((IpRouteInterfaceDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    protected void saveVlan(Connection dbConn, final OnmsVlan saveMe) throws SQLException {
        new UpsertTemplate<OnmsVlan, VlanDao>(this.m_transactionManager, this.m_vlanDao){

            protected OnmsVlan query() {
                return ((VlanDao)this.m_dao).findByNodeAndVlan(saveMe.getNode().getId(), saveMe.getVlanId());
            }

            protected OnmsVlan doUpdate(OnmsVlan updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getVlanId().equals(saveMe.getVlanId()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                updateMe.setVlanName(saveMe.getVlanName());
                updateMe.setVlanStatus(saveMe.getVlanStatus());
                updateMe.setVlanType(saveMe.getVlanType());
                ((VlanDao)this.m_dao).update((Object)updateMe);
                ((VlanDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsVlan doInsert() {
                ((VlanDao)this.m_dao).save((Object)saveMe);
                ((VlanDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    protected synchronized void saveStpNode(Connection dbConn, final OnmsStpNode saveMe) throws SQLException {
        new UpsertTemplate<OnmsStpNode, StpNodeDao>(this.m_transactionManager, this.m_stpNodeDao){

            protected OnmsStpNode query() {
                return ((StpNodeDao)this.m_dao).findByNodeAndVlan(saveMe.getNode().getId(), saveMe.getBaseVlan());
            }

            protected OnmsStpNode doUpdate(OnmsStpNode updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getBaseVlan().equals(saveMe.getBaseVlan()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setBaseBridgeAddress(saveMe.getBaseBridgeAddress());
                updateMe.setBaseNumPorts(saveMe.getBaseNumPorts());
                updateMe.setBaseType(saveMe.getBaseType());
                updateMe.setBaseVlanName(saveMe.getBaseVlanName());
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                updateMe.setStpDesignatedRoot(saveMe.getStpDesignatedRoot());
                updateMe.setStpPriority(saveMe.getStpPriority());
                updateMe.setStpProtocolSpecification(saveMe.getStpProtocolSpecification());
                updateMe.setStpRootCost(saveMe.getStpRootCost());
                updateMe.setStpRootPort(saveMe.getStpRootPort());
                ((StpNodeDao)this.m_dao).update((Object)updateMe);
                ((StpNodeDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsStpNode doInsert() {
                ((StpNodeDao)this.m_dao).save((Object)saveMe);
                ((StpNodeDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    protected void saveStpInterface(Connection dbConn, final OnmsStpInterface saveMe) throws SQLException {
        new UpsertTemplate<OnmsStpInterface, StpInterfaceDao>(this.m_transactionManager, this.m_stpInterfaceDao){

            protected OnmsStpInterface query() {
                return ((StpInterfaceDao)this.m_dao).findByNodeAndVlan(saveMe.getNode().getId(), saveMe.getBridgePort(), saveMe.getVlan());
            }

            protected OnmsStpInterface doUpdate(OnmsStpInterface updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getBridgePort().equals(saveMe.getBridgePort()));
                Assert.isTrue((boolean)updateMe.getVlan().equals(saveMe.getVlan()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setIfIndex(saveMe.getIfIndex());
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setStatus(saveMe.getStatus());
                updateMe.setStpPortDesignatedBridge(saveMe.getStpPortDesignatedBridge());
                updateMe.setStpPortDesignatedCost(saveMe.getStpPortDesignatedCost());
                updateMe.setStpPortDesignatedPort(saveMe.getStpPortDesignatedPort());
                updateMe.setStpPortDesignatedRoot(saveMe.getStpPortDesignatedRoot());
                updateMe.setStpPortPathCost(saveMe.getStpPortPathCost());
                updateMe.setStpPortState(saveMe.getStpPortState());
                ((StpInterfaceDao)this.m_dao).update((Object)updateMe);
                ((StpInterfaceDao)this.m_dao).flush();
                return updateMe;
            }

            protected OnmsStpInterface doInsert() {
                ((StpInterfaceDao)this.m_dao).save((Object)saveMe);
                ((StpInterfaceDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_atInterfaceDao);
        Assert.notNull((Object)this.m_dataLinkInterfaceDao);
        Assert.notNull((Object)this.m_ipInterfaceDao);
        Assert.notNull((Object)this.m_ipRouteInterfaceDao);
        Assert.notNull((Object)this.m_nodeDao);
        Assert.notNull((Object)this.m_snmpInterfaceDao);
        Assert.notNull((Object)this.m_stpInterfaceDao);
        Assert.notNull((Object)this.m_stpNodeDao);
        Assert.notNull((Object)this.m_transactionManager);
        Assert.notNull((Object)this.m_vlanDao);
        LogUtils.debugf((Object)this, (String)"Initialized %s", (Object[])new Object[]{this.getClass().getSimpleName()});
    }

    @Override
    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    @Override
    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.m_ipInterfaceDao = ipInterfaceDao;
    }

    public SnmpInterfaceDao getSnmpInterfaceDao() {
        return this.m_snmpInterfaceDao;
    }

    public void setSnmpInterfaceDao(SnmpInterfaceDao snmpInterfaceDao) {
        this.m_snmpInterfaceDao = snmpInterfaceDao;
    }

    @Override
    public AtInterfaceDao getAtInterfaceDao() {
        return this.m_atInterfaceDao;
    }

    public void setAtInterfaceDao(AtInterfaceDao atInterfaceDao) {
        this.m_atInterfaceDao = atInterfaceDao;
    }

    public VlanDao getVlanDao() {
        return this.m_vlanDao;
    }

    public void setVlanDao(VlanDao vlanDao) {
        this.m_vlanDao = vlanDao;
    }

    public StpNodeDao getStpNodeDao() {
        return this.m_stpNodeDao;
    }

    public void setStpNodeDao(StpNodeDao stpNodeDao) {
        this.m_stpNodeDao = stpNodeDao;
    }

    public StpInterfaceDao getStpInterfaceDao() {
        return this.m_stpInterfaceDao;
    }

    public void setStpInterfaceDao(StpInterfaceDao stpInterfaceDao) {
        this.m_stpInterfaceDao = stpInterfaceDao;
    }

    public IpRouteInterfaceDao getIpRouteInterfaceDao() {
        return this.m_ipRouteInterfaceDao;
    }

    public void setIpRouteInterfaceDao(IpRouteInterfaceDao ipRouteInterfaceDao) {
        this.m_ipRouteInterfaceDao = ipRouteInterfaceDao;
    }

    public DataLinkInterfaceDao getDataLinkInterfaceDao() {
        return this.m_dataLinkInterfaceDao;
    }

    public void setDataLinkInterfaceDao(DataLinkInterfaceDao dataLinkInterfaceDao) {
        this.m_dataLinkInterfaceDao = dataLinkInterfaceDao;
    }
}

