/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.tcp;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;

final class TcpRecordHandler
implements Runnable {
    private volatile boolean m_stop = false;
    private Thread m_context = null;
    private List<Object> m_xchange;
    private Socket m_connection;
    private OutputStream m_out;
    private StateManager[] m_tokenizer;

    private void closeStream() throws IOException {
        if (this.m_out != null) {
            this.m_out.close();
        }
        this.m_out = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newStream() throws IOException {
        LogUtils.debugf((Object)this, (String)"Opening new PipedOutputStream and adding it to the queue", (Object[])new Object[0]);
        PipedOutputStream pipeOut = new PipedOutputStream();
        try {
            PipedOutputStream pipedOutputStream = pipeOut;
            synchronized (pipedOutputStream) {
                List<Object> list = this.m_xchange;
                synchronized (list) {
                    this.m_xchange.add(pipeOut);
                    this.m_xchange.notify();
                }
                LogUtils.debugf((Object)this, (String)"Added pipe to the xchange list", (Object[])new Object[0]);
                pipeOut.wait();
                LogUtils.debugf((Object)this, (String)"Pipe Signaled", (Object[])new Object[0]);
            }
        }
        catch (InterruptedException e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"An I/O error occured.", (Object[])new Object[0]);
            Thread.currentThread().interrupt();
            throw new IOException("The thread was interrupted");
        }
        LogUtils.debugf((Object)this, (String)"PipedOutputStream connected", (Object[])new Object[0]);
        this.m_out = pipeOut;
    }

    private void forward(char ch) throws IOException {
        try {
            if (this.m_out != null) {
                this.m_out.write(ch);
            }
        }
        catch (IOException e) {
            LogUtils.debugf((Object)this, (Throwable)e, (String)"An I/O error occured.", (Object[])new Object[0]);
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    TcpRecordHandler(Socket s, List<Object> xchange) {
        this.m_xchange = xchange;
        this.m_connection = s;
        this.m_tokenizer = new StateManager[]{new StateManager(0, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == '<') {
                    return 1;
                }
                return this.m_level;
            }
        }, new StateManager(1, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == '/') {
                    return 2;
                }
                return 0;
            }
        }, new StateManager(2, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'l') {
                    return 5;
                }
                if (Character.isLetterOrDigit(ch)) {
                    return 3;
                }
                return 0;
            }
        }, new StateManager(3, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == ':') {
                    return 4;
                }
                if (Character.isLetterOrDigit(ch)) {
                    return this.m_level;
                }
                return 0;
            }
        }, new StateManager(4, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'l') {
                    return 5;
                }
                return 0;
            }
        }, new StateManager(5, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'o') {
                    return 6;
                }
                return 0;
            }
        }, new StateManager(6, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == 'g') {
                    return 7;
                }
                return 0;
            }
        }, new StateManager(7, this){

            @Override
            int next(char ch) throws IOException {
                this.onTransition(ch);
                if (ch == '>') {
                    this.m_handler.closeStream();
                    return 8;
                }
                return 0;
            }
        }, new StateManager(8, this){

            @Override
            int next(char ch) throws IOException {
                if (ch == '<') {
                    this.onTransition(ch);
                    return 1;
                }
                return this.m_level;
            }

            @Override
            void onTransition(char ch) throws IOException {
                this.m_handler.newStream();
                super.onTransition(ch);
            }
        }};
    }

    boolean isAlive() {
        if (this.m_context != null) {
            return this.m_context.isAlive();
        }
        return false;
    }

    void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_context != null) {
            LogUtils.debugf((Object)this, (String)"Interrupting thread %s", (Object[])new Object[]{this.m_context.getName()});
            this.m_context.interrupt();
            LogUtils.debugf((Object)this, (String)"Joining Thread %s", (Object[])new Object[]{this.m_context.getName()});
            this.m_context.join();
            LogUtils.debugf((Object)this, (String)"Thread %s Joined", (Object[])new Object[]{this.m_context.getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            Thread thread = this.m_context = Thread.currentThread();
            synchronized (thread) {
                this.m_context.notifyAll();
            }
            if (this.m_stop) {
                LogUtils.debugf((Object)this, (String)"Stop flag set before thread startup, thread exiting", (Object[])new Object[0]);
                return;
            }
            LogUtils.debugf((Object)this, (String)"Thread started, remote is %s", (Object[])new Object[]{InetAddressUtils.str((InetAddress)this.m_connection.getInetAddress())});
            BufferedInputStream socketIn = null;
            try {
                this.m_connection.setSoTimeout(500);
                socketIn = new BufferedInputStream(this.m_connection.getInputStream());
            }
            catch (IOException e) {
                if (!this.m_stop) {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"An I/O Exception occured.", (Object[])new Object[0]);
                }
                this.m_xchange.add(e);
                LogUtils.debugf((Object)this, (String)"Thread exiting due to socket exception, stop flag = %s", (Object[])new Object[]{this.m_stop});
                return;
            }
            int level = 8;
            int ch = 0;
            boolean moreInput = true;
            while (moreInput) {
                block23: {
                    if (Thread.interrupted()) {
                        LogUtils.debugf((Object)this, (String)"Thread Interrupted", (Object[])new Object[0]);
                        Thread.currentThread().interrupt();
                        break;
                    }
                    try {
                        ch = ((InputStream)socketIn).read();
                        if (ch == -1) {
                            moreInput = false;
                        }
                        break block23;
                    }
                    catch (InterruptedIOException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (EOFException e) {
                        this.m_xchange.add(e);
                        moreInput = false;
                    }
                    catch (IOException e) {
                        this.m_xchange.add(e);
                        if (!this.m_stop) {
                            LogUtils.warnf((Object)this, (Throwable)e, (String)"An I/O error occured reading from the remote host.", (Object[])new Object[0]);
                        }
                        moreInput = false;
                    }
                    continue;
                }
                try {
                    level = this.m_tokenizer[level].next((char)ch);
                }
                catch (IOException e) {
                    if (!this.m_stop) {
                        LogUtils.warnf((Object)this, (Throwable)e, (String)"An I/O error occured writing to the processor stream.", (Object[])new Object[0]);
                        LogUtils.warnf((Object)this, (String)"Discarding the remainder of the event contents", (Object[])new Object[0]);
                        try {
                            this.closeStream();
                        }
                        catch (IOException e2) {}
                        continue;
                    }
                    this.m_xchange.add(e);
                    moreInput = false;
                }
            }
            try {
                if (this.m_out != null) {
                    this.m_out.close();
                }
            }
            catch (IOException e) {
                if (this.m_stop) break block24;
                LogUtils.warnf((Object)this, (Throwable)e, (String)"An I/O Error occured closing the processor stream.", (Object[])new Object[0]);
            }
        }
        this.m_xchange.add(new EOFException("No More Input"));
        LogUtils.debugf((Object)this, (String)"Thread Terminated", (Object[])new Object[0]);
    }

    private static class StateManager {
        protected int m_level;
        protected TcpRecordHandler m_handler;

        StateManager(int level, TcpRecordHandler handler) {
            this.m_level = level;
            this.m_handler = handler;
        }

        int getLevel() {
            return this.m_level;
        }

        int next(char ch) throws IOException {
            this.onTransition(ch);
            return this.m_level;
        }

        void onTransition(char ch) throws IOException {
            this.m_handler.forward(ch);
        }
    }
}

