/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.IPLike;
import org.opennms.core.utils.InetAddressComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.wmi.Definition;
import org.opennms.netmgt.config.wmi.Range;
import org.opennms.netmgt.config.wmi.WmiConfig;
import org.opennms.protocols.wmi.WmiAgentConfig;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class WmiPeerFactory {
    private static WmiPeerFactory m_singleton = null;
    private static WmiConfig m_config;
    private static boolean m_loaded;

    private WmiPeerFactory(String configFile) throws IOException, MarshalException, ValidationException {
        m_config = (WmiConfig)CastorUtils.unmarshal(WmiConfig.class, (Resource)new FileSystemResource(configFile));
    }

    public WmiPeerFactory(InputStream stream) throws MarshalException, ValidationException {
        m_config = (WmiConfig)CastorUtils.unmarshal(WmiConfig.class, (InputStream)stream);
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.WMI_CONFIG_FILE_NAME);
        WmiPeerFactory.log().debug("init: config file path: " + cfgFile.getPath());
        m_singleton = new WmiPeerFactory(cfgFile.getPath());
        m_loaded = true;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(WmiPeerFactory.class);
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        WmiPeerFactory.init();
    }

    WmiConfig getConfig() {
        return m_config;
    }

    public static synchronized void saveCurrent() throws Exception {
        WmiPeerFactory.optimize();
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)m_config, (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.WMI_CONFIG_FILE_NAME)), "UTF-8");
            fileWriter.write(stringWriter.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        WmiPeerFactory.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void optimize() throws UnknownHostException {
        Definition definition3;
        ThreadCategory log = WmiPeerFactory.log();
        Iterator definitionsIterator = m_config.getDefinitionCollection().iterator();
        while (definitionsIterator.hasNext()) {
            definition3 = (Definition)definitionsIterator.next();
            if (definition3.getSpecificCount() != 0 || definition3.getRangeCount() != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug("optimize: Removing empty definition element");
            }
            definitionsIterator.remove();
        }
        Iterator i$ = m_config.getDefinitionCollection().iterator();
        while (i$.hasNext()) {
            Definition definition2 = definition3 = (Definition)i$.next();
            synchronized (definition2) {
                Iterator rangesIterator = definition3.getRangeCollection().iterator();
                while (rangesIterator.hasNext()) {
                    Range range = (Range)rangesIterator.next();
                    if (!range.getBegin().equals(range.getEnd())) continue;
                    definition3.addSpecific(range.getBegin());
                    rangesIterator.remove();
                }
            }
        }
        for (Definition definition3 : m_config.getDefinitionCollection()) {
            TreeMap<InetAddress, String> specificsMap = new TreeMap<InetAddress, String>((Comparator<InetAddress>)new InetAddressComparator());
            for (String specific : definition3.getSpecificCollection()) {
                specificsMap.put(InetAddressUtils.getInetAddress((String)specific), specific.trim());
            }
            TreeMap<InetAddress, Range> rangesMap = new TreeMap<InetAddress, Range>((Comparator<InetAddress>)new InetAddressComparator());
            for (Range range : definition3.getRangeCollection()) {
                rangesMap.put(InetAddressUtils.getInetAddress((String)range.getBegin()), range);
            }
            InetAddress priorSpecific = null;
            Range addedRange = null;
            for (InetAddress specific : specificsMap.keySet()) {
                if (priorSpecific == null) {
                    priorSpecific = specific;
                    continue;
                }
                if (BigInteger.ONE.equals(InetAddressUtils.difference((InetAddress)specific, (InetAddress)priorSpecific)) && InetAddressUtils.inSameScope((InetAddress)specific, (InetAddress)priorSpecific)) {
                    if (addedRange == null) {
                        addedRange = new Range();
                        addedRange.setBegin(InetAddressUtils.toIpAddrString((InetAddress)priorSpecific));
                        rangesMap.put(priorSpecific, addedRange);
                        specificsMap.remove(priorSpecific);
                    }
                    addedRange.setEnd(InetAddressUtils.toIpAddrString((InetAddress)specific));
                    specificsMap.remove(specific);
                } else {
                    addedRange = null;
                }
                priorSpecific = specific;
            }
            block10: for (InetAddress specific : new ArrayList(specificsMap.keySet())) {
                for (InetAddress begin : new ArrayList(rangesMap.keySet())) {
                    Range range;
                    InetAddress end;
                    if (!InetAddressUtils.inSameScope((InetAddress)begin, (InetAddress)specific) || InetAddressUtils.toInteger((InetAddress)begin).subtract(BigInteger.ONE).compareTo(InetAddressUtils.toInteger((InetAddress)specific)) > 0 || InetAddressUtils.toInteger((InetAddress)(end = InetAddressUtils.getInetAddress((String)(range = (Range)rangesMap.get(begin)).getEnd()))).add(BigInteger.ONE).compareTo(InetAddressUtils.toInteger((InetAddress)specific)) < 0) continue;
                    if (InetAddressUtils.toInteger((InetAddress)specific).compareTo(InetAddressUtils.toInteger((InetAddress)begin)) >= 0 && InetAddressUtils.toInteger((InetAddress)specific).compareTo(InetAddressUtils.toInteger((InetAddress)end)) <= 0) {
                        specificsMap.remove(specific);
                        continue block10;
                    }
                    if (InetAddressUtils.toInteger((InetAddress)begin).subtract(BigInteger.ONE).equals(InetAddressUtils.toInteger((InetAddress)specific))) {
                        rangesMap.remove(begin);
                        rangesMap.put(specific, range);
                        range.setBegin(InetAddressUtils.toIpAddrString((InetAddress)specific));
                        specificsMap.remove(specific);
                        continue block10;
                    }
                    if (!InetAddressUtils.toInteger((InetAddress)end).add(BigInteger.ONE).equals(InetAddressUtils.toInteger((InetAddress)specific))) continue;
                    range.setEnd(InetAddressUtils.toIpAddrString((InetAddress)specific));
                    specificsMap.remove(specific);
                    continue block10;
                }
            }
            Range priorRange = null;
            InetAddress priorBegin = null;
            InetAddress priorEnd = null;
            Iterator rangesIterator = rangesMap.keySet().iterator();
            while (rangesIterator.hasNext()) {
                InetAddress beginAddress = (InetAddress)rangesIterator.next();
                Range range = (Range)rangesMap.get(beginAddress);
                InetAddress endAddress = InetAddressUtils.getInetAddress((String)range.getEnd());
                if (priorRange != null && InetAddressUtils.inSameScope((InetAddress)beginAddress, priorEnd) && InetAddressUtils.difference((InetAddress)beginAddress, (InetAddress)priorEnd).compareTo(BigInteger.ONE) <= 0) {
                    priorBegin = new InetAddressComparator().compare(priorBegin, beginAddress) < 0 ? priorBegin : beginAddress;
                    priorRange.setBegin(InetAddressUtils.toIpAddrString((InetAddress)priorBegin));
                    priorEnd = new InetAddressComparator().compare(priorEnd, endAddress) > 0 ? priorEnd : endAddress;
                    priorRange.setEnd(InetAddressUtils.toIpAddrString((InetAddress)priorEnd));
                    rangesIterator.remove();
                    continue;
                }
                priorRange = range;
                priorBegin = beginAddress;
                priorEnd = endAddress;
            }
            definition3.setSpecific(specificsMap.values().toArray(new String[0]));
            definition3.setRange(rangesMap.values().toArray(new Range[0]));
        }
    }

    public static synchronized WmiPeerFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The WmiPeerFactory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(WmiPeerFactory singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public synchronized WmiAgentConfig getAgentConfig(InetAddress agentInetAddress) {
        Definition def;
        if (m_config == null) {
            return new WmiAgentConfig(agentInetAddress);
        }
        WmiAgentConfig agentConfig = new WmiAgentConfig(agentInetAddress);
        this.setWmiAgentConfig(agentConfig, new Definition());
        Enumeration edef = m_config.enumerateDefinition();
        block0: while (edef.hasMoreElements()) {
            def = (Definition)edef.nextElement();
            for (String saddr : def.getSpecificCollection()) {
                InetAddress addr = InetAddressUtils.addr((String)saddr);
                if (!addr.equals(agentConfig.getAddress())) continue;
                this.setWmiAgentConfig(agentConfig, def);
                break block0;
            }
            for (Range rng : def.getRangeCollection()) {
                if (!InetAddressUtils.isInetAddressInRange((String)InetAddressUtils.str((InetAddress)agentConfig.getAddress()), (String)rng.getBegin(), (String)rng.getEnd())) continue;
                this.setWmiAgentConfig(agentConfig, def);
                break block0;
            }
            for (String ipMatch : def.getIpMatchCollection()) {
                if (!IPLike.matches((String)InetAddressUtils.str((InetAddress)agentInetAddress), (String)ipMatch)) continue;
                this.setWmiAgentConfig(agentConfig, def);
                break block0;
            }
        }
        if (agentConfig == null) {
            def = new Definition();
            this.setWmiAgentConfig(agentConfig, def);
        }
        return agentConfig;
    }

    private void setWmiAgentConfig(WmiAgentConfig agentConfig, Definition def) {
        this.setCommonAttributes(agentConfig, def);
        agentConfig.setPassword(this.determinePassword(def));
    }

    private void setCommonAttributes(WmiAgentConfig agentConfig, Definition def) {
        agentConfig.setRetries(this.determineRetries(def));
        agentConfig.setTimeout((int)this.determineTimeout(def));
        agentConfig.setUsername(this.determineUsername(def));
        agentConfig.setPassword(this.determinePassword(def));
        agentConfig.setDomain(this.determineDomain(def));
    }

    private String determineUsername(Definition def) {
        return def.getPassword() == null ? (m_config.getUsername() == null ? "Administrator" : m_config.getUsername()) : def.getUsername();
    }

    private String determineDomain(Definition def) {
        return def.getDomain() == null ? (m_config.getDomain() == null ? "WORKGROUP" : m_config.getDomain()) : def.getDomain();
    }

    private String determinePassword(Definition def) {
        return def.getPassword() == null ? (m_config.getPassword() == null ? "" : m_config.getPassword()) : def.getPassword();
    }

    private long determineTimeout(Definition def) {
        long timeout = 3000L;
        return def.getTimeout() == 0 ? (m_config.getTimeout() == 0 ? timeout : (long)m_config.getTimeout()) : (long)def.getTimeout();
    }

    private int determineRetries(Definition def) {
        int retries = 1;
        return def.getRetry() == 0 ? (m_config.getRetry() == 0 ? retries : m_config.getRetry()) : def.getRetry();
    }

    public static WmiConfig getWmiConfig() {
        return m_config;
    }

    public static synchronized void setWmiConfig(WmiConfig m_config) {
        WmiPeerFactory.m_config = m_config;
    }

    static {
        m_loaded = false;
    }
}

