/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.core.xml.MarshallingResourceFailureException;
import org.opennms.netmgt.config.DefaultServiceMonitorLocator;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.CriticalService;
import org.opennms.netmgt.config.poller.IncludeRange;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.CastorObjectRetrievalFailureException;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.springframework.dao.PermissionDeniedDataAccessException;

public abstract class PollerConfigManager
implements PollerConfig {
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    protected PollerConfiguration m_config;
    private Map<String, List<String>> m_urlIPMap;
    private AtomicReference<Map<Package, List<InetAddress>>> m_pkgIpMap = new AtomicReference();
    private Map<String, ServiceMonitor> m_svcMonitors = Collections.synchronizedMap(new TreeMap());
    private static boolean m_verifyServer;
    private static String m_localServer;

    public PollerConfigManager(InputStream stream, String localServer, boolean verifyServer) throws MarshalException, ValidationException {
        m_localServer = localServer;
        m_verifyServer = verifyServer;
        this.m_config = (PollerConfiguration)CastorUtils.unmarshal(PollerConfiguration.class, (InputStream)stream);
        this.setUpInternalData();
    }

    @Override
    public Lock getReadLock() {
        return this.m_readLock;
    }

    @Override
    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    protected void setUpInternalData() {
        this.createUrlIpMap();
        this.createPackageIpListMap();
        this.initializeServiceMonitors();
    }

    @Override
    public abstract void update() throws IOException, MarshalException, ValidationException;

    protected abstract void saveXml(String var1) throws IOException;

    private void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        for (Package pkg : this.packages()) {
            for (String url : this.includeURLs(pkg)) {
                List iplist = IpListFromUrl.parse((String)url);
                if (iplist.size() <= 0) continue;
                this.m_urlIPMap.put(url, iplist);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws MarshalException, IOException, ValidationException {
        this.getWriteLock().lock();
        try {
            StringWriter stringWriter = new StringWriter();
            Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
            this.saveXml(stringWriter.toString());
            this.update();
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollerConfiguration getConfiguration() {
        this.getReadLock().lock();
        try {
            PollerConfiguration pollerConfiguration = this.m_config;
            return pollerConfiguration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getPackage(String name) {
        this.getReadLock().lock();
        try {
            for (Package pkg : this.packages()) {
                if (!pkg.getName().equals(name)) continue;
                Package package_ = pkg;
                return package_;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceSelector getServiceSelectorForPackage(Package pkg) {
        this.getReadLock().lock();
        try {
            LinkedList<String> svcNames = new LinkedList<String>();
            for (Service svc : this.services(pkg)) {
                svcNames.add(svc.getName());
            }
            String filter = pkg.getFilter().getContent();
            ServiceSelector serviceSelector = new ServiceSelector(filter, svcNames);
            return serviceSelector;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPackage(Package pkg) {
        this.getWriteLock().lock();
        try {
            this.m_config.addPackage(pkg);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMonitor(String svcName, String className) {
        this.getWriteLock().lock();
        try {
            Monitor monitor = new Monitor();
            monitor.setService(svcName);
            monitor.setClassName(className);
            this.m_config.addMonitor(monitor);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldNotifyXmlrpc() {
        this.getReadLock().lock();
        try {
            boolean bl = Boolean.valueOf(this.m_config.getXmlrpc());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPathOutageEnabled() {
        this.getReadLock().lock();
        try {
            boolean bl = Boolean.valueOf(this.m_config.getPathOutageEnabled());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCriticalService() {
        this.getReadLock().lock();
        try {
            CriticalService service = this.m_config.getNodeOutage().getCriticalService();
            String string = service == null ? null : service.getName();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldPollAllIfNoCriticalServiceDefined() {
        this.getReadLock().lock();
        try {
            boolean bl = Boolean.valueOf(this.m_config.getNodeOutage().getPollAllIfNoCriticalServiceDefined());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNodeOutageProcessingEnabled() {
        this.getReadLock().lock();
        try {
            boolean bl = this.m_config.getNodeOutage().getStatus().equals("on");
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServiceUnresponsiveEnabled() {
        this.getReadLock().lock();
        try {
            boolean bl = Boolean.valueOf(this.m_config.getServiceUnresponsiveEnabled());
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPackageIpListMap() {
        this.getReadLock().lock();
        try {
            HashMap<Package, List<InetAddress>> pkgIpMap = new HashMap<Package, List<InetAddress>>();
            for (Package pkg : this.packages()) {
                try {
                    List<InetAddress> ipList = this.getIpList(pkg);
                    LogUtils.debugf((Object)this, (String)"createPackageIpMap: package %s: ipList size = %d", (Object[])new Object[]{pkg.getName(), ipList.size()});
                    if (ipList.size() <= 0) continue;
                    pkgIpMap.put(pkg, ipList);
                }
                catch (Throwable t) {
                    LogUtils.errorf((Object)this, (Throwable)t, (String)"createPackageIpMap: failed to map package: %s to an IP List with filter \"%s\"", (Object[])new Object[]{pkg.getName(), pkg.getFilter().getContent()});
                }
            }
            this.m_pkgIpMap.set(pkgIpMap);
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InetAddress> getIpList(Package pkg) {
        this.getReadLock().lock();
        try {
            StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
            if (m_verifyServer) {
                filterRules.append(" & (serverName == ");
                filterRules.append('\"');
                filterRules.append(m_localServer);
                filterRules.append('\"');
                filterRules.append(")");
            }
            LogUtils.debugf((Object)this, (String)"createPackageIpMap: package is %s. filter rules are %s", (Object[])new Object[]{pkg.getName(), filterRules.toString()});
            List list = FilterDaoFactory.getInstance().getActiveIPAddressList(filterRules.toString());
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }

    @Override
    public boolean isInterfaceInPackage(String iface, Package pkg) {
        int endComparison;
        int comparison;
        boolean filterPassed = false;
        InetAddress ifaceAddr = InetAddressUtils.addr((String)iface);
        List<InetAddress> ipList = this.m_pkgIpMap.get().get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(ifaceAddr);
        }
        LogUtils.debugf((Object)this, (String)"interfaceInPackage: Interface %s passed filter for package %s?: %s", (Object[])new Object[]{iface, pkg.getName(), filterPassed});
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
        byte[] addr = InetAddressUtils.toIpAddrBytes((String)iface);
        for (IncludeRange rng : pkg.getIncludeRangeCollection()) {
            comparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getBegin()));
            if (comparison > 0) {
                endComparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getEnd()));
                if (endComparison > 0) continue;
                has_range_include = true;
                break;
            }
            if (comparison != 0) continue;
            has_range_include = true;
            break;
        }
        for (String spec : pkg.getSpecificCollection()) {
            if (new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)spec)) != 0) continue;
            has_specific = true;
            break;
        }
        for (String includeUrl : pkg.getIncludeUrlCollection()) {
            if (!this.interfaceInUrl(iface, includeUrl)) continue;
            has_specific = true;
            break;
        }
        if (!has_specific) {
            for (IncludeRange rng : pkg.getExcludeRangeCollection()) {
                comparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getBegin()));
                if (comparison > 0) {
                    endComparison = new ByteArrayComparator().compare(addr, InetAddressUtils.toIpAddrBytes((String)rng.getEnd()));
                    if (endComparison > 0) continue;
                    has_range_exclude = true;
                    break;
                }
                if (comparison != 0) continue;
                has_range_exclude = true;
                break;
            }
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServiceInPackageAndEnabled(String svcName, Package pkg) {
        this.getReadLock().lock();
        try {
            if (pkg == null) {
                LogUtils.warnf((Object)this, (String)"serviceInPackageAndEnabled:  pkg argument is NULL!!", (Object[])new Object[0]);
                boolean bl = false;
                return bl;
            }
            LogUtils.debugf((Object)this, (String)"serviceInPackageAndEnabled: svcName=%s pkg=%s", (Object[])new Object[]{svcName, pkg.getName()});
            for (Service svc : this.services(pkg)) {
                String status;
                if (!svc.getName().equalsIgnoreCase(svcName) || (status = svc.getStatus()) != null && !status.equals("on")) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Service getServiceInPackage(String svcName, Package pkg) {
        this.getReadLock().lock();
        try {
            for (Service svc : this.services(pkg)) {
                if (!svcName.equals(svc.getName())) continue;
                Service service = svc;
                return service;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServiceMonitored(String svcName) {
        this.getReadLock().lock();
        try {
            for (Monitor monitor : this.monitors()) {
                if (!monitor.getService().equals(svcName)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getFirstPackageMatch(String ipaddr) {
        this.getReadLock().lock();
        try {
            for (Package pkg : this.packages()) {
                if (!this.isInterfaceInPackage(ipaddr, pkg)) continue;
                Package package_ = pkg;
                return package_;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Package getFirstLocalPackageMatch(String ipaddr) {
        this.getReadLock().lock();
        try {
            for (Package pkg : this.packages()) {
                if (pkg.getRemote() || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                Package package_ = pkg;
                return package_;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllPackageMatches(String ipaddr) {
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        this.getReadLock().lock();
        try {
            for (Package pkg : this.packages()) {
                if (!this.isInterfaceInPackage(ipaddr, pkg)) continue;
                matchingPkgs.add(pkg.getName());
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return matchingPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolled(String ipaddr) {
        this.getReadLock().lock();
        try {
            for (Package pkg : this.packages()) {
                if (!this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolledLocally(String ipaddr) {
        this.getReadLock().lock();
        try {
            for (Package pkg : this.packages()) {
                if (pkg.getRemote() || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    @Override
    public boolean isPolled(String svcName, Package pkg) {
        if (this.isServiceInPackageAndEnabled(svcName, pkg)) {
            return this.isServiceMonitored(svcName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolled(String ipaddr, String svcName) {
        this.getReadLock().lock();
        try {
            if (!this.isServiceMonitored(svcName)) {
                boolean bl = false;
                return bl;
            }
            for (Package pkg : this.packages()) {
                if (!this.isServiceInPackageAndEnabled(svcName, pkg) || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPolledLocally(String ipaddr, String svcName) {
        this.getReadLock().lock();
        try {
            if (!this.isServiceMonitored(svcName)) {
                boolean bl = false;
                return bl;
            }
            for (Package pkg : this.packages()) {
                if (!this.isServiceInPackageAndEnabled(svcName, pkg) || !this.isInterfaceInPackage(ipaddr, pkg)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getStep(Package pkg) {
        this.getReadLock().lock();
        try {
            int n = pkg.getRrd().getStep();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getRRAList(Package pkg) {
        this.getReadLock().lock();
        try {
            List list = pkg.getRrd().getRraCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Package> enumeratePackage() {
        this.getReadLock().lock();
        try {
            Enumeration enumeration = this.getConfiguration().enumeratePackage();
            return enumeration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<Monitor> enumerateMonitor() {
        this.getReadLock().lock();
        try {
            Enumeration enumeration = this.getConfiguration().enumerateMonitor();
            return enumeration;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Service> services(Package pkg) {
        this.getReadLock().lock();
        try {
            List list = pkg.getServiceCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> includeURLs(Package pkg) {
        this.getReadLock().lock();
        try {
            List list = pkg.getIncludeUrlCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Parameter> parameters(Service svc) {
        this.getReadLock().lock();
        try {
            List list = svc.getParameterCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Package> packages() {
        this.getReadLock().lock();
        try {
            List list = this.getConfiguration().getPackageCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Monitor> monitors() {
        this.getReadLock().lock();
        try {
            List list = this.getConfiguration().getMonitorCollection();
            return list;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getThreads() {
        this.getReadLock().lock();
        try {
            int n = this.getConfiguration().getThreads();
            return n;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private void initializeServiceMonitors() {
        LogUtils.debugf((Object)this, (String)"start: Loading monitors", (Object[])new Object[0]);
        Collection<ServiceMonitorLocator> locators = this.getServiceMonitorLocators(DistributionContext.DAEMON);
        for (ServiceMonitorLocator locator : locators) {
            try {
                this.m_svcMonitors.put(locator.getServiceName(), locator.getServiceMonitor());
            }
            catch (Throwable t) {
                LogUtils.warnf((Object)this, (Throwable)t, (String)"start: Failed to create monitor %s for service %s", (Object[])new Object[]{locator.getServiceLocatorKey(), locator.getServiceName()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ServiceMonitor> getServiceMonitors() {
        this.getReadLock().lock();
        try {
            Map<String, ServiceMonitor> map = this.m_svcMonitors;
            return map;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceMonitor getServiceMonitor(String svcName) {
        this.getReadLock().lock();
        try {
            ServiceMonitor serviceMonitor = this.getServiceMonitors().get(svcName);
            return serviceMonitor;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        ArrayList<ServiceMonitorLocator> locators = new ArrayList<ServiceMonitorLocator>();
        this.getReadLock().lock();
        try {
            for (Monitor monitor : this.monitors()) {
                try {
                    Class<? extends ServiceMonitor> mc = this.findServiceMonitorClass(monitor);
                    if (!this.isDistributableToContext(mc, context)) continue;
                    DefaultServiceMonitorLocator locator = new DefaultServiceMonitorLocator(monitor.getService(), mc);
                    locators.add(locator);
                }
                catch (ClassNotFoundException e) {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to location monitor for service: %s class-name: %s", (Object[])new Object[]{monitor.getService(), monitor.getClassName()});
                }
                catch (CastorObjectRetrievalFailureException e) {
                    LogUtils.warnf((Object)this, (Throwable)e, (String)e.getMessage(), (Object[])new Object[]{e.getRootCause()});
                }
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return locators;
    }

    private boolean isDistributableToContext(Class<? extends ServiceMonitor> mc, DistributionContext context) {
        List<DistributionContext> supportedContexts = this.getSupportedDistributionContexts(mc);
        return supportedContexts.contains(context) || supportedContexts.contains(DistributionContext.ALL);
    }

    private List<DistributionContext> getSupportedDistributionContexts(Class<? extends ServiceMonitor> mc) {
        Distributable distributable = mc.getAnnotation(Distributable.class);
        List<DistributionContext> declaredContexts = distributable == null ? Collections.singletonList(DistributionContext.DAEMON) : Arrays.asList(distributable.value());
        return declaredContexts;
    }

    private Class<? extends ServiceMonitor> findServiceMonitorClass(Monitor monitor) throws ClassNotFoundException {
        Class<ServiceMonitor> mc = Class.forName(monitor.getClassName()).asSubclass(ServiceMonitor.class);
        if (!ServiceMonitor.class.isAssignableFrom(mc)) {
            throw new MarshallingResourceFailureException("The monitor for service: " + monitor.getService() + " class-name: " + monitor.getClassName() + " must implement ServiceMonitor");
        }
        return mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNextOutageIdSql() {
        this.getReadLock().lock();
        try {
            String string = this.m_config.getNextOutageId();
            return string;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAllServiceMonitors() {
        this.getWriteLock().lock();
        try {
            for (ServiceMonitor sm : this.getServiceMonitors().values()) {
                sm.release();
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveResponseTimeData(String locationMonitor, OnmsMonitoredService monSvc, double responseTime, Package pkg) {
        this.getReadLock().lock();
        try {
            String svcName = monSvc.getServiceName();
            Service svc = this.getServiceInPackage(svcName, pkg);
            String dsName = this.getServiceParameter(svc, "ds-name");
            if (dsName == null) {
                return;
            }
            String rrdRepository = this.getServiceParameter(svc, "rrd-repository");
            if (rrdRepository == null) {
                return;
            }
            String rrdDir = rrdRepository + File.separatorChar + "distributed" + File.separatorChar + locationMonitor + File.separator + InetAddressUtils.str((InetAddress)monSvc.getIpAddress());
            try {
                File rrdFile = new File(rrdDir, dsName);
                if (!rrdFile.exists()) {
                    RrdUtils.createRRD((String)locationMonitor, (String)rrdDir, (String)dsName, (int)this.getStep(pkg), (String)"GAUGE", (int)600, (String)"U", (String)"U", this.getRRAList(pkg));
                }
                RrdUtils.updateRRD((String)locationMonitor, (String)rrdDir, (String)dsName, (long)System.currentTimeMillis(), (String)String.valueOf(responseTime));
            }
            catch (RrdException e) {
                throw new PermissionDeniedDataAccessException("Unable to store rrdData from " + locationMonitor + " for service " + monSvc, (Throwable)e);
            }
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    private String getServiceParameter(Service svc, String key) {
        for (Parameter parm : this.parameters(svc)) {
            if (!key.equals(parm.getKey())) continue;
            if (parm.getValue() != null) {
                return parm.getValue();
            }
            if (parm.getAnyObject() == null) continue;
            return parm.getAnyObject().toString();
        }
        return null;
    }
}

