/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.notificationCommands.NotificationCommands;

public abstract class NotificationCommandManager {
    private Map<String, Command> m_commands;

    protected void parseXML(InputStream reader) throws MarshalException, ValidationException {
        NotificationCommands config = (NotificationCommands)CastorUtils.unmarshal(NotificationCommands.class, (InputStream)reader);
        HashMap<String, Command> commands = new HashMap<String, Command>();
        for (Command curCommand : NotificationCommandManager.getCommandsFromConfig(config)) {
            if (curCommand != null && curCommand.getName() != null) {
                commands.put(curCommand.getName(), curCommand);
                continue;
            }
            NotificationCommandManager.log().warn("invalid notification command: " + curCommand);
        }
        this.m_commands = commands;
    }

    private static List<Command> getCommandsFromConfig(NotificationCommands config) {
        if (config == null) {
            NotificationCommandManager.log().warn("no notification commands found");
            return Collections.emptyList();
        }
        return config.getCommandCollection();
    }

    public abstract void update() throws Exception;

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(NotificationCommandManager.class);
    }

    public Command getCommand(String name) {
        return this.m_commands.get(name);
    }

    public Map<String, Command> getCommands() {
        return this.m_commands;
    }
}

