/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.opennms.core.xml.MarshallingExceptionTranslator;
import org.opennms.netmgt.config.GroupDao;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.OwnedIntervalSequence;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.groups.Role;
import org.opennms.netmgt.config.groups.Schedule;
import org.opennms.netmgt.dao.CastorObjectRetrievalFailureException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;

public class GroupManagerGroupDao
implements GroupDao,
InitializingBean {
    private static final GroupManagerCastorExceptionTranslator CASTOR_EXCEPTION_TRANSLATOR = new GroupManagerCastorExceptionTranslator();
    private GroupManager m_groupManager;

    @Override
    public void deleteGroup(String name) {
        try {
            this.m_groupManager.deleteGroup(name);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("deleting group '" + name + "'", e);
        }
    }

    @Override
    public void deleteRole(String name) {
        try {
            this.m_groupManager.deleteRole(name);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("deleting role '" + name + "'", e);
        }
    }

    @Override
    public void deleteUser(String name) {
        try {
            this.m_groupManager.deleteUser(name);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("deleting user '" + name + "'", e);
        }
    }

    @Override
    public List<Group> findGroupsForUser(String user) {
        return this.m_groupManager.findGroupsForUser(user);
    }

    @Override
    public Group getGroup(String name) {
        try {
            return this.m_groupManager.getGroup(name);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting group '" + name + "'", e);
        }
    }

    @Override
    public List<String> getGroupNames() {
        try {
            return this.m_groupManager.getGroupNames();
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting group names", e);
        }
    }

    @Override
    public Map<String, Group> getGroups() {
        try {
            return this.m_groupManager.getGroups();
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting groups", e);
        }
    }

    @Override
    public Role getRole(String name) {
        try {
            return this.m_groupManager.getRole(name);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting role '" + name + "'", e);
        }
    }

    @Override
    public String[] getRoleNames() {
        return this.m_groupManager.getRoleNames();
    }

    @Override
    public OwnedIntervalSequence getRoleScheduleEntries(String role, Date start, Date end) {
        try {
            return this.m_groupManager.getRoleScheduleEntries(role, start, end);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting scheduled entries for role '" + role + "' between " + start + " and " + end, e);
        }
    }

    @Override
    public Collection<Role> getRoles() {
        try {
            return this.m_groupManager.getRoles();
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting roles", e);
        }
    }

    @Override
    public List<Schedule> getSchedulesForRoleAt(String role, Date time) {
        try {
            return this.m_groupManager.getSchedulesForRoleAt(role, time);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting schedules for role '" + role + "' at " + time, e);
        }
    }

    @Override
    public List<Schedule> getUserSchedulesForRole(String user, String role) {
        try {
            return this.m_groupManager.getUserSchedulesForRole(user, role);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting user schedules for user '" + user + "' for role '" + role + "'", e);
        }
    }

    @Override
    public long groupNextOnDuty(String group, Calendar time) {
        try {
            return this.m_groupManager.groupNextOnDuty(group, time);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting next on duty time for group '" + group + "' after " + time, e);
        }
    }

    @Override
    public boolean hasGroup(String name) {
        try {
            return this.m_groupManager.hasGroup(name);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting group '" + name + "'", e);
        }
    }

    @Override
    public boolean isGroupOnDuty(String group, Calendar time) {
        try {
            return this.m_groupManager.isGroupOnDuty(group, time);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("getting group '" + group + "' to see if it is on duty at " + time, e);
        }
    }

    @Override
    public boolean isUserScheduledForRole(String user, String role, Date time) {
        try {
            return this.m_groupManager.isUserScheduledForRole(user, role, time);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("checking to see if user '" + user + "' is schedule for role '" + role + "' at " + time, e);
        }
    }

    @Override
    public void renameGroup(String oldName, String newName) {
        try {
            this.m_groupManager.renameGroup(oldName, newName);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("renaming group from '" + oldName + "' to '" + newName + "'", e);
        }
    }

    @Override
    public void renameUser(String oldName, String newName) {
        try {
            this.m_groupManager.renameUser(oldName, newName);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("renaming user from '" + oldName + "' to '" + newName + "'", e);
        }
    }

    @Override
    public void saveGroup(String name, Group details) {
        try {
            this.m_groupManager.saveGroup(name, details);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("saving group '" + name + "' with details " + details, e);
        }
    }

    @Override
    public void saveGroups() {
        try {
            this.m_groupManager.saveGroups();
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("saving groups", e);
        }
    }

    @Override
    public void saveRole(Role name) {
        try {
            this.m_groupManager.saveRole(name);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("saving role '" + name + "'", e);
        }
    }

    @Override
    public void setGroups(Map<String, Group> groups) {
        this.m_groupManager.setGroups(groups);
    }

    @Override
    public boolean userHasRole(String user, String role) {
        try {
            return this.m_groupManager.userHasRole(user, role);
        }
        catch (Throwable e) {
            throw CASTOR_EXCEPTION_TRANSLATOR.translate("checking to see if user '" + user + "' has role '" + role + "'", e);
        }
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_groupManager != null ? 1 : 0) != 0, (String)"groupManager property must be set and be non-null");
    }

    public GroupManager getGroupManager() {
        return this.m_groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.m_groupManager = groupManager;
    }

    @Override
    public String getDefaultMapForUser(String user) {
        for (Group group : this.findGroupsForUser(user)) {
            if (group.getDefaultMap() == null) continue;
            return group.getDefaultMap();
        }
        return null;
    }

    public static class GroupManagerCastorExceptionTranslator
    extends MarshallingExceptionTranslator {
        public DataAccessException translate(String task, Throwable e) {
            return new CastorObjectRetrievalFailureException("General error while " + task + ": " + e, e);
        }
    }
}

