/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.DefaultEventConfDao;
import org.opennms.netmgt.config.EventConfDao;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;

public abstract class EventconfFactory {
    private static EventConfDao s_instance;

    public static synchronized void init() throws DataAccessException {
        if (EventconfFactory.isInitialized()) {
            return;
        }
        File rootConfigFile = EventconfFactory.getDefaultRootConfigFile();
        DefaultEventConfDao newInstance = new DefaultEventConfDao();
        newInstance.setConfigResource((Resource)new FileSystemResource(rootConfigFile));
        newInstance.afterPropertiesSet();
        EventconfFactory.setInstance(newInstance);
    }

    public static synchronized void reinit() throws DataAccessException {
        EventconfFactory.setInstance(null);
        EventconfFactory.init();
    }

    public static synchronized EventConfDao getInstance() {
        if (!EventconfFactory.isInitialized()) {
            throw new IllegalStateException("init() or setInstance() not called.");
        }
        return s_instance;
    }

    public static void setInstance(EventConfDao instance) {
        s_instance = instance;
    }

    private static boolean isInitialized() {
        return s_instance != null;
    }

    private static File getDefaultRootConfigFile() throws DataAccessException {
        try {
            return ConfigFileConstants.getFile((int)ConfigFileConstants.EVENT_CONF_FILE_NAME);
        }
        catch (IOException e) {
            throw new ObjectRetrievalFailureException(String.class, (Object)ConfigFileConstants.getFileName((int)ConfigFileConstants.EVENT_CONF_FILE_NAME), "Could not get configuration file for " + ConfigFileConstants.getFileName((int)ConfigFileConstants.EVENT_CONF_FILE_NAME), (Throwable)e);
        }
    }
}

