/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.Collectd;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionException;
import org.opennms.netmgt.collectd.CollectionInitializationException;
import org.opennms.netmgt.collectd.ForceRescanState;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;

public class SnmpCollector
implements ServiceCollector {
    static final String SERVICE_NAME = "SNMP";
    static final char nonAnRepl = '_';
    static final String AnReplEx = "-._";
    static final String IFALIAS_OID = ".1.3.6.1.2.1.31.1.1.1.18";
    static final String SQL_GET_SNMPIFALIASES = "SELECT snmpifalias FROM snmpinterface WHERE nodeid=? AND snmpifindex = ? AND snmpifalias != ''";
    static final String SQL_GET_LATEST_FORCED_RESCAN_EVENTID = "SELECT eventid FROM events WHERE (nodeid=? OR ipaddr=?) AND eventuei='uei.opennms.org/internal/capsd/forceRescan' ORDER BY eventid DESC LIMIT 1";
    static final String SQL_GET_LATEST_RESCAN_COMPLETED_EVENTID = "SELECT eventid FROM events WHERE nodeid=? AND eventuei='uei.opennms.org/internal/capsd/rescanCompleted' ORDER BY eventid DESC LIMIT 1";
    static final String INTERFACES_IFNUMBER = ".1.3.6.1.2.1.2.1";
    static final String NODE_SYSUPTIME = ".1.3.6.1.2.1.1.3";
    public static String SNMP_STORAGE_PRIMARY = "primary";
    static String SNMP_STORAGE_ALL = "all";
    static String SNMP_STORAGE_SELECT = "select";
    static int DEFAULT_MAX_VARS_PER_PDU = 30;
    static final String SNMP_PEER_KEY = "org.opennms.netmgt.collectd.SnmpCollector.SnmpPeer";
    static final String INTERFACE_COUNT_KEY = "org.opennms.netmgt.collectd.SnmpCollector.ifCount";
    static String IF_MAP_KEY = "org.opennms.netmgt.collectd.SnmpCollector.ifMap";
    static String NODE_INFO_KEY = "org.opennms.netmgt.collectd.SnmpCollector.nodeInfo";
    static String SNMP_STORAGE_KEY = "org.opennms.netmgt.collectd.SnmpCollector.snmpStorage";

    public String serviceName() {
        return SERVICE_NAME;
    }

    @Override
    public void initialize(Map<String, String> parameters) {
        this.initSnmpPeerFactory();
        this.initDatabaseConnectionFactory();
    }

    private void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (IOException e) {
            this.log().fatal("initDatabaseConnectionFactory: IOException getting database connection: " + e, (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            this.log().fatal("initDatabaseConnectionFactory: Marshall Exception getting database connection: " + (Object)((Object)e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal("initDatabaseConnectionFactory: Validation Exception getting database connection: " + (Object)((Object)e), (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database: " + e, (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database: " + e, (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed loading database driver: " + e, (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initSnmpPeerFactory() {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException e) {
            this.log().fatal("initSnmpPeerFactory: Failed to load SNMP configuration: " + e, (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public void initialize(CollectionAgent agent, Map<String, Object> parameters) throws CollectionInitializationException {
        agent.validateAgent();
    }

    @Override
    public void release(CollectionAgent agent) {
        agent.setAttribute("SNMP_COLLECTION", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollectionSet collect(CollectionAgent agent, EventProxy eventProxy, Map<String, Object> parameters) throws CollectionException {
        ServiceParameters params = new ServiceParameters(parameters);
        params.logIfAliasConfig();
        OnmsSnmpCollection snmpCollection = new OnmsSnmpCollection(agent, params);
        ForceRescanState forceRescanState = new ForceRescanState(agent, eventProxy);
        SnmpCollectionSet collectionSet = snmpCollection.createCollectionSet(agent);
        collectionSet.setCollectionTimestamp(new Date());
        if (!collectionSet.hasDataToCollect()) {
            this.logNoDataToCollect(agent);
        }
        Collectd.instrumentation().beginCollectingServiceData(collectionSet.getCollectionAgent().getNodeId(), collectionSet.getCollectionAgent().getHostAddress(), this.serviceName());
        try {
            collectionSet.collect();
            if (System.getProperty("org.opennms.netmgt.collectd.SnmpCollector.forceRescan", "false").equalsIgnoreCase("true") && collectionSet.rescanNeeded()) {
                forceRescanState.rescanIndicated();
            }
            SnmpCollectionSet snmpCollectionSet = collectionSet;
            Collectd.instrumentation().endCollectingServiceData(collectionSet.getCollectionAgent().getNodeId(), collectionSet.getCollectionAgent().getHostAddress(), this.serviceName());
            return snmpCollectionSet;
        }
        catch (Throwable throwable) {
            try {
                Collectd.instrumentation().endCollectingServiceData(collectionSet.getCollectionAgent().getNodeId(), collectionSet.getCollectionAgent().getHostAddress(), this.serviceName());
                throw throwable;
            }
            catch (CollectionException e) {
                Collectd.instrumentation().reportCollectionException(agent.getNodeId(), agent.getHostAddress(), this.serviceName(), e);
                throw e;
            }
            catch (Throwable t) {
                throw new CollectionException("Unexpected error during node SNMP collection for: " + agent.getHostAddress() + ": " + t, t);
            }
        }
    }

    private void logNoDataToCollect(CollectionAgent agent) {
        this.log().info("agent " + agent + " defines no data to collect.  Skipping.");
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        return DataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }
}

