/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.snmp.SnmpInstId;

public abstract class ResourceType {
    private CollectionAgent m_agent;
    private OnmsSnmpCollection m_snmpCollection;
    private Collection<SnmpAttributeType> m_attributeTypes;

    public ResourceType(CollectionAgent agent, OnmsSnmpCollection snmpCollection) {
        this.m_agent = agent;
        this.m_snmpCollection = snmpCollection;
    }

    public CollectionAgent getAgent() {
        return this.m_agent;
    }

    protected String getCollectionName() {
        return this.m_snmpCollection.getName();
    }

    protected OnmsSnmpCollection getCollection() {
        return this.m_snmpCollection;
    }

    public final Collection<SnmpAttributeType> getAttributeTypes() {
        if (this.m_attributeTypes == null) {
            this.m_attributeTypes = this.loadAttributeTypes();
        }
        return this.m_attributeTypes;
    }

    protected abstract Collection<SnmpAttributeType> loadAttributeTypes();

    protected boolean hasDataToCollect() {
        return !this.getAttributeTypes().isEmpty();
    }

    public SnmpInstId[] getCollectionInstances() {
        return null;
    }

    public abstract SnmpCollectionResource findResource(SnmpInstId var1);

    public abstract SnmpCollectionResource findAliasedResource(SnmpInstId var1, String var2);

    public abstract Collection<? extends SnmpCollectionResource> getResources();

    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

