/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.AbstractCollectionAttribute;
import org.opennms.netmgt.collectd.AbstractCollectionResource;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.JMXCollectorEntry;
import org.opennms.netmgt.collectd.JMXDataSource;
import org.opennms.netmgt.collectd.JMXNodeInfo;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.BeanInfo;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.JMXDataCollectionConfigFactory;
import org.opennms.netmgt.config.collectd.Attrib;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionAttributeType;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.config.collector.Persister;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.protocols.jmx.connectors.ConnectionWrapper;

public abstract class JMXCollector
implements ServiceCollector {
    static String IF_MAP_KEY = "org.opennms.netmgt.collectd.JBossCollector.ifMap";
    private static final int MAX_DS_NAME_LENGTH = 19;
    private boolean useFriendlyName = false;
    static String NODE_INFO_KEY = "org.opennms.netmgt.collectd.JMXCollector.nodeInfo";
    private String serviceName = null;

    public String serviceName() {
        return this.serviceName.toUpperCase();
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    @Override
    public void initialize(Map<String, String> parameters) {
        try {
            JMXDataCollectionConfigFactory.init();
        }
        catch (Throwable e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"initialize: Failed to load data collection configuration", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        Connection ctest = null;
        try {
            DataSourceFactory.init();
            ctest = DataSourceFactory.getInstance().getConnection();
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"initialize: failed to get a database connection", (Object[])new Object[0]);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            if (ctest != null) {
                try {
                    ctest.close();
                }
                catch (Throwable t) {
                    LogUtils.debugf((Object)this, (String)"initialize: an exception occured while closing the JDBC connection", (Object[])new Object[0]);
                }
            }
        }
        LogUtils.debugf((Object)this, (String)"initialize: successfully instantiated JNI interface to RRD.", (Object[])new Object[0]);
    }

    @Override
    public void release() {
    }

    @Override
    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        InetAddress ipAddr = (InetAddress)agent.getAddress();
        int nodeID = agent.getNodeId();
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)this.serviceName);
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LogUtils.debugf((Object)this, (String)"initialize: InetAddress=%s, collectionName=%s", (Object[])new Object[]{hostAddress, collectionName});
        JMXNodeInfo nodeInfo = new JMXNodeInfo(nodeID);
        LogUtils.debugf((Object)this, (String)"nodeInfo: %s %d %s", (Object[])new Object[]{hostAddress, nodeID, agent});
        Map<String, List<Attrib>> attrMap = JMXDataCollectionConfigFactory.getInstance().getAttributeMap(collectionName, this.serviceName, hostAddress);
        nodeInfo.setAttributeMap(attrMap);
        Map<String, JMXDataSource> dsList = this.buildDataSourceList(collectionName, attrMap);
        nodeInfo.setDsMap(dsList);
        nodeInfo.setMBeans(JMXDataCollectionConfigFactory.getInstance().getMBeanInfo(collectionName));
        agent.setAttribute(NODE_INFO_KEY, nodeInfo);
        agent.setAttribute("collectionName", collectionName);
    }

    @Override
    public void release(CollectionAgent agent) {
    }

    public abstract ConnectionWrapper getMBeanServerConnection(Map<String, Object> var1, InetAddress var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> map) {
        InetAddress ipaddr = (InetAddress)agent.getAddress();
        JMXNodeInfo nodeInfo = (JMXNodeInfo)agent.getAttribute(NODE_INFO_KEY);
        Map<String, BeanInfo> mbeans = nodeInfo.getMBeans();
        String collDir = this.serviceName;
        String port = ParameterMap.getKeyedString(map, (String)"port", null);
        String friendlyName = ParameterMap.getKeyedString(map, (String)"friendly-name", (String)port);
        if (this.useFriendlyName) {
            collDir = friendlyName;
        }
        JMXCollectionSet collectionSet = new JMXCollectionSet(agent, collDir);
        collectionSet.setCollectionTimestamp(new Date());
        JMXCollectionResource collectionResource = collectionSet.getResource();
        ConnectionWrapper connection = null;
        LogUtils.debugf((Object)this, (String)"collecting %s on node ID %d", (Object[])new Object[]{InetAddressUtils.str((InetAddress)ipaddr), nodeInfo.getNodeId()});
        try {
            connection = this.getMBeanServerConnection(map, ipaddr);
            if (connection == null) {
                JMXCollectionSet jMXCollectionSet = collectionSet;
                return jMXCollectionSet;
            }
            MBeanServerConnection mbeanServer = connection.getMBeanServer();
            int retry = ParameterMap.getKeyedInteger(map, (String)"retry", (int)3);
            for (int attempts = 0; attempts <= retry; ++attempts) {
                try {
                    for (BeanInfo beanInfo : mbeans.values()) {
                        JMXCollectionAttributeType attribType;
                        JMXDataSource ds;
                        JMXCollectionAttributeType attribType2;
                        JMXDataSource ds2;
                        Attribute attrib;
                        String objectName = beanInfo.getObjectName();
                        String excludeList = beanInfo.getExcludes();
                        AttributeGroupType attribGroupType = new AttributeGroupType(this.fixGroupName(objectName), "all");
                        List<String> attribNames = beanInfo.getAttributeNames();
                        List<String> compAttribNames = beanInfo.getCompositeAttributeNames();
                        for (String compAttribName : compAttribNames) {
                            if (!attribNames.contains(compAttribName)) continue;
                            attribNames.remove(compAttribName);
                            String[] ac = compAttribName.split("\\|", -1);
                            String attrName = ac[0];
                            if (attribNames.contains(attrName)) continue;
                            attribNames.add(attrName);
                        }
                        String[] attrNames = attribNames.toArray(new String[attribNames.size()]);
                        if (objectName.indexOf("*") == -1) {
                            LogUtils.debugf((Object)this, (String)"%s Collector - getAttributes: %s, # attributes: %d, # composite attribute members: %d", (Object[])new Object[]{this.serviceName, objectName, attrNames.length, compAttribNames.size()});
                            try {
                                ObjectName oName = new ObjectName(objectName);
                                if (!mbeanServer.isRegistered(oName)) continue;
                                AttributeList attrList = mbeanServer.getAttributes(oName, attrNames);
                                Map<String, JMXDataSource> dsMap = nodeInfo.getDsMap();
                                for (Object attribute : attrList) {
                                    ArrayList<String> compositeMemberKeys = new ArrayList<String>();
                                    Boolean isComposite = false;
                                    attrib = (Attribute)attribute;
                                    for (String compAttrName : compAttribNames) {
                                        String[] attribKeys = compAttrName.split("\\|", -1);
                                        if (!attrib.getName().equals(attribKeys[0])) continue;
                                        compositeMemberKeys.add(attribKeys[1]);
                                        isComposite = true;
                                    }
                                    if (isComposite.booleanValue()) {
                                        try {
                                            CompositeData cd = (CompositeData)attrib.getValue();
                                            for (String key : compositeMemberKeys) {
                                                ds2 = dsMap.get(objectName + "|" + attrib.getName() + "|" + key);
                                                attribType2 = new JMXCollectionAttributeType(ds2, null, null, attribGroupType);
                                                collectionResource.setAttributeValue(attribType2, cd.get(key).toString());
                                            }
                                            continue;
                                        }
                                        catch (ClassCastException cce) {
                                            LogUtils.debugf((Object)this, (Throwable)cce, (String)"%s Collection - getAttributes (try CompositeData) - ERROR: Failed to cast attribute value to type CompositeData!", (Object[])new Object[]{this.serviceName});
                                            continue;
                                        }
                                    }
                                    ds = dsMap.get(objectName + "|" + attrib.getName());
                                    attribType = new JMXCollectionAttributeType(ds, null, null, attribGroupType);
                                    collectionResource.setAttributeValue(attribType, attrib.getValue().toString());
                                }
                                continue;
                            }
                            catch (InstanceNotFoundException e) {
                                LogUtils.errorf((Object)this, (Throwable)e, (String)"Unable to retrieve attributes from %s", (Object[])new Object[]{objectName});
                                continue;
                            }
                        }
                        Set<ObjectName> mbeanSet = this.getObjectNames(mbeanServer, objectName);
                        for (ObjectName oName : mbeanSet) {
                            LogUtils.debugf((Object)this, (String)"%s Collector - getAttributesWC: %s, # attributes: %d, alias: %s", (Object[])new Object[]{this.serviceName, oName, attrNames.length, beanInfo.getKeyAlias()});
                            try {
                                if (excludeList == null) {
                                    if (!mbeanServer.isRegistered(oName)) continue;
                                    AttributeList attrList = mbeanServer.getAttributes(oName, attrNames);
                                    Map<String, JMXDataSource> dsMap = nodeInfo.getDsMap();
                                    for (Object attribute : attrList) {
                                        attrib = (Attribute)attribute;
                                        ds = dsMap.get(objectName + "|" + attrib.getName());
                                        attribType = new JMXCollectionAttributeType(ds, oName.getKeyProperty(beanInfo.getKeyField()), beanInfo.getKeyAlias(), attribGroupType);
                                        collectionResource.setAttributeValue(attribType, attrib.getValue().toString());
                                    }
                                    continue;
                                }
                                String keyName = oName.getKeyProperty(beanInfo.getKeyField());
                                boolean found = false;
                                StringTokenizer st = new StringTokenizer(excludeList, ",");
                                while (st.hasMoreTokens()) {
                                    if (!keyName.equals(st.nextToken())) continue;
                                    found = true;
                                    break;
                                }
                                if (found || !mbeanServer.isRegistered(oName)) continue;
                                AttributeList attrList = mbeanServer.getAttributes(oName, attrNames);
                                Map<String, JMXDataSource> dsMap = nodeInfo.getDsMap();
                                for (String attribute : attrList) {
                                    Attribute attrib2 = (Attribute)((Object)attribute);
                                    ds2 = dsMap.get(objectName + "|" + attrib2.getName());
                                    attribType2 = new JMXCollectionAttributeType(ds2, oName.getKeyProperty(beanInfo.getKeyField()), beanInfo.getKeyAlias(), attribGroupType);
                                    collectionResource.setAttributeValue(attribType2, attrib2.getValue().toString());
                                }
                            }
                            catch (InstanceNotFoundException e) {
                                LogUtils.errorf((Object)this, (Throwable)e, (String)"Error retrieving attributes for %s", (Object[])new Object[]{oName});
                            }
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    LogUtils.debugf((Object)this, (Throwable)e, (String)"%s Collector.collect: IOException while collecting address: %s", (Object[])new Object[]{this.serviceName, agent.getAddress()});
                    continue;
                }
            }
        }
        catch (Exception e) {
            LogUtils.errorf((Object)this, (Throwable)e, (String)"Error getting MBeanServer", (Object[])new Object[0]);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        collectionSet.setStatus(1);
        return collectionSet;
    }

    private Set<ObjectName> getObjectNames(MBeanServerConnection mbeanServer, String objectName) throws IOException, MalformedObjectNameException {
        return mbeanServer.queryNames(new ObjectName(objectName), null);
    }

    private String fixGroupName(String objectName) {
        if (objectName == null) {
            return "NULL";
        }
        return objectName.replaceAll("[.:=,]", "_");
    }

    private String fixKey(String key, String attrName, String substitutions) {
        String newKey = key;
        if (key.startsWith(File.separator)) {
            newKey = key.substring(1);
        }
        if (substitutions != null && substitutions.length() > 0) {
            StringTokenizer st = new StringTokenizer(substitutions, ",");
            while (st.hasMoreTokens()) {
                int index;
                String token = st.nextToken();
                if (!newKey.equals(token.substring(0, index = token.indexOf("|")))) continue;
                newKey = token.substring(index + 1);
            }
        }
        return newKey;
    }

    public String getRRDValue_isthis_used_(JMXDataSource ds, JMXCollectorEntry collectorEntry) throws IllegalArgumentException {
        LogUtils.debugf((Object)this, (String)"getRRDValue: %s", (Object[])new Object[]{ds.getName()});
        if (ds.getOid() == null) {
            return null;
        }
        return (String)collectorEntry.get(collectorEntry + "|" + ds.getOid());
    }

    private Map<String, JMXDataSource> buildDataSourceList(String collectionName, Map<String, List<Attrib>> attributeMap) {
        LogUtils.debugf((Object)this, (String)"buildDataSourceList - ***", (Object[])new Object[0]);
        HashMap<String, JMXDataSource> dsList = new HashMap<String, JMXDataSource>();
        LogUtils.debugf((Object)this, (String)"attributeMap size: %d", (Object[])new Object[]{attributeMap.size()});
        Iterator<String> objNameIter = attributeMap.keySet().iterator();
        while (objNameIter.hasNext()) {
            String objectName = objNameIter.next().toString();
            List<Attrib> list = attributeMap.get(objectName);
            LogUtils.debugf((Object)this, (String)"ObjectName: %s, Attributes: %d", (Object[])new Object[]{objectName, list.size()});
            for (Attrib attr : list) {
                JMXDataSource ds = null;
                String ds_type = JMXDataSource.mapType(attr.getType());
                if (ds_type != null) {
                    ds = new JMXDataSource();
                    ds.setHeartbeat(2 * JMXDataCollectionConfigFactory.getInstance().getStep(collectionName));
                    String ds_minval = attr.getMinval();
                    if (ds_minval == null) {
                        ds_minval = "U";
                    }
                    ds.setMax(ds_minval);
                    String ds_maxval = attr.getMaxval();
                    if (ds_maxval == null) {
                        ds_maxval = "U";
                    }
                    ds.setMax(ds_maxval);
                    ds.setInstance(collectionName);
                    String ds_name = attr.getAlias();
                    if (ds_name.length() > 19) {
                        LogUtils.warnf((Object)this, (String)"buildDataSourceList: alias '%s' exceeds 19 char maximum for RRD data source names, truncating.", (Object[])new Object[]{attr.getAlias()});
                        char[] temp = ds_name.toCharArray();
                        ds_name = String.copyValueOf(temp, 0, 19);
                    }
                    ds.setName(ds_name);
                    ds.setType(ds_type);
                    ds.setOid(attr.getName());
                    LogUtils.debugf((Object)this, (String)"buildDataSourceList: ds_name: %s ds_oid: %s.%s ds_max: %s ds_min: %s", (Object[])new Object[]{ds.getName(), ds.getOid(), ds.getInstance(), ds.getMax(), ds.getMin()});
                    dsList.put(objectName + "|" + attr.getName(), ds);
                    continue;
                }
                LogUtils.warnf((Object)this, (String)"buildDataSourceList: Data type '%s' not supported.  Only integer-type data may be stored in RRD.  MBean object '%s' will not be mapped to RRD data source.", (Object[])new Object[]{attr.getType(), attr.getAlias()});
            }
        }
        return dsList;
    }

    public void setUseFriendlyName(boolean useFriendlyName) {
        this.useFriendlyName = useFriendlyName;
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        return JMXDataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    class JMXCollectionSet
    implements CollectionSet {
        private int m_status = 2;
        private Date m_timestamp;
        private JMXCollectionResource m_collectionResource;

        JMXCollectionSet(CollectionAgent agent, String resourceName) {
            this.m_collectionResource = new JMXCollectionResource(agent, resourceName);
        }

        public JMXCollectionResource getResource() {
            return this.m_collectionResource;
        }

        public void setStatus(int status) {
            this.m_status = status;
        }

        public int getStatus() {
            return this.m_status;
        }

        public void visit(CollectionSetVisitor visitor) {
            visitor.visitCollectionSet((CollectionSet)this);
            this.m_collectionResource.visit(visitor);
            visitor.completeCollectionSet((CollectionSet)this);
        }

        public boolean ignorePersist() {
            return false;
        }

        public Date getCollectionTimestamp() {
            return this.m_timestamp;
        }

        public void setCollectionTimestamp(Date timestamp) {
            this.m_timestamp = timestamp;
        }
    }

    class JMXCollectionResource
    extends AbstractCollectionResource {
        String m_resourceName;
        private int m_nodeId;

        JMXCollectionResource(CollectionAgent agent, String resourceName) {
            super(agent);
            this.m_resourceName = resourceName;
            this.m_nodeId = agent.getNodeId();
        }

        public String toString() {
            return "node[" + this.m_nodeId + ']';
        }

        @Override
        public int getType() {
            return -1;
        }

        @Override
        public boolean rescanNeeded() {
            return false;
        }

        @Override
        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        public void setAttributeValue(CollectionAttributeType type, String value) {
            JMXCollectionAttribute attr = new JMXCollectionAttribute(this, type, type.getName(), value);
            this.addAttribute(attr);
        }

        @Override
        public File getResourceDir(RrdRepository repository) {
            return new File(repository.getRrdBaseDir(), Integer.toString(this.m_agent.getNodeId()) + File.separator + this.m_resourceName);
        }

        public String getResourceTypeName() {
            return "node";
        }

        public String getInstance() {
            return null;
        }

        public String getParent() {
            return Integer.toString(this.m_nodeId);
        }
    }

    class JMXCollectionAttribute
    extends AbstractCollectionAttribute
    implements CollectionAttribute {
        String m_alias;
        String m_value;
        JMXCollectionResource m_resource;
        CollectionAttributeType m_attribType;

        JMXCollectionAttribute(JMXCollectionResource resource, CollectionAttributeType attribType, String alias, String value) {
            this.m_resource = resource;
            this.m_attribType = attribType;
            this.m_alias = alias;
            this.m_value = value;
        }

        @Override
        public CollectionAttributeType getAttributeType() {
            return this.m_attribType;
        }

        @Override
        public String getName() {
            return this.m_alias;
        }

        @Override
        public String getNumericValue() {
            return this.m_value;
        }

        @Override
        public CollectionResource getResource() {
            return this.m_resource;
        }

        @Override
        public String getStringValue() {
            return this.m_value;
        }

        @Override
        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        public String getType() {
            return this.m_attribType.getType();
        }

        public String toString() {
            return "alias " + this.m_alias + ", value " + this.m_value + ", resource " + this.m_resource + ", attributeType " + this.m_attribType;
        }
    }

    class JMXCollectionAttributeType
    implements CollectionAttributeType {
        JMXDataSource m_dataSource;
        AttributeGroupType m_groupType;
        String m_name;

        protected JMXCollectionAttributeType(JMXDataSource dataSource, String key, String substitutions, AttributeGroupType groupType) {
            this.m_groupType = groupType;
            this.m_dataSource = dataSource;
            this.m_name = this.createName(key, substitutions);
        }

        private String createName(String key, String substitutions) {
            String name = this.m_dataSource.getName();
            if (key != null && !key.equals("")) {
                name = JMXCollector.this.fixKey(key, this.m_dataSource.getName(), substitutions) + "_" + name;
            }
            return name;
        }

        public AttributeGroupType getGroupType() {
            return this.m_groupType;
        }

        public void storeAttribute(CollectionAttribute attribute, Persister persister) {
            persister.persistNumericAttribute(attribute);
        }

        public String getName() {
            return this.m_name;
        }

        public String getType() {
            return this.m_dataSource.getType();
        }
    }
}

