/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.EmptyKeyRelaxedTrustProvider;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.TimeKeeper;
import org.opennms.netmgt.collectd.AbstractCollectionAttribute;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionInitializationException;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.HttpCollectionConfigFactory;
import org.opennms.netmgt.config.collector.AttributeDefinition;
import org.opennms.netmgt.config.collector.AttributeGroup;
import org.opennms.netmgt.config.collector.AttributeGroupType;
import org.opennms.netmgt.config.collector.CollectionAttribute;
import org.opennms.netmgt.config.collector.CollectionAttributeType;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.config.collector.Persister;
import org.opennms.netmgt.config.collector.ServiceParameters;
import org.opennms.netmgt.config.httpdatacollection.Attrib;
import org.opennms.netmgt.config.httpdatacollection.HttpCollection;
import org.opennms.netmgt.config.httpdatacollection.Parameter;
import org.opennms.netmgt.config.httpdatacollection.Uri;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;

public class HttpCollector
implements ServiceCollector {
    private static final int DEFAULT_RETRY_COUNT = 2;
    private static final String DEFAULT_SO_TIMEOUT = "3000";
    private final HashMap<Integer, String> m_scheduledNodes = new HashMap();
    private static final NumberFormat PARSER = NumberFormat.getNumberInstance();
    private static NumberFormat RRD_FORMATTER;

    @Override
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> parameters) {
        HttpCollectionSet collectionSet = new HttpCollectionSet(agent, parameters);
        collectionSet.setCollectionTimestamp(new Date());
        collectionSet.collect();
        return collectionSet;
    }

    protected static ThreadCategory log() {
        return ThreadCategory.getInstance(HttpCollector.class);
    }

    private void doCollection(HttpCollectionSet collectionSet, HttpCollectionResource collectionResource) throws HttpCollectorException {
        DefaultHttpClient client = null;
        HttpUriRequest method = null;
        try {
            HttpParams params = HttpCollector.buildParams(collectionSet);
            client = new DefaultHttpClient(params);
            if ("https".equals(collectionSet.getUriDef().getUrl().getScheme())) {
                SchemeRegistry registry = client.getConnectionManager().getSchemeRegistry();
                Scheme https = registry.getScheme("https");
                SSLSocketFactory factory = new SSLSocketFactory(SSLContext.getInstance("EmptyKeyRelaxedTrust"), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                Scheme lenient = new Scheme(https.getName(), https.getDefaultPort(), (SchemeSocketFactory)factory);
                registry.register(lenient);
            }
            String key = "retry";
            if (collectionSet.getParameters().containsKey("retries")) {
                key = "retries";
            }
            Integer retryCount = ParameterMap.getKeyedInteger(collectionSet.getParameters(), (String)key, (int)2);
            client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(retryCount.intValue(), false));
            method = HttpCollector.buildHttpMethod(collectionSet);
            method.getParams().setParameter("http.useragent", (Object)HttpCollector.determineUserAgent(collectionSet, params));
            HttpCollector.buildCredentials(collectionSet, client, method);
            HttpCollector.log().info("doCollection: collecting for client: " + client + " using method: " + method);
            HttpResponse response = client.execute(method);
            this.persistResponse(collectionSet, collectionResource, (HttpClient)client, response);
        }
        catch (URISyntaxException e) {
            throw new HttpCollectorException("Error building HttpClient URI");
        }
        catch (IOException e) {
            throw new HttpCollectorException("IO Error retrieving page");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpCollectorException("Could not find EmptyKeyRelaxedTrustSSLContext to allow connection to untrusted HTTPS hosts");
        }
    }

    private List<HttpCollectionAttribute> processResponse(String responseBodyAsString, HttpCollectionSet collectionSet, HttpCollectionResource collectionResource) {
        HttpCollector.log().debug("processResponse:");
        HttpCollector.log().debug("responseBody = " + responseBodyAsString);
        HttpCollector.log().debug("getmatches = " + collectionSet.getUriDef().getUrl().getMatches());
        LinkedList<HttpCollectionAttribute> butes = new LinkedList<HttpCollectionAttribute>();
        int flags = 0;
        if (collectionSet.getUriDef().getUrl().getCanonicalEquivalence()) {
            flags |= 0x80;
        }
        if (collectionSet.getUriDef().getUrl().getCaseInsensitive()) {
            flags |= 2;
        }
        if (collectionSet.getUriDef().getUrl().getComments()) {
            flags |= 4;
        }
        if (collectionSet.getUriDef().getUrl().getDotall()) {
            flags |= 0x20;
        }
        if (collectionSet.getUriDef().getUrl().getLiteral()) {
            flags |= 0x10;
        }
        if (collectionSet.getUriDef().getUrl().getMultiline()) {
            flags |= 8;
        }
        if (collectionSet.getUriDef().getUrl().getUnicodeCase()) {
            flags |= 0x40;
        }
        if (collectionSet.getUriDef().getUrl().getUnixLines()) {
            flags |= 1;
        }
        HttpCollector.log().debug("flags = " + flags);
        Pattern p = Pattern.compile(collectionSet.getUriDef().getUrl().getMatches(), flags);
        Matcher m = p.matcher(responseBodyAsString);
        boolean matches = m.matches();
        if (matches) {
            HttpCollector.log().debug("processResponse: found matching attributes: " + matches);
            List attribDefs = collectionSet.getUriDef().getAttributes().getAttribCollection();
            AttributeGroupType groupType = new AttributeGroupType(collectionSet.getUriDef().getName(), "all");
            for (Attrib attribDef : attribDefs) {
                if (!attribDef.getType().matches("^([Oo](ctet|CTET)[Ss](tring|TRING))|([Ss](tring|TRING))$")) {
                    try {
                        Number num = NumberFormat.getNumberInstance().parse(m.group(attribDef.getMatchGroup()));
                        HttpCollectionAttribute bute = new HttpCollectionAttribute(collectionResource, new HttpCollectionAttributeType(attribDef, groupType), attribDef.getAlias(), attribDef.getType(), num);
                        HttpCollector.log().debug("processResponse: adding found numeric attribute: " + bute);
                        butes.add(bute);
                    }
                    catch (IndexOutOfBoundsException e) {
                        HttpCollector.log().error("IndexOutOfBoundsException thrown while trying to find regex group, your regex does not contain the following group index: " + attribDef.getMatchGroup());
                        HttpCollector.log().error("Regex statement: " + collectionSet.getUriDef().getUrl().getMatches());
                    }
                    catch (ParseException e) {
                        HttpCollector.log().error("attribute " + attribDef.getAlias() + " failed to match a parsable number! Matched \"" + m.group(attribDef.getMatchGroup()) + "\" instead.");
                    }
                    continue;
                }
                HttpCollectionAttribute bute = new HttpCollectionAttribute(collectionResource, new HttpCollectionAttributeType(attribDef, groupType), attribDef.getAlias(), attribDef.getType(), m.group(attribDef.getMatchGroup()));
                HttpCollector.log().debug("processResponse: adding found string attribute: " + bute);
                butes.add(bute);
            }
        } else {
            HttpCollector.log().debug("processResponse: found matching attributes: " + matches);
        }
        return butes;
    }

    private void persistResponse(HttpCollectionSet collectionSet, HttpCollectionResource collectionResource, HttpClient client, HttpResponse method) throws IOException {
        String responseString = EntityUtils.toString((HttpEntity)method.getEntity());
        if (responseString != null && !"".equals(responseString)) {
            List<HttpCollectionAttribute> attributes = this.processResponse(responseString, collectionSet, collectionResource);
            if (attributes.isEmpty()) {
                HttpCollector.log().warn("doCollection: no attributes defined by the response: " + responseString.trim());
                throw new HttpCollectorException("No attributes specified were found: ");
            }
            collectionSet.storeResults(attributes, collectionResource);
        }
    }

    private static void buildCredentials(HttpCollectionSet collectionSet, DefaultHttpClient client, HttpUriRequest method) {
        if (collectionSet.getUriDef().getUrl().getUserInfo() != null) {
            String userInfo = collectionSet.getUriDef().getUrl().getUserInfo();
            String[] streetCred = userInfo.split(":", 2);
            if (streetCred.length == 2) {
                client.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(streetCred[0], streetCred[1]));
            } else {
                HttpCollector.log().warn("Illegal value found for username/password HTTP credentials: " + userInfo);
            }
        }
    }

    private static HttpParams buildParams(HttpCollectionSet collectionSet) {
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.protocol.version", (Object)HttpCollector.computeVersion(collectionSet.getUriDef()));
        params.setIntParameter("http.connection.timeout", Integer.parseInt(ParameterMap.getKeyedString(collectionSet.getParameters(), (String)"timeout", (String)DEFAULT_SO_TIMEOUT)));
        params.setIntParameter("http.socket.timeout", Integer.parseInt(ParameterMap.getKeyedString(collectionSet.getParameters(), (String)"timeout", (String)DEFAULT_SO_TIMEOUT)));
        params.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        String virtualHost = collectionSet.getUriDef().getUrl().getVirtualHost();
        if (virtualHost != null) {
            params.setParameter("http.virtual-host", (Object)new HttpHost(virtualHost, collectionSet.getPort()));
        }
        return params;
    }

    private static String determineUserAgent(HttpCollectionSet collectionSet, HttpParams params) {
        String userAgent = collectionSet.getUriDef().getUrl().getUserAgent();
        return userAgent == null ? params.getParameter("http.useragent") : userAgent;
    }

    private static HttpVersion computeVersion(Uri uri) {
        return new HttpVersion(Integer.parseInt(uri.getUrl().getHttpVersion().substring(0, 1)), Integer.parseInt(uri.getUrl().getHttpVersion().substring(2)));
    }

    private static HttpUriRequest buildHttpMethod(HttpCollectionSet collectionSet) throws URISyntaxException {
        URI uri = HttpCollector.buildUri(collectionSet);
        Object method = "GET".equals(collectionSet.getUriDef().getUrl().getMethod()) ? HttpCollector.buildGetMethod(uri, collectionSet) : HttpCollector.buildPostMethod(uri, collectionSet);
        return method;
    }

    private static HttpPost buildPostMethod(URI uri, HttpCollectionSet collectionSet) {
        HttpPost method = new HttpPost(uri);
        List<NameValuePair> postParams = HttpCollector.buildRequestParameters(collectionSet);
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(postParams, "UTF-8");
            method.setEntity((HttpEntity)entity);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return method;
    }

    private static HttpGet buildGetMethod(URI uri, HttpCollectionSet collectionSet) {
        URI uriWithQueryString = null;
        List<NameValuePair> queryParams = HttpCollector.buildRequestParameters(collectionSet);
        try {
            StringBuffer query = new StringBuffer();
            query.append(URLEncodedUtils.format(queryParams, (String)"UTF-8"));
            if (uri.getQuery() != null && uri.getQuery().length() > 0) {
                if (query.length() > 0) {
                    query.append("&");
                }
                query.append(uri.getQuery());
            }
            uriWithQueryString = URIUtils.createURI((String)uri.getScheme(), (String)uri.getHost(), (int)uri.getPort(), (String)uri.getPath(), (String)(query.length() > 0 ? query.toString() : null), (String)uri.getFragment());
            return new HttpGet(uriWithQueryString);
        }
        catch (URISyntaxException e) {
            HttpCollector.log().warn(e.getMessage(), (Throwable)e);
            return new HttpGet(uri);
        }
    }

    private static List<NameValuePair> buildRequestParameters(HttpCollectionSet collectionSet) {
        ArrayList<NameValuePair> retval = new ArrayList<NameValuePair>();
        if (collectionSet.getUriDef().getUrl().getParameters() == null) {
            return retval;
        }
        List parameters = collectionSet.getUriDef().getUrl().getParameters().getParameterCollection();
        for (Parameter p : parameters) {
            retval.add((NameValuePair)new BasicNameValuePair(p.getKey(), p.getValue()));
        }
        return retval;
    }

    private static URI buildUri(HttpCollectionSet collectionSet) throws URISyntaxException {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put("ipaddr", InetAddressUtils.str((InetAddress)collectionSet.getAgent().getInetAddress()));
        substitutions.put("nodeid", Integer.toString(collectionSet.getAgent().getNodeId()));
        return URIUtils.createURI((String)collectionSet.getUriDef().getUrl().getScheme(), (String)HttpCollector.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getHost(), "getHost"), (int)collectionSet.getPort(), (String)HttpCollector.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getPath(), "getURL"), (String)HttpCollector.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getQuery(), "getQuery"), (String)HttpCollector.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getFragment(), "getFragment"));
    }

    private static String substituteKeywords(HashMap<String, String> substitutions, String urlFragment, String desc) {
        String newFragment = urlFragment;
        if (newFragment != null) {
            for (String key : substitutions.keySet()) {
                newFragment = newFragment.replaceAll("\\$\\{" + key + "\\}", substitutions.get(key));
            }
            if (HttpCollector.log().isDebugEnabled() && newFragment.compareTo(urlFragment) != 0) {
                HttpCollector.log().debug("doSubs: " + desc + " substituted as \"" + newFragment + "\"");
            }
        }
        return newFragment;
    }

    @Override
    public void initialize(Map<String, String> parameters) throws CollectionInitializationException {
        HttpCollector.log().debug("initialize: Initializing HttpCollector.");
        this.m_scheduledNodes.clear();
        HttpCollector.initHttpCollectionConfig();
        HttpCollector.initDatabaseConnectionFactory();
        HttpCollector.initializeRrdRepository();
    }

    private static void initHttpCollectionConfig() {
        try {
            HttpCollector.log().debug("initialize: Initializing collector: " + HttpCollector.class.getSimpleName());
            HttpCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            HttpCollector.log().fatal("initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            HttpCollector.log().fatal("initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (FileNotFoundException e) {
            HttpCollector.log().fatal("initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            HttpCollector.log().fatal("initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private static void initializeRrdRepository() throws CollectionInitializationException {
        HttpCollector.log().debug("initializeRrdRepository: Initializing RRD repo from HttpCollector...");
        HttpCollector.initializeRrdDirs();
    }

    private static void initializeRrdDirs() throws CollectionInitializationException {
        File f = new File(HttpCollectionConfigFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            StringBuffer sb = new StringBuffer();
            sb.append("initializeRrdDirs: Unable to create RRD file repository.  Path doesn't already exist and could not make directory: ");
            sb.append(HttpCollectionConfigFactory.getInstance().getRrdPath());
            HttpCollector.log().error(sb.toString());
            throw new CollectionInitializationException(sb.toString());
        }
    }

    private static void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (IOException e) {
            HttpCollector.log().fatal("initDatabaseConnectionFactory: IOException getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            HttpCollector.log().fatal("initDatabaseConnectionFactory: Marshall Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            HttpCollector.log().fatal("initDatabaseConnectionFactory: Validation Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            HttpCollector.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            HttpCollector.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            HttpCollector.log().fatal("initDatabaseConnectionFactory: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        HttpCollector.log().debug("initialize: Initializing HTTP collection for agent: " + agent);
        Integer scheduledNodeKey = agent.getNodeId();
        String scheduledAddress = this.m_scheduledNodes.get(scheduledNodeKey);
        if (scheduledAddress != null) {
            HttpCollector.log().info("initialize: Not scheduling interface for collection: " + scheduledAddress);
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(HttpCollector.determineServiceName(parameters));
            sb.append(" for address: ");
            sb.append(scheduledAddress);
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent);
            HttpCollector.log().debug(sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        HttpCollector.log().info("initialize: Scheduling interface for collection: " + scheduledAddress);
        this.m_scheduledNodes.put(scheduledNodeKey, scheduledAddress);
    }

    private static String determineServiceName(Map<String, Object> parameters) {
        return ParameterMap.getKeyedString(parameters, (String)"service-name", (String)"HTTP");
    }

    @Override
    public void release() {
    }

    @Override
    public void release(CollectionAgent agent) {
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        return HttpCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    static {
        ((DecimalFormat)PARSER).setParseBigDecimal(true);
        RRD_FORMATTER = NumberFormat.getNumberInstance();
        RRD_FORMATTER.setMinimumFractionDigits(0);
        RRD_FORMATTER.setMaximumFractionDigits(Integer.MAX_VALUE);
        RRD_FORMATTER.setMinimumIntegerDigits(1);
        RRD_FORMATTER.setMaximumIntegerDigits(Integer.MAX_VALUE);
        RRD_FORMATTER.setGroupingUsed(false);
        Security.addProvider((Provider)new EmptyKeyRelaxedTrustProvider());
    }

    class HttpCollectionAttributeType
    implements CollectionAttributeType {
        Attrib m_attribute;
        AttributeGroupType m_groupType;

        protected HttpCollectionAttributeType(Attrib attribute, AttributeGroupType groupType) {
            this.m_groupType = groupType;
            this.m_attribute = attribute;
        }

        public AttributeGroupType getGroupType() {
            return this.m_groupType;
        }

        public void storeAttribute(CollectionAttribute attribute, Persister persister) {
            if (this.m_attribute.getType().equals("string")) {
                persister.persistStringAttribute(attribute);
            } else {
                persister.persistNumericAttribute(attribute);
            }
        }

        public String getName() {
            return this.m_attribute.getAlias();
        }

        public String getType() {
            return this.m_attribute.getType();
        }
    }

    class HttpCollectionResource
    implements CollectionResource {
        CollectionAgent m_agent;
        AttributeGroup m_attribGroup;

        HttpCollectionResource(CollectionAgent agent, Uri uriDef) {
            this.m_agent = agent;
            this.m_attribGroup = new AttributeGroup((CollectionResource)this, new AttributeGroupType(uriDef.getName(), "all"));
        }

        public void storeResults(List<HttpCollectionAttribute> results) {
            for (HttpCollectionAttribute attrib : results) {
                this.m_attribGroup.addAttribute((CollectionAttribute)attrib);
            }
        }

        public boolean rescanNeeded() {
            return false;
        }

        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        public String getOwnerName() {
            return this.m_agent.getHostAddress();
        }

        public File getResourceDir(RrdRepository repository) {
            return new File(repository.getRrdBaseDir(), Integer.toString(this.m_agent.getNodeId()));
        }

        public void visit(CollectionSetVisitor visitor) {
            visitor.visitResource((CollectionResource)this);
            this.m_attribGroup.visit(visitor);
            visitor.completeResource((CollectionResource)this);
        }

        public int getType() {
            return -1;
        }

        public String getResourceTypeName() {
            return "node";
        }

        public String getInstance() {
            return null;
        }

        public String getLabel() {
            return null;
        }

        public String getParent() {
            return Integer.toString(this.m_agent.getNodeId());
        }

        public TimeKeeper getTimeKeeper() {
            return null;
        }
    }

    public class HttpCollectorException
    extends RuntimeException {
        private static final long serialVersionUID = 4413332529546573490L;

        HttpCollectorException(String message) {
            super(message);
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(super.toString());
            buffer.append(": client URL: ");
            return buffer.toString();
        }
    }

    class HttpCollectionAttribute
    extends AbstractCollectionAttribute
    implements AttributeDefinition {
        String m_alias;
        String m_type;
        Object m_value;
        HttpCollectionResource m_resource;
        HttpCollectionAttributeType m_attribType;

        HttpCollectionAttribute(HttpCollectionResource resource, HttpCollectionAttributeType attribType, String alias, String type, Number value) {
            this.m_resource = resource;
            this.m_attribType = attribType;
            this.m_alias = alias;
            this.m_type = type;
            this.m_value = value;
        }

        HttpCollectionAttribute(HttpCollectionResource resource, HttpCollectionAttributeType attribType, String alias, String type, String value) {
            this.m_resource = resource;
            this.m_attribType = attribType;
            this.m_alias = alias;
            this.m_type = type;
            this.m_value = value;
        }

        @Override
        public String getName() {
            return this.m_alias;
        }

        public String getType() {
            return this.m_type;
        }

        public Object getValue() {
            return this.m_value;
        }

        @Override
        public String getNumericValue() {
            Object val = this.getValue();
            if (val instanceof Number) {
                return val.toString();
            }
            try {
                return Double.valueOf(val.toString()).toString();
            }
            catch (NumberFormatException numberFormatException) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Value for attribute " + this.toString() + " does not appear to be a number, skipping");
                }
                return null;
            }
        }

        @Override
        public String getStringValue() {
            return this.getValue().toString();
        }

        public String getValueAsString() {
            if (this.m_value instanceof Number) {
                return RRD_FORMATTER.format(this.m_value);
            }
            return this.m_value.toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof HttpCollectionAttribute) {
                HttpCollectionAttribute other = (HttpCollectionAttribute)obj;
                return this.getName().equals(other.getName());
            }
            return false;
        }

        @Override
        public CollectionAttributeType getAttributeType() {
            return this.m_attribType;
        }

        @Override
        public CollectionResource getResource() {
            return this.m_resource;
        }

        @Override
        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("HttpAttribute: ");
            buffer.append(this.getName());
            buffer.append(":");
            buffer.append(this.getType());
            buffer.append(":");
            buffer.append(this.getValueAsString());
            return buffer.toString();
        }
    }

    protected class HttpCollectionSet
    implements CollectionSet {
        private CollectionAgent m_agent;
        private Map<String, Object> m_parameters;
        private Uri m_uriDef;
        private int m_status;
        private List<HttpCollectionResource> m_collectionResourceList;
        private Date m_timestamp;

        public Uri getUriDef() {
            return this.m_uriDef;
        }

        public void setUriDef(Uri uriDef) {
            this.m_uriDef = uriDef;
        }

        HttpCollectionSet(CollectionAgent agent, Map<String, Object> parameters) {
            this.m_agent = agent;
            this.m_parameters = parameters;
            this.m_status = 2;
        }

        public void collect() {
            String collectionName = ParameterMap.getKeyedString(this.m_parameters, (String)"collection", null);
            if (collectionName == null) {
                collectionName = ParameterMap.getKeyedString(this.m_parameters, (String)"http-collection", null);
            }
            if (collectionName == null) {
                LogUtils.debugf((Object)this, (String)"no collection name found in parameters", (Object[])new Object[0]);
                this.m_status = 2;
                return;
            }
            HttpCollection collection = HttpCollectionConfigFactory.getInstance().getHttpCollection(collectionName);
            this.m_collectionResourceList = new ArrayList<HttpCollectionResource>();
            List uriDefs = collection.getUris().getUriCollection();
            Iterator i$ = uriDefs.iterator();
            while (i$.hasNext()) {
                Uri uriDef;
                this.m_uriDef = uriDef = (Uri)i$.next();
                HttpCollectionResource collectionResource = new HttpCollectionResource(this.m_agent, uriDef);
                try {
                    HttpCollector.this.doCollection(this, collectionResource);
                    this.m_collectionResourceList.add(collectionResource);
                }
                catch (HttpCollectorException e) {
                    HttpCollector.log().error("collect: http collection failed: " + e, (Throwable)e);
                    this.m_status = 2;
                }
            }
            this.m_status = 1;
        }

        public CollectionAgent getAgent() {
            return this.m_agent;
        }

        public void setAgent(CollectionAgent agent) {
            this.m_agent = agent;
        }

        public Map<String, Object> getParameters() {
            return this.m_parameters;
        }

        public void setParameters(Map<String, Object> parameters) {
            this.m_parameters = parameters;
        }

        public int getStatus() {
            return this.m_status;
        }

        public void storeResults(List<HttpCollectionAttribute> results, HttpCollectionResource collectionResource) {
            collectionResource.storeResults(results);
        }

        public void visit(CollectionSetVisitor visitor) {
            visitor.visitCollectionSet((CollectionSet)this);
            for (HttpCollectionResource collectionResource : this.m_collectionResourceList) {
                collectionResource.visit(visitor);
            }
            visitor.completeCollectionSet((CollectionSet)this);
        }

        public boolean ignorePersist() {
            return false;
        }

        public Date getCollectionTimestamp() {
            return this.m_timestamp;
        }

        public void setCollectionTimestamp(Date timestamp) {
            this.m_timestamp = timestamp;
        }

        public int getPort() {
            int port = this.getUriDef().getUrl().getPort();
            if (port == 80 && this.m_parameters.containsKey("port")) {
                try {
                    port = Integer.parseInt(this.m_parameters.get("port").toString());
                    HttpCollector.log().debug("getPort: using service provided HTTP port " + port);
                }
                catch (Exception e) {
                    HttpCollector.log().warn("Malformed HTTP port on service definition.");
                }
            }
            return port;
        }
    }
}

