/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.AbstractSnmpStore;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueType;

public class SnmpStore
extends AbstractSnmpStore {
    protected final NamedSnmpVar[] ms_elemList;

    public SnmpStore(NamedSnmpVar[] list) {
        this.ms_elemList = list;
    }

    public int getElementListSize() {
        return this.ms_elemList.length;
    }

    public NamedSnmpVar[] getElements() {
        return this.ms_elemList;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(((Object)((Object)this)).getClass());
    }

    public void storeResult(SnmpResult res) {
        this.putValue(res.getBase().toString(), res.getValue());
        for (NamedSnmpVar var : this.ms_elemList) {
            if (!res.getBase().equals((Object)var.getSnmpObjId())) continue;
            if (res.getValue().isError()) {
                this.log().error("storeResult: got an error for alias " + var.getAlias() + " [" + res.getBase() + "].[" + res.getInstance() + "], but we should only be getting non-errors: " + res.getValue());
                continue;
            }
            if (res.getValue().isEndOfMib()) {
                this.log().debug("storeResult: got endOfMib for alias " + var.getAlias() + " [" + res.getBase() + "].[" + res.getInstance() + "], not storing");
                continue;
            }
            SnmpValueType type = SnmpValueType.valueOf((int)res.getValue().getType());
            this.log().debug("Storing Result: alias: " + var.getAlias() + " [" + res.getBase() + "].[" + res.getInstance() + "] = " + (type == null ? "Unknown" : type.getDisplayString()) + ": " + this.toLogString(res.getValue()));
            this.putValue(var.getAlias(), res.getValue());
        }
    }

    private String toLogString(SnmpValue val) {
        if (val.getType() == 4) {
            return val.toDisplayString() + " (" + val.toHexString() + ")";
        }
        return val.toString();
    }
}

