/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.IpAddrTableEntry;
import org.opennms.netmgt.capsd.snmp.SnmpTable;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;

public class IpAddrTable
extends SnmpTable<IpAddrTableEntry> {
    public IpAddrTable(InetAddress address) {
        super(address, "ipAddrTable", IpAddrTableEntry.ms_elemList);
    }

    @Override
    protected IpAddrTableEntry createTableEntry(SnmpObjId base, SnmpInstId inst, Object val) {
        return new IpAddrTableEntry();
    }

    public InetAddress[] getIfAddressAndMask(int ifIndex) {
        for (IpAddrTableEntry entry : this) {
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || ndx != ifIndex) continue;
            InetAddress[] pair = new InetAddress[]{entry.getIpAdEntAddr(), entry.getIpAdEntNetMask()};
            return pair;
        }
        return null;
    }

    public int getIfIndex(InetAddress address) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("getIfIndex: num ipAddrTable entries: " + this.size());
        }
        for (IpAddrTableEntry entry : this) {
            InetAddress ifAddr = entry.getIpAdEntAddr();
            if (ifAddr == null || !ifAddr.equals(address)) continue;
            Integer ndx = entry.getIpAdEntIfIndex();
            this.log().debug("getIfIndex: got a match for address " + InetAddressUtils.str((InetAddress)address) + " index: " + ndx);
            if (ndx == null) continue;
            return ndx;
        }
        this.log().debug("getIfIndex: no matching ipAddrTable entry for " + InetAddressUtils.str((InetAddress)address));
        return -1;
    }

    protected final ThreadCategory log() {
        return ThreadCategory.getInstance(IpAddrTable.class);
    }

    public List<InetAddress> getIpAddresses(int index) {
        if (index == -1) {
            return null;
        }
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (IpAddrTableEntry entry : this) {
            InetAddress ifAddr;
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || ndx != index || (ifAddr = entry.getIpAdEntAddr()) == null) continue;
            addresses.add(ifAddr);
        }
        return addresses;
    }

    public List<InetAddress> getIpAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (IpAddrTableEntry entry : this) {
            InetAddress ifAddr;
            Integer ndx = entry.getIpAdEntIfIndex();
            if (ndx == null || (ifAddr = entry.getIpAdEntAddr()) == null) continue;
            addresses.add(ifAddr);
        }
        return addresses;
    }
}

