/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import org.springframework.util.StringUtils;

public class FtpResponse {
    private int m_code;
    private String[] m_response;

    public FtpResponse() {
    }

    public FtpResponse(int code, String[] response) {
        this.m_code = code;
        this.m_response = response;
    }

    public int getCode() {
        return this.m_code;
    }

    public void setCode(int code) {
        this.m_code = code;
    }

    public String[] getResponse() {
        return this.m_response;
    }

    public void setResponse(String[] response) {
        this.m_response = response;
    }

    public boolean responseContains(String contain) {
        for (String line : this.m_response) {
            if (!line.contains(contain)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_code);
        if (this.m_response.length > 1) {
            sb.append("-");
        }
        if (this.m_response.length > 0) {
            sb.append(" " + this.m_response[0]);
        }
        for (int i = 1; i < this.m_response.length; ++i) {
            sb.append("\n");
            if (i == this.m_response.length - 1) {
                sb.append(this.m_code);
                sb.append(" ");
                sb.append(this.m_response[i]);
                continue;
            }
            if (this.m_response[i].startsWith(this.m_code + " ")) {
                sb.append(" ");
                sb.append(this.m_response[i]);
                continue;
            }
            sb.append(this.m_response[i]);
        }
        return sb.toString();
    }

    public boolean isCodeValid() {
        return this.getCode() >= 100 && this.getCode() < 600;
    }

    public boolean isSuccess() {
        return this.m_code >= 200 && this.m_code < 300;
    }

    public boolean isIntermediate() {
        return this.m_code >= 300 && this.m_code < 400;
    }

    public static void sendCommand(Socket socket, String command) throws IOException {
        socket.getOutputStream().write((command + "\r\n").getBytes());
    }

    public static FtpResponse readResponse(BufferedReader in) throws IOException {
        int code;
        ArrayList<String> response = new ArrayList<String>();
        String firstResponseLine = in.readLine();
        if (firstResponseLine == null) {
            throw new IOException("End of stream was reached before a response could be read");
        }
        String codeString = firstResponseLine.substring(0, 3);
        response.add(firstResponseLine.substring(4));
        try {
            code = Integer.parseInt(codeString);
        }
        catch (NumberFormatException e) {
            IOException newE = new IOException("First response line returned a non-numeric result code \"" + codeString + "\": " + firstResponseLine);
            newE.initCause(e);
            throw newE;
        }
        if ("-".equals(firstResponseLine.substring(3, 4))) {
            String endMultiLine = code + " ";
            while (true) {
                String subsequentResponse;
                if ((subsequentResponse = in.readLine()) == null) {
                    throw new IOException("End of stream was reached before the complete multi-line response could be read.  What was read: " + StringUtils.collectionToDelimitedString(response, (String)"\n"));
                }
                if (subsequentResponse.startsWith(endMultiLine)) {
                    response.add(subsequentResponse.substring(4));
                    break;
                }
                response.add(subsequentResponse);
            }
        }
        return new FtpResponse(code, response.toArray(new String[response.size()]));
    }
}

