/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import junit.framework.AssertionFailedError;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcHandler;
import org.junit.Assert;

public class XmlrpcAnticipator
implements XmlRpcHandler {
    private List<XmlrpcCall> m_anticipated = new ArrayList<XmlrpcCall>();
    private List<XmlrpcCall> m_unanticipated = new ArrayList<XmlrpcCall>();
    private WebServer m_webServer = null;
    private int m_port;
    private static final int DEFAULT_PORT_NUMBER = 9000;
    private Logger m_logger = Logger.getLogger((String)this.getClass().getName());
    private static final String CHECK_METHOD_NAME = "XmlrpcAnticipatorCheck";

    public XmlrpcAnticipator(int port, boolean delayWebServer) throws IOException {
        this.m_port = port;
        if (!delayWebServer) {
            this.setupWebServer();
        }
    }

    public XmlrpcAnticipator(int port) throws IOException {
        this(port, false);
    }

    public XmlrpcAnticipator() throws IOException {
        this(9000, false);
    }

    public void setupWebServer() throws IOException {
        this.m_logger.info((Object)("XmlrpcAnticipator starting on port number " + this.m_port));
        this.m_webServer = new WebServer(this.m_port);
        this.m_webServer.addHandler("$default", (Object)this);
        this.m_webServer.start();
        this.waitForStartup();
        this.m_logger.info((Object)("XmlrpcAnticipator running on port number " + this.m_port));
    }

    public void shutdown() throws IOException {
        if (this.m_webServer == null) {
            return;
        }
        this.m_webServer.shutdown();
        this.waitForShutdown();
        this.m_webServer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForStartup() throws IOException {
        boolean keepRunning = true;
        Socket s = null;
        while (keepRunning) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                s = new Socket("localhost", this.m_port);
                keepRunning = false;
                this.sendCheckCall(s);
            }
            catch (ConnectException connectException) {}
            continue;
            finally {
                if (s == null) continue;
                s.close();
            }
        }
    }

    private void sendCheckCall(Socket s) throws IOException {
        PrintWriter p = new PrintWriter(s.getOutputStream());
        p.print("POST / HTTP/1.0\r\n");
        p.print("Connection: close\r\n");
        p.print("\r\n");
        p.print("<?xml.version=\"1.0\"?><methodCall><methodName>XmlrpcAnticipatorCheck</methodName><params></params></methodCall>\r\n");
        p.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForShutdown() throws IOException {
        boolean keepRunning = true;
        Socket s = null;
        while (keepRunning) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                s = new Socket("localhost", this.m_port);
                this.sendCheckCall(s);
            }
            catch (ConnectException e) {
                keepRunning = false;
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
    }

    public void anticipateCall(String method, Object ... args) {
        Vector<Object> params = new Vector<Object>();
        for (Object arg : args) {
            params.add(arg);
        }
        this.m_anticipated.add(new XmlrpcCall(method, params));
    }

    public Object execute(String method, Vector vector) {
        if (this.m_webServer == null) {
            String message = "Hey!  We aren't initialized (anymore)!  We should not be receiving execute calls!";
            System.err.println(message);
            System.err.println(new XmlrpcCall(method, vector));
            vector.add(message);
            return vector;
        }
        this.ourExecute(method, vector);
        return vector;
    }

    public synchronized void ourExecute(String method, Vector<Object> vector) {
        if (method.equals(CHECK_METHOD_NAME)) {
            return;
        }
        XmlrpcCall c = new XmlrpcCall(method, vector);
        if (this.m_anticipated.contains(c)) {
            this.m_anticipated.remove(c);
        } else {
            this.m_unanticipated.add(c);
        }
    }

    public synchronized Collection<XmlrpcCall> getAnticipated() {
        return Collections.unmodifiableCollection(this.m_anticipated);
    }

    public void reset() {
        this.m_anticipated = new ArrayList<XmlrpcCall>();
        this.m_unanticipated = new ArrayList<XmlrpcCall>();
    }

    public Collection<XmlrpcCall> unanticipatedEvents() {
        return Collections.unmodifiableCollection(this.m_unanticipated);
    }

    public void verifyAnticipated() {
        StringBuffer problems = new StringBuffer();
        if (this.m_anticipated.size() > 0) {
            problems.append(this.m_anticipated.size() + " expected calls still outstanding:\n");
            problems.append(XmlrpcAnticipator.listCalls("\t", this.m_anticipated));
        }
        if (this.m_unanticipated.size() > 0) {
            problems.append(this.m_unanticipated.size() + " unanticipated calls received:\n");
            problems.append(XmlrpcAnticipator.listCalls("\t", this.m_unanticipated));
        }
        if (problems.length() > 0) {
            problems.deleteCharAt(problems.length() - 1);
            problems.insert(0, "XML-RPC Anticipator listening at port " + this.m_port + " has:\n");
            throw new AssertionFailedError(problems.toString());
        }
    }

    private static String listCalls(String prefix, Collection<XmlrpcCall> calls) {
        StringBuffer b = new StringBuffer();
        for (XmlrpcCall call : calls) {
            b.append(prefix);
            b.append(call);
            b.append("\n");
        }
        return b.toString();
    }

    protected void finalize() {
        try {
            this.shutdown();
        }
        catch (IOException e) {
            System.err.println("IOException received while shutting down WebServer in finalize()");
            e.printStackTrace();
        }
    }

    public class XmlrpcCall {
        private String m_method;
        private Vector<Object> m_vector;

        public XmlrpcCall(String method, Vector<Object> vector) {
            Assert.assertNotNull((String)"null method not allowed", (Object)method);
            Assert.assertNotNull((String)"null vector not allowed", vector);
            this.m_method = method;
            this.m_vector = vector;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("Method: " + this.m_method + "\n");
            for (Object o : this.m_vector) {
                b.append("Parameter (" + o.getClass().getName() + ") " + o + "\n");
            }
            return b.toString();
        }

        public int hashCode() {
            return new HashCodeBuilder(9, 3).append((Object)this.m_method).append(this.m_vector).toHashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof XmlrpcCall)) {
                return false;
            }
            XmlrpcCall c = (XmlrpcCall)o;
            if (!this.m_method.equals(c.m_method)) {
                return false;
            }
            if (this.m_vector.size() != c.m_vector.size()) {
                return false;
            }
            for (int i = 0; i < this.m_vector.size(); ++i) {
                Object a = this.m_vector.get(i);
                Object b = c.m_vector.get(i);
                if (!a.getClass().getName().equals(b.getClass().getName())) {
                    return false;
                }
                if (!(a instanceof Hashtable ? !this.hashtablesMatchIgnoringDescriptionKeys(a, b) : !a.equals(b))) continue;
                return false;
            }
            return true;
        }

        private boolean hashtablesMatchIgnoringDescriptionKeys(Object a, Object b) {
            Hashtable ha = (Hashtable)a;
            Hashtable hb = (Hashtable)b;
            if (ha.size() != hb.size()) {
                return false;
            }
            if (!((Object)ha.keySet()).equals(hb.keySet())) {
                return false;
            }
            for (String key : ha.keySet()) {
                if (!(key.equals("description") ? !hb.containsKey(key) : !((String)ha.get(key)).equals(hb.get(key)))) continue;
                return false;
            }
            return true;
        }
    }
}

