/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.trapd;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.trapd.TrapdIpMgr;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/trapdIpMgr-test.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class HibernateTrapdIpMgrTest
implements InitializingBean {
    @Autowired
    TrapdIpMgr m_trapdIpMgr;
    @Autowired
    DatabasePopulator m_databasePopulator;
    int m_testNodeId;

    public void afterPropertiesSet() throws Exception {
        Assert.assertNotNull((Object)this.m_trapdIpMgr);
    }

    @Before
    public void setUp() throws Exception {
        this.m_databasePopulator.populateDatabase();
        this.m_trapdIpMgr.dataSourceSync();
        OnmsNode n = new OnmsNode((OnmsDistPoller)this.m_databasePopulator.getDistPollerDao().get((Serializable)((Object)"localhost")), "my-new-node");
        n.setForeignSource("junit");
        n.setForeignId("10001");
        OnmsIpInterface iface = new OnmsIpInterface("192.168.1.3", n);
        iface.setIsManaged("M");
        iface.setIsSnmpPrimary(OnmsIpInterface.PrimaryType.PRIMARY);
        OnmsSnmpInterface snmpIf = new OnmsSnmpInterface(n, 1001);
        iface.setSnmpInterface(snmpIf);
        snmpIf.getIpInterfaces().add(iface);
        n.addIpInterface(iface);
        this.m_databasePopulator.getNodeDao().save((Object)n);
        this.m_testNodeId = n.getId();
    }

    @Test
    @Transactional
    public void testTrapdIpMgrSetId() throws Exception {
        String ipAddr = this.m_databasePopulator.getNode2().getPrimaryInterface().getIpAddress().getHostAddress();
        long expectedNodeId = Long.parseLong(this.m_databasePopulator.getNode2().getNodeId());
        long nodeId = this.m_trapdIpMgr.getNodeId(ipAddr);
        Assert.assertEquals((long)expectedNodeId, (long)nodeId);
        Assert.assertEquals((long)-1L, (long)this.m_trapdIpMgr.setNodeId("192.168.1.3", 1L));
        Assert.assertEquals((long)1L, (long)this.m_trapdIpMgr.setNodeId("192.168.1.3", (long)this.m_testNodeId));
        Assert.assertEquals((long)this.m_testNodeId, (long)this.m_trapdIpMgr.getNodeId("192.168.1.3"));
    }
}

