/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.poller.IfKey;
import org.opennms.netmgt.poller.QueryManager;

public class MockQueryManager
implements QueryManager {
    private final MockNetwork m_network;

    public void setDataSource(DataSource dataSource) {
    }

    public DataSource getDataSource() {
        return null;
    }

    public MockQueryManager(MockNetwork network) {
        this.m_network = network;
    }

    public boolean activeServiceExists(String whichEvent, int nodeId, String ipAddr, String serviceName) {
        return this.m_network.getService(nodeId, ipAddr, serviceName) != null;
    }

    public List<Integer> getActiveServiceIdsForInterface(final String ipaddr) throws SQLException {
        final HashSet serviceIds = new HashSet();
        MockVisitorAdapter gatherServices = new MockVisitorAdapter(){

            public void visitService(MockService s) {
                if (ipaddr.equals(s.getInterface().getIpAddr())) {
                    serviceIds.add(new Integer(s.getId()));
                }
            }
        };
        this.m_network.visit((MockVisitor)gatherServices);
        return new ArrayList<Integer>(serviceIds);
    }

    public List<IfKey> getInterfacesWithService(final String svcName) throws SQLException {
        final ArrayList<IfKey> ifKeys = new ArrayList<IfKey>();
        MockVisitorAdapter gatherInterfaces = new MockVisitorAdapter(){

            public void visitService(MockService s) {
                if (s.getSvcName().equals(svcName)) {
                    int nodeId = s.getInterface().getNode().getNodeId();
                    String ipAddr = s.getInterface().getIpAddr();
                    ifKeys.add(new IfKey(nodeId, ipAddr));
                }
            }
        };
        this.m_network.visit((MockVisitor)gatherInterfaces);
        return ifKeys;
    }

    public int getNodeIDForInterface(String ipaddr) throws SQLException {
        return this.m_network.getNodeIdForInterface(ipaddr);
    }

    public String getNodeLabel(int nodeId) throws SQLException {
        MockNode node = this.m_network.getNode(nodeId);
        return node == null ? null : node.getLabel();
    }

    public int getServiceCountForInterface(String ipaddr) throws SQLException {
        return this.getActiveServiceIdsForInterface(ipaddr).size();
    }

    public Date getServiceLostDate(int nodeId, String ipAddr, String svcName, int serviceId) {
        return null;
    }

    public void openOutage(String outageIdSQL, int nodeId, String ipAddr, String svcName, int dbid, String time) {
    }

    public void resolveOutage(int nodeId, String ipAddr, String svcName, int dbid, String time) {
    }

    public void reparentOutages(String ipAddr, int oldNodeId, int newNodeId) {
    }

    public String[] getCriticalPath(int nodeId) {
        throw new UnsupportedOperationException("MockQueryManager.getCriticalPath is not yet implemented");
    }

    public List<String[]> getNodeServices(int nodeId) {
        return null;
    }
}

