/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import junit.framework.TestCase;
import org.opennms.netmgt.mock.MapSubAgent;
import org.opennms.netmgt.mock.MockAgent;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockProxy;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableUtils;

public class MockAgentTest
extends TestCase {
    private MockNetwork m_network;
    private MockProxy m_proxy;

    protected void setUp() throws Exception {
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService("ICMP");
        this.m_network.addNode(1, "Router");
        this.m_network.addInterface("192.168.1.1");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addInterface("192.168.1.2");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addNode(2, "Server");
        this.m_network.addInterface("192.168.1.3");
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP");
        this.m_network.addInterface("192.168.1.2");
        MapSubAgent systemGroup = new MapSubAgent("1.3.6.1.2.1.1");
        systemGroup.put("1.0", (Variable)new OctetString("MockAgent!"));
        systemGroup.put("2.0", (Variable)new OID("1.3.6.1.4.1.5813.1"));
        systemGroup.put("3.0", (Variable)new TimeTicks(1234L));
        systemGroup.put("4.0", (Variable)new OctetString("Mr. Personality"));
        systemGroup.put("5.0", (Variable)new OctetString("mockhost"));
        systemGroup.put("6.0", (Variable)new OctetString("Wouldn't you like to know"));
        MapSubAgent interfaces = new MapSubAgent("1.3.6.1.2.1.2");
        interfaces.put("1.0", (Variable)new Integer32(2));
        this.m_proxy = new MockProxy(9161);
        MockAgent agent = new MockAgent();
        agent.addSubAgent(systemGroup);
        agent.addSubAgent(interfaces);
        this.m_proxy.addAgent(agent);
    }

    protected void tearDown() throws Exception {
        this.m_proxy.stop();
        MockLogAppender.assertNoWarningsOrGreater();
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
    }

    public void testWalkSystem() throws IOException {
        Snmp snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
        TableUtils walker = new TableUtils((Session)snmp, (PDUFactory)new DefaultPDUFactory());
        snmp.listen();
        UdpAddress addr = new UdpAddress(InetAddress.getLocalHost(), 9161);
        CommunityTarget target = new CommunityTarget((Address)addr, new OctetString("public"));
        target.setVersion(0);
        target.setTimeout(3000L);
        target.setRetries(3);
        List results = walker.getTable((Target)target, new OID[]{new OID("1.3.6.1.2.1.1")}, null, null);
        MockAgentTest.assertNotNull((Object)results);
        MockAgentTest.assertFalse((boolean)results.isEmpty());
        MockAgentTest.assertTrue((boolean)(results.get(results.size() - 1) instanceof TableEvent));
        TableEvent lastEvent = (TableEvent)results.get(results.size() - 1);
        MockUtil.println((String)("Status of lastEvent is " + lastEvent.getStatus()));
        MockAgentTest.assertEquals((int)0, (int)lastEvent.getStatus());
    }

    public void testGetSysName() throws IOException {
        Snmp snmp = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
        snmp.listen();
        UdpAddress addr = new UdpAddress(InetAddress.getLocalHost(), 9161);
        CommunityTarget target = new CommunityTarget((Address)addr, new OctetString("public"));
        target.setVersion(0);
        target.setTimeout(3000L);
        target.setRetries(3);
        PDUv1 getRequest = new PDUv1();
        getRequest.add(new VariableBinding(new OID("1.3.6.1.2.1.1.5.0")));
        ResponseEvent e = snmp.get((PDU)getRequest, (Target)target);
        PDU response = e.getResponse();
        MockAgentTest.assertEquals((Object)new OctetString("mockhost"), (Object)response.get(0).getVariable());
    }
}

