/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.PollOutagesConfigManager;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class PollOutagesConfigManagerTest
extends TestCase {
    private PollOutagesConfigManager m_manager;

    public static void main(String[] args) {
        TestRunner.run(PollOutagesConfigManagerTest.class);
    }

    protected void setUp() throws Exception {
        MockLogAppender.setupLogging();
        String xml = "<?xml version=\"1.0\"?>\n<outages>\n   <outage name=\"one\" type=\"weekly\">\n       <time day=\"sunday\" begins=\"12:30:00\" ends=\"12:45:00\"/>\n       <time day=\"sunday\" begins=\"13:30:00\" ends=\"14:45:00\"/>\n       <time day=\"monday\" begins=\"13:30:00\" ends=\"14:45:00\"/>\n       <time day=\"tuesday\" begins=\"13:00:00\" ends=\"14:45:00\"/>\n       <interface address=\"192.168.0.1\"/>\n       <interface address=\"192.168.0.36\"/>\n       <interface address=\"192.168.0.38\"/>\n   </outage>\n\n   <outage name=\"two\" type=\"monthly\">\n       <time day=\"1\" begins=\"23:30:00\" ends=\"23:45:00\"/>\n       <time day=\"15\" begins=\"21:30:00\" ends=\"21:45:00\"/>\n       <time day=\"15\" begins=\"23:30:00\" ends=\"23:45:00\"/>\n       <interface address=\"192.168.100.254\"/>\n       <interface address=\"192.168.101.254\"/>\n       <interface address=\"192.168.102.254\"/>\n       <interface address=\"192.168.103.254\"/>\n       <interface address=\"192.168.104.254\"/>\n       <interface address=\"192.168.105.254\"/>\n       <interface address=\"192.168.106.254\"/>\n       <interface address=\"192.168.107.254\"/>\n   </outage>\n\n   <outage name=\"three\" type=\"specific\">\n       <time begins=\"21-Feb-2005 05:30:00\" ends=\"21-Feb-2005 15:00:00\"/>\n       <interface address=\"192.168.0.1\"/>\n   </outage>\n</outages>\n";
        this.m_manager = new PollOutagesConfigManager(){

            public void update() throws IOException, MarshalException, ValidationException {
            }
        };
        this.m_manager.setConfigResource((Resource)new ByteArrayResource(xml.getBytes()));
        this.m_manager.afterPropertiesSet();
    }

    protected void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    private long getTime(String timeString) throws ParseException {
        Date date = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").parse(timeString);
        return date.getTime();
    }

    public void testIsTimeInOutageWeekly() throws Exception {
        PollOutagesConfigManagerTest.assertTrue((boolean)this.m_manager.isTimeInOutage(this.getTime("21-FEB-2005 14:00:00"), "one"));
        PollOutagesConfigManagerTest.assertFalse((boolean)this.m_manager.isTimeInOutage(this.getTime("21-FEB-2005 14:00:00"), "two"));
        PollOutagesConfigManagerTest.assertTrue((boolean)this.m_manager.isTimeInOutage(this.getTime("21-FEB-2005 14:00:00"), "three"));
        PollOutagesConfigManagerTest.assertTrue((boolean)this.m_manager.isTimeInOutage(this.getTime("15-FEB-2005 14:00:00"), "one"));
        PollOutagesConfigManagerTest.assertFalse((boolean)this.m_manager.isTimeInOutage(this.getTime("15-FEB-2005 14:00:00"), "two"));
        PollOutagesConfigManagerTest.assertFalse((boolean)this.m_manager.isTimeInOutage(this.getTime("15-FEB-2005 14:00:00"), "three"));
        PollOutagesConfigManagerTest.assertFalse((boolean)this.m_manager.isTimeInOutage(this.getTime("15-FEB-2005 23:37:00"), "one"));
        PollOutagesConfigManagerTest.assertTrue((boolean)this.m_manager.isTimeInOutage(this.getTime("15-FEB-2005 23:37:00"), "two"));
        PollOutagesConfigManagerTest.assertFalse((boolean)this.m_manager.isTimeInOutage(this.getTime("15-FEB-2005 23:37:00"), "three"));
        PollOutagesConfigManagerTest.assertFalse((boolean)this.m_manager.isTimeInOutage(this.getTime("21-FEB-2005 16:00:00"), "one"));
        PollOutagesConfigManagerTest.assertFalse((boolean)this.m_manager.isTimeInOutage(this.getTime("21-FEB-2005 16:00:00"), "two"));
        PollOutagesConfigManagerTest.assertFalse((boolean)this.m_manager.isTimeInOutage(this.getTime("21-FEB-2005 16:00:00"), "three"));
    }
}

