/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import junit.framework.TestSuite;
import org.opennms.core.test.snmp.SnmpTestSuiteUtils;
import org.opennms.netmgt.collectd.CollectionInitializationException;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.ResourceVisitor;
import org.opennms.netmgt.collectd.SnmpCollectorTestCase;
import org.opennms.netmgt.collectd.SnmpIfCollector;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.collector.CollectionSet;
import org.opennms.netmgt.config.collector.CollectionSetVisitor;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmp.CollectionTracker;

public class SnmpIfCollectorTest
extends SnmpCollectorTestCase {
    public static TestSuite suite() {
        return SnmpTestSuiteUtils.createSnmpVersionTestSuite(SnmpIfCollectorTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testZeroVars() throws Exception {
        this.createSnmpInterface(1, 24, "lo", true);
        SnmpIfCollector collector = this.createSnmpIfCollector();
        this.waitForSignal();
        this.assertInterfaceMibObjectsPresent(collector.getCollectionSet(), 1);
    }

    private void assertInterfaceMibObjectsPresent(CollectionSet collectionSet, int expectedIfCount) {
        SnmpIfCollectorTest.assertNotNull((Object)collectionSet);
        if (this.getAttributeList().isEmpty()) {
            return;
        }
        IfInfoVisitor ifInfoVisitor = new IfInfoVisitor();
        collectionSet.visit((CollectionSetVisitor)ifInfoVisitor);
        SnmpIfCollectorTest.assertEquals((String)"Unexpected number of interfaces", (int)expectedIfCount, (int)ifInfoVisitor.ifInfoCount);
    }

    public void testInvalidVar() throws Exception {
        this.addAttribute("invalid", "1.3.6.1.2.1.2.2.2.10", "ifIndex", "counter");
        SnmpIfCollectorTest.assertFalse((boolean)this.getAttributeList().isEmpty());
        this.createSnmpInterface(1, 24, "lo", true);
        SnmpIfCollector collector = this.createSnmpIfCollector();
        this.waitForSignal();
        this.getAttributeList().remove(0);
        this.assertInterfaceMibObjectsPresent(collector.getCollectionSet(), 1);
    }

    public void testBadApple() throws Exception {
        this.addIfSpeed();
        this.addIfInOctets();
        this.addAttribute("invalid", "1.3.66.1.2.1.2.2.299.16", "ifIndex", "counter");
        this.addIfInErrors();
        this.addIfOutErrors();
        this.addIfInDiscards();
        SnmpIfCollectorTest.assertFalse((boolean)this.getAttributeList().isEmpty());
        this.createSnmpInterface(1, 24, "lo", true);
        SnmpIfCollector collector = this.createSnmpIfCollector();
        this.waitForSignal();
        this.getAttributeList().remove(2);
        this.assertInterfaceMibObjectsPresent(collector.getCollectionSet(), 1);
    }

    public void testManyVars() throws Exception {
        this.addIfTable();
        SnmpIfCollectorTest.assertFalse((boolean)this.getAttributeList().isEmpty());
        this.createSnmpInterface(1, 24, "lo", true);
        SnmpIfCollector collector = this.createSnmpIfCollector();
        this.waitForSignal();
        this.assertInterfaceMibObjectsPresent(collector.getCollectionSet(), 1);
    }

    private SnmpIfCollector createSnmpIfCollector() throws UnknownHostException, CollectionInitializationException {
        this.initializeAgent();
        SnmpIfCollector collector = new SnmpIfCollector(InetAddress.getLocalHost(), this.getCollectionSet().getCombinedIndexedAttributes(), this.getCollectionSet());
        this.createWalker((CollectionTracker)collector);
        return collector;
    }

    private OnmsEntity createSnmpInterface(int ifIndex, int ifType, String ifName, boolean collectionEnabled) {
        OnmsSnmpInterface m_snmpIface = new OnmsSnmpInterface();
        m_snmpIface.setIfIndex(Integer.valueOf(ifIndex));
        m_snmpIface.setIfType(Integer.valueOf(ifType));
        m_snmpIface.setIfName(ifName);
        m_snmpIface.setCollectionEnabled(collectionEnabled);
        this.m_node.addSnmpInterface(m_snmpIface);
        return m_snmpIface;
    }

    public void testManyIfs() throws Exception {
        this.addIfTable();
        SnmpIfCollectorTest.assertFalse((boolean)this.getAttributeList().isEmpty());
        this.createSnmpInterface(1, 24, "lo0", true);
        this.createSnmpInterface(2, 55, "gif0", true);
        this.createSnmpInterface(3, 57, "stf0", true);
        SnmpIfCollector collector = this.createSnmpIfCollector();
        this.waitForSignal();
        this.assertInterfaceMibObjectsPresent(collector.getCollectionSet(), 3);
    }

    private final class IfInfoVisitor
    extends ResourceVisitor {
        public int ifInfoCount = 0;

        private IfInfoVisitor() {
        }

        public void visitResource(CollectionResource resource) {
            if (!(resource instanceof IfInfo)) {
                return;
            }
            ++this.ifInfoCount;
            IfInfo ifInfo = (IfInfo)resource;
            SnmpIfCollectorTest.this.assertMibObjectsPresent((CollectionResource)ifInfo, SnmpIfCollectorTest.this.getAttributeList());
        }
    }
}

